/*
 * Decompiled with CFR 0.152.
 */
package com.koloboke.collect.impl.hash;

import com.koloboke.collect.LongCollection;
import com.koloboke.collect.hash.HashConfig;
import com.koloboke.collect.impl.hash.ImmutableQHashLongSet;
import com.koloboke.collect.impl.hash.ImmutableQHashLongSetGO;
import com.koloboke.collect.impl.hash.LongQHashFactory;
import com.koloboke.collect.impl.hash.MutableQHashLongSet;
import com.koloboke.collect.impl.hash.MutableQHashLongSetGO;
import com.koloboke.collect.impl.hash.SeparateKVLongQHash;
import com.koloboke.collect.impl.hash.UpdatableQHashLongSet;
import com.koloboke.collect.impl.hash.UpdatableQHashLongSetGO;
import com.koloboke.collect.set.hash.HashLongSetFactory;
import java.util.Collection;
import java.util.Set;
import javax.annotation.Nonnull;

public abstract class QHashLongSetFactorySO
extends LongQHashFactory<MutableQHashLongSetGO>
implements HashLongSetFactory {
    QHashLongSetFactorySO(HashConfig hashConf, int defaultExpectedSize, long lower, long upper) {
        super(hashConf, defaultExpectedSize, lower, upper);
    }

    @Override
    MutableQHashLongSetGO createNewMutable(int expectedSize, long free, long removed) {
        MutableQHashLongSet set = new MutableQHashLongSet();
        set.init(this.configWrapper, expectedSize, free, removed);
        return set;
    }

    MutableQHashLongSetGO uninitializedMutableSet() {
        return new MutableQHashLongSet();
    }

    UpdatableQHashLongSetGO uninitializedUpdatableSet() {
        return new UpdatableQHashLongSet();
    }

    ImmutableQHashLongSetGO uninitializedImmutableSet() {
        return new ImmutableQHashLongSet();
    }

    @Nonnull
    public MutableQHashLongSetGO newMutableSet(int expectedSize) {
        return (MutableQHashLongSetGO)this.newMutableHash(expectedSize);
    }

    @Nonnull
    public UpdatableQHashLongSetGO newUpdatableSet(int expectedSize) {
        UpdatableQHashLongSet set = new UpdatableQHashLongSet();
        set.init(this.configWrapper, expectedSize, this.getFree());
        return set;
    }

    @Nonnull
    public UpdatableQHashLongSetGO newUpdatableSet(Iterable<Long> elements, int expectedSize) {
        if (elements instanceof LongCollection) {
            SeparateKVLongQHash hash;
            if (elements instanceof SeparateKVLongQHash && (hash = (SeparateKVLongQHash)((Object)elements)).hashConfig().equals(this.hashConf)) {
                UpdatableQHashLongSet set = new UpdatableQHashLongSet();
                set.copy(hash);
                return set;
            }
            int size = elements instanceof Set ? ((Set)elements).size() : expectedSize;
            UpdatableQHashLongSetGO set = this.newUpdatableSet(size);
            set.addAll((Collection)elements);
            return set;
        }
        int size = elements instanceof Set ? ((Set)elements).size() : expectedSize;
        UpdatableQHashLongSetGO set = this.newUpdatableSet(size);
        for (long e : elements) {
            set.add(e);
        }
        return set;
    }
}

