/*
 * Decompiled with CFR 0.152.
 */
package com.koloboke.collect.impl.hash;

import com.koloboke.collect.Equivalence;
import com.koloboke.collect.IntCollection;
import com.koloboke.collect.IntCursor;
import com.koloboke.collect.IntIterator;
import com.koloboke.collect.ObjCollection;
import com.koloboke.collect.ObjCursor;
import com.koloboke.collect.ObjIterator;
import com.koloboke.collect.hash.HashConfig;
import com.koloboke.collect.impl.AbstractEntry;
import com.koloboke.collect.impl.AbstractIntValueView;
import com.koloboke.collect.impl.AbstractSetView;
import com.koloboke.collect.impl.CommonFloatIntMapOps;
import com.koloboke.collect.impl.CommonMapOps;
import com.koloboke.collect.impl.CommonObjCollectionOps;
import com.koloboke.collect.impl.InternalFloatIntMapOps;
import com.koloboke.collect.impl.InternalMapOps;
import com.koloboke.collect.impl.InternalObjCollectionOps;
import com.koloboke.collect.impl.Primitives;
import com.koloboke.collect.impl.UnsafeConstants;
import com.koloboke.collect.impl.hash.LHash;
import com.koloboke.collect.impl.hash.ParallelKVFloatIntLHash;
import com.koloboke.collect.impl.hash.UpdatableLHashParallelKVFloatIntMapSO;
import com.koloboke.collect.map.FloatIntCursor;
import com.koloboke.collect.set.IntSet;
import com.koloboke.collect.set.ObjSet;
import com.koloboke.collect.set.hash.HashObjSet;
import com.koloboke.function.FloatIntConsumer;
import com.koloboke.function.FloatIntPredicate;
import com.koloboke.function.FloatIntToIntFunction;
import com.koloboke.function.FloatToIntFunction;
import java.lang.reflect.Array;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.IntBinaryOperator;
import java.util.function.IntConsumer;
import java.util.function.IntPredicate;
import java.util.function.Predicate;
import javax.annotation.Nonnull;

public class UpdatableLHashParallelKVFloatIntMapGO
extends UpdatableLHashParallelKVFloatIntMapSO {
    final void copy(ParallelKVFloatIntLHash hash) {
        int myMC = this.modCount();
        int hashMC = hash.modCount();
        super.copy(hash);
        if (myMC != this.modCount() || hashMC != hash.modCount()) {
            throw new ConcurrentModificationException();
        }
    }

    final void move(ParallelKVFloatIntLHash hash) {
        int myMC = this.modCount();
        int hashMC = hash.modCount();
        super.move(hash);
        if (myMC != this.modCount() || hashMC != hash.modCount()) {
            throw new ConcurrentModificationException();
        }
    }

    public int defaultValue() {
        return 0;
    }

    public boolean containsEntry(float key, int value) {
        int k = Float.floatToIntBits(key);
        long[] tab = this.table;
        int capacityMask = tab.length - 1;
        int index = LHash.ParallelKVFloatKeyMixing.mix((int)k) & capacityMask;
        long entry = tab[index];
        int cur = (int)entry;
        if (cur == k) {
            return (int)(entry >>> 32) == value;
        }
        if (cur == 0x7FFFFFFE) {
            return false;
        }
        do {
            if ((cur = (int)(entry = tab[index = index - 1 & capacityMask])) != k) continue;
            return (int)(entry >>> 32) == value;
        } while (cur != 0x7FFFFFFE);
        return false;
    }

    public boolean containsEntry(int key, int value) {
        long[] tab = this.table;
        int capacityMask = tab.length - 1;
        int index = LHash.ParallelKVFloatKeyMixing.mix((int)key) & capacityMask;
        long entry = tab[index];
        int cur = (int)entry;
        if (cur == key) {
            return (int)(entry >>> 32) == value;
        }
        if (cur == 0x7FFFFFFE) {
            return false;
        }
        do {
            if ((cur = (int)(entry = tab[index = index - 1 & capacityMask])) != key) continue;
            return (int)(entry >>> 32) == value;
        } while (cur != 0x7FFFFFFE);
        return false;
    }

    public Integer get(Object key) {
        int k = Float.floatToIntBits(((Float)key).floatValue());
        long[] tab = this.table;
        int capacityMask = tab.length - 1;
        int index = LHash.ParallelKVFloatKeyMixing.mix((int)k) & capacityMask;
        long entry = tab[index];
        int cur = (int)entry;
        if (cur == k) {
            return (int)(entry >>> 32);
        }
        if (cur == 0x7FFFFFFE) {
            return null;
        }
        do {
            if ((cur = (int)(entry = tab[index = index - 1 & capacityMask])) != k) continue;
            return (int)(entry >>> 32);
        } while (cur != 0x7FFFFFFE);
        return null;
    }

    public int get(float key) {
        int k = Float.floatToIntBits(key);
        long[] tab = this.table;
        int capacityMask = tab.length - 1;
        int index = LHash.ParallelKVFloatKeyMixing.mix((int)k) & capacityMask;
        long entry = tab[index];
        int cur = (int)entry;
        if (cur == k) {
            return (int)(entry >>> 32);
        }
        if (cur == 0x7FFFFFFE) {
            return this.defaultValue();
        }
        do {
            if ((cur = (int)(entry = tab[index = index - 1 & capacityMask])) != k) continue;
            return (int)(entry >>> 32);
        } while (cur != 0x7FFFFFFE);
        return this.defaultValue();
    }

    public Integer getOrDefault(Object key, Integer defaultValue) {
        int k = Float.floatToIntBits(((Float)key).floatValue());
        long[] tab = this.table;
        int capacityMask = tab.length - 1;
        int index = LHash.ParallelKVFloatKeyMixing.mix((int)k) & capacityMask;
        long entry = tab[index];
        int cur = (int)entry;
        if (cur == k) {
            return (int)(entry >>> 32);
        }
        if (cur == 0x7FFFFFFE) {
            return defaultValue;
        }
        do {
            if ((cur = (int)(entry = tab[index = index - 1 & capacityMask])) != k) continue;
            return (int)(entry >>> 32);
        } while (cur != 0x7FFFFFFE);
        return defaultValue;
    }

    public int getOrDefault(float key, int defaultValue) {
        int k = Float.floatToIntBits(key);
        long[] tab = this.table;
        int capacityMask = tab.length - 1;
        int index = LHash.ParallelKVFloatKeyMixing.mix((int)k) & capacityMask;
        long entry = tab[index];
        int cur = (int)entry;
        if (cur == k) {
            return (int)(entry >>> 32);
        }
        if (cur == 0x7FFFFFFE) {
            return defaultValue;
        }
        do {
            if ((cur = (int)(entry = tab[index = index - 1 & capacityMask])) != k) continue;
            return (int)(entry >>> 32);
        } while (cur != 0x7FFFFFFE);
        return defaultValue;
    }

    public void forEach(BiConsumer<? super Float, ? super Integer> action) {
        if (action == null) {
            throw new NullPointerException();
        }
        if (this.isEmpty()) {
            return;
        }
        int mc = this.modCount();
        long[] tab = this.table;
        for (int i = tab.length - 1; i >= 0; --i) {
            long entry = tab[i];
            int key = (int)entry;
            if (key >= 0x7FFFFFFE) continue;
            action.accept(Float.valueOf(Float.intBitsToFloat(key)), (Integer)((int)(entry >>> 32)));
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
    }

    public void forEach(FloatIntConsumer action) {
        if (action == null) {
            throw new NullPointerException();
        }
        if (this.isEmpty()) {
            return;
        }
        int mc = this.modCount();
        long[] tab = this.table;
        for (int i = tab.length - 1; i >= 0; --i) {
            long entry = tab[i];
            int key = (int)entry;
            if (key >= 0x7FFFFFFE) continue;
            action.accept(Float.intBitsToFloat(key), (int)(entry >>> 32));
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
    }

    public boolean forEachWhile(FloatIntPredicate predicate) {
        if (predicate == null) {
            throw new NullPointerException();
        }
        if (this.isEmpty()) {
            return true;
        }
        boolean terminated = false;
        int mc = this.modCount();
        long[] tab = this.table;
        for (int i = tab.length - 1; i >= 0; --i) {
            long entry = tab[i];
            int key = (int)entry;
            if (key >= 0x7FFFFFFE || predicate.test(Float.intBitsToFloat(key), (int)(entry >>> 32))) continue;
            terminated = true;
            break;
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
        return !terminated;
    }

    @Nonnull
    public FloatIntCursor cursor() {
        int mc = this.modCount();
        return new NoRemovedMapCursor(mc);
    }

    public boolean containsAllEntries(Map<?, ?> m) {
        return CommonFloatIntMapOps.containsAllEntries((InternalFloatIntMapOps)this, m);
    }

    public boolean allEntriesContainingIn(InternalFloatIntMapOps m) {
        if (this.isEmpty()) {
            return true;
        }
        boolean containsAll = true;
        int mc = this.modCount();
        long[] tab = this.table;
        for (int i = tab.length - 1; i >= 0; --i) {
            long entry = tab[i];
            int key = (int)entry;
            if (key >= 0x7FFFFFFE || m.containsEntry(key, (int)(entry >>> 32))) continue;
            containsAll = false;
            break;
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
        return containsAll;
    }

    public void reversePutAllTo(InternalFloatIntMapOps m) {
        if (this.isEmpty()) {
            return;
        }
        int mc = this.modCount();
        long[] tab = this.table;
        for (int i = tab.length - 1; i >= 0; --i) {
            long entry = tab[i];
            int key = (int)entry;
            if (key >= 0x7FFFFFFE) continue;
            m.justPut(key, (int)(entry >>> 32));
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
    }

    @Nonnull
    public HashObjSet<Map.Entry<Float, Integer>> entrySet() {
        return new EntryView();
    }

    @Nonnull
    public IntCollection values() {
        return new ValueView();
    }

    @Override
    public boolean equals(Object o) {
        return CommonMapOps.equals((InternalMapOps)this, (Object)o);
    }

    @Override
    public int hashCode() {
        int hashCode = 0;
        int mc = this.modCount();
        long[] tab = this.table;
        for (int i = tab.length - 1; i >= 0; --i) {
            long entry = tab[i];
            int key = (int)entry;
            if (key >= 0x7FFFFFFE) continue;
            hashCode += key ^ (int)(entry >>> 32);
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
        return hashCode;
    }

    @Override
    public String toString() {
        if (this.isEmpty()) {
            return "{}";
        }
        StringBuilder sb = new StringBuilder();
        int elementCount = 0;
        int mc = this.modCount();
        long[] tab = this.table;
        for (int i = tab.length - 1; i >= 0; --i) {
            long entry = tab[i];
            int key = (int)entry;
            if (key >= 0x7FFFFFFE) continue;
            sb.append(' ');
            sb.append(Float.intBitsToFloat(key));
            sb.append('=');
            sb.append((int)(entry >>> 32));
            sb.append(',');
            if (++elementCount != 8) continue;
            int expectedLength = sb.length() * (this.size() / 8);
            sb.ensureCapacity(expectedLength + expectedLength / 2);
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
        sb.setCharAt(0, '{');
        sb.setCharAt(sb.length() - 1, '}');
        return sb.toString();
    }

    @Override
    void rehash(int newCapacity) {
        int mc = this.modCount();
        long[] tab = this.table;
        this.initForRehash(newCapacity);
        ++mc;
        long[] newTab = this.table;
        int capacityMask = newTab.length - 1;
        for (int i = tab.length - 1; i >= 0; --i) {
            long entry = tab[i];
            int key = (int)entry;
            if (key >= 0x7FFFFFFE) continue;
            int index = LHash.ParallelKVFloatKeyMixing.mix((int)key) & capacityMask;
            if (U.getInt(newTab, LONG_BASE + FLOAT_KEY_OFFSET + ((long)index << 3)) != 0x7FFFFFFE) {
                while (U.getInt(newTab, LONG_BASE + FLOAT_KEY_OFFSET + ((long)(index = index - 1 & capacityMask) << 3)) != 0x7FFFFFFE) {
                }
            }
            newTab[index] = entry;
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
    }

    public Integer put(Float key, Integer value) {
        int k = Float.floatToIntBits(key.floatValue());
        long[] tab = this.table;
        int capacityMask = tab.length - 1;
        int index = LHash.ParallelKVFloatKeyMixing.mix((int)k) & capacityMask;
        long entry = tab[index];
        int cur = (int)entry;
        if (cur == 0x7FFFFFFE) {
            this.incrementModCount();
            tab[index] = (long)k & 0xFFFFFFFFL | (long)value.intValue() << 32;
            this.postInsertHook();
            return null;
        }
        if (cur != k) {
            do {
                if ((cur = (int)(entry = tab[index = index - 1 & capacityMask])) != 0x7FFFFFFE) continue;
                this.incrementModCount();
                tab[index] = (long)k & 0xFFFFFFFFL | (long)value.intValue() << 32;
                this.postInsertHook();
                return null;
            } while (cur != k);
        }
        int prevValue = (int)(entry >>> 32);
        U.putInt(tab, LONG_BASE + INT_VALUE_OFFSET + ((long)index << 3), value);
        return prevValue;
    }

    public int put(float key, int value) {
        int k = Float.floatToIntBits(key);
        long[] tab = this.table;
        int capacityMask = tab.length - 1;
        int index = LHash.ParallelKVFloatKeyMixing.mix((int)k) & capacityMask;
        long entry = tab[index];
        int cur = (int)entry;
        if (cur == 0x7FFFFFFE) {
            this.incrementModCount();
            tab[index] = (long)k & 0xFFFFFFFFL | (long)value << 32;
            this.postInsertHook();
            return this.defaultValue();
        }
        if (cur != k) {
            do {
                if ((cur = (int)(entry = tab[index = index - 1 & capacityMask])) != 0x7FFFFFFE) continue;
                this.incrementModCount();
                tab[index] = (long)k & 0xFFFFFFFFL | (long)value << 32;
                this.postInsertHook();
                return this.defaultValue();
            } while (cur != k);
        }
        int prevValue = (int)(entry >>> 32);
        U.putInt(tab, LONG_BASE + INT_VALUE_OFFSET + ((long)index << 3), value);
        return prevValue;
    }

    public Integer putIfAbsent(Float key, Integer value) {
        int k = Float.floatToIntBits(key.floatValue());
        long[] tab = this.table;
        int capacityMask = tab.length - 1;
        int index = LHash.ParallelKVFloatKeyMixing.mix((int)k) & capacityMask;
        long entry = tab[index];
        int cur = (int)entry;
        if (cur == 0x7FFFFFFE) {
            this.incrementModCount();
            tab[index] = (long)k & 0xFFFFFFFFL | (long)value.intValue() << 32;
            this.postInsertHook();
            return null;
        }
        if (cur == k) {
            return (int)(entry >>> 32);
        }
        do {
            if ((cur = (int)(entry = tab[index = index - 1 & capacityMask])) != 0x7FFFFFFE) continue;
            this.incrementModCount();
            tab[index] = (long)k & 0xFFFFFFFFL | (long)value.intValue() << 32;
            this.postInsertHook();
            return null;
        } while (cur != k);
        return (int)(entry >>> 32);
    }

    public int putIfAbsent(float key, int value) {
        int k = Float.floatToIntBits(key);
        long[] tab = this.table;
        int capacityMask = tab.length - 1;
        int index = LHash.ParallelKVFloatKeyMixing.mix((int)k) & capacityMask;
        long entry = tab[index];
        int cur = (int)entry;
        if (cur == 0x7FFFFFFE) {
            this.incrementModCount();
            tab[index] = (long)k & 0xFFFFFFFFL | (long)value << 32;
            this.postInsertHook();
            return this.defaultValue();
        }
        if (cur == k) {
            return (int)(entry >>> 32);
        }
        do {
            if ((cur = (int)(entry = tab[index = index - 1 & capacityMask])) != 0x7FFFFFFE) continue;
            this.incrementModCount();
            tab[index] = (long)k & 0xFFFFFFFFL | (long)value << 32;
            this.postInsertHook();
            return this.defaultValue();
        } while (cur != k);
        return (int)(entry >>> 32);
    }

    public void justPut(float key, int value) {
        int k = Float.floatToIntBits(key);
        int index = this.insert(k, value);
        if (index < 0) {
            return;
        }
        U.putInt(this.table, LONG_BASE + INT_VALUE_OFFSET + ((long)index << 3), value);
    }

    public void justPut(int key, int value) {
        int index = this.insert(key, value);
        if (index < 0) {
            return;
        }
        U.putInt(this.table, LONG_BASE + INT_VALUE_OFFSET + ((long)index << 3), value);
    }

    /*
     * Unable to fully structure code
     */
    public Integer compute(Float key, BiFunction<? super Float, ? super Integer, ? extends Integer> remappingFunction) {
        block4: {
            k = Float.floatToIntBits(key.floatValue());
            if (remappingFunction == null) {
                throw new NullPointerException();
            }
            tab = this.table;
            capacityMask = tab.length - 1;
            index = LHash.ParallelKVFloatKeyMixing.mix((int)k) & capacityMask;
            entry = tab[index];
            cur = (int)entry;
            if (cur == k) break block4;
            if (cur == 0x7FFFFFFE) ** GOTO lbl13
            while ((cur = (int)(entry = tab[index = index - 1 & capacityMask])) != k) {
                if (cur != 0x7FFFFFFE) continue;
lbl13:
                // 2 sources

                if ((newValue = remappingFunction.apply(Float.valueOf(Float.intBitsToFloat(k)), null)) != null) {
                    this.incrementModCount();
                    tab[index] = (long)k & 0xFFFFFFFFL | (long)newValue.intValue() << 32;
                    this.postInsertHook();
                    return newValue;
                }
                return null;
            }
        }
        if ((newValue = remappingFunction.apply(Float.valueOf(Float.intBitsToFloat(k)), (Integer)((int)(entry >>> 32)))) != null) {
            UpdatableLHashParallelKVFloatIntMapGO.U.putInt(tab, UpdatableLHashParallelKVFloatIntMapGO.LONG_BASE + UpdatableLHashParallelKVFloatIntMapGO.INT_VALUE_OFFSET + ((long)index << 3), newValue);
            return newValue;
        }
        throw new UnsupportedOperationException("Compute operation of updatable map doesn't support removals");
    }

    /*
     * Unable to fully structure code
     */
    public int compute(float key, FloatIntToIntFunction remappingFunction) {
        block2: {
            k = Float.floatToIntBits(key);
            if (remappingFunction == null) {
                throw new NullPointerException();
            }
            tab = this.table;
            capacityMask = tab.length - 1;
            index = LHash.ParallelKVFloatKeyMixing.mix((int)k) & capacityMask;
            entry = tab[index];
            cur = (int)entry;
            if (cur == k) break block2;
            if (cur == 0x7FFFFFFE) ** GOTO lbl13
            while ((cur = (int)(entry = tab[index = index - 1 & capacityMask])) != k) {
                if (cur != 0x7FFFFFFE) continue;
lbl13:
                // 2 sources

                newValue = remappingFunction.applyAsInt(Float.intBitsToFloat(k), this.defaultValue());
                this.incrementModCount();
                tab[index] = (long)k & 0xFFFFFFFFL | (long)newValue << 32;
                this.postInsertHook();
                return newValue;
            }
        }
        newValue = remappingFunction.applyAsInt(Float.intBitsToFloat(k), (int)(entry >>> 32));
        UpdatableLHashParallelKVFloatIntMapGO.U.putInt(tab, UpdatableLHashParallelKVFloatIntMapGO.LONG_BASE + UpdatableLHashParallelKVFloatIntMapGO.INT_VALUE_OFFSET + ((long)index << 3), newValue);
        return newValue;
    }

    public Integer computeIfAbsent(Float key, Function<? super Float, ? extends Integer> mappingFunction) {
        Integer value;
        int k = Float.floatToIntBits(key.floatValue());
        if (mappingFunction == null) {
            throw new NullPointerException();
        }
        long[] tab = this.table;
        int capacityMask = tab.length - 1;
        int index = LHash.ParallelKVFloatKeyMixing.mix((int)k) & capacityMask;
        long entry = tab[index];
        int cur = (int)entry;
        if (cur == k) {
            return (int)(entry >>> 32);
        }
        if (cur != 0x7FFFFFFE) {
            do {
                if ((cur = (int)(entry = tab[index = index - 1 & capacityMask])) != k) continue;
                return (int)(entry >>> 32);
            } while (cur != 0x7FFFFFFE);
        }
        if ((value = mappingFunction.apply(Float.valueOf(Float.intBitsToFloat(k)))) != null) {
            this.incrementModCount();
            tab[index] = (long)k & 0xFFFFFFFFL | (long)value.intValue() << 32;
            this.postInsertHook();
            return value;
        }
        return null;
    }

    public int computeIfAbsent(float key, FloatToIntFunction mappingFunction) {
        int k = Float.floatToIntBits(key);
        if (mappingFunction == null) {
            throw new NullPointerException();
        }
        long[] tab = this.table;
        int capacityMask = tab.length - 1;
        int index = LHash.ParallelKVFloatKeyMixing.mix((int)k) & capacityMask;
        long entry = tab[index];
        int cur = (int)entry;
        if (cur == k) {
            return (int)(entry >>> 32);
        }
        if (cur != 0x7FFFFFFE) {
            do {
                if ((cur = (int)(entry = tab[index = index - 1 & capacityMask])) != k) continue;
                return (int)(entry >>> 32);
            } while (cur != 0x7FFFFFFE);
        }
        int value = mappingFunction.applyAsInt(Float.intBitsToFloat(k));
        this.incrementModCount();
        tab[index] = (long)k & 0xFFFFFFFFL | (long)value << 32;
        this.postInsertHook();
        return value;
    }

    public Integer computeIfPresent(Float key, BiFunction<? super Float, ? super Integer, ? extends Integer> remappingFunction) {
        Integer newValue;
        int k = Float.floatToIntBits(key.floatValue());
        if (remappingFunction == null) {
            throw new NullPointerException();
        }
        long[] tab = this.table;
        int capacityMask = tab.length - 1;
        int index = LHash.ParallelKVFloatKeyMixing.mix((int)k) & capacityMask;
        long entry = tab[index];
        int cur = (int)entry;
        if (cur != k) {
            if (cur == 0x7FFFFFFE) {
                return null;
            }
            while ((cur = (int)(entry = tab[index = index - 1 & capacityMask])) != k) {
                if (cur != 0x7FFFFFFE) continue;
                return null;
            }
        }
        if ((newValue = remappingFunction.apply(Float.valueOf(Float.intBitsToFloat(k)), (Integer)((int)(entry >>> 32)))) != null) {
            U.putInt(tab, LONG_BASE + INT_VALUE_OFFSET + ((long)index << 3), newValue);
            return newValue;
        }
        throw new UnsupportedOperationException("ComputeIfPresent operation of updatable map doesn't support removals");
    }

    public int computeIfPresent(float key, FloatIntToIntFunction remappingFunction) {
        int k = Float.floatToIntBits(key);
        if (remappingFunction == null) {
            throw new NullPointerException();
        }
        long[] tab = this.table;
        int capacityMask = tab.length - 1;
        int index = LHash.ParallelKVFloatKeyMixing.mix((int)k) & capacityMask;
        long entry = tab[index];
        int cur = (int)entry;
        if (cur != k) {
            if (cur == 0x7FFFFFFE) {
                return this.defaultValue();
            }
            while ((cur = (int)(entry = tab[index = index - 1 & capacityMask])) != k) {
                if (cur != 0x7FFFFFFE) continue;
                return this.defaultValue();
            }
        }
        int newValue = remappingFunction.applyAsInt(Float.intBitsToFloat(k), (int)(entry >>> 32));
        U.putInt(tab, LONG_BASE + INT_VALUE_OFFSET + ((long)index << 3), newValue);
        return newValue;
    }

    /*
     * Unable to fully structure code
     */
    public Integer merge(Float key, Integer value, BiFunction<? super Integer, ? super Integer, ? extends Integer> remappingFunction) {
        block4: {
            k = Float.floatToIntBits(key.floatValue());
            if (value == null) {
                throw new NullPointerException();
            }
            if (remappingFunction == null) {
                throw new NullPointerException();
            }
            tab = this.table;
            capacityMask = tab.length - 1;
            index = LHash.ParallelKVFloatKeyMixing.mix((int)k) & capacityMask;
            entry = tab[index];
            cur = (int)entry;
            if (cur == k) break block4;
            if (cur == 0x7FFFFFFE) ** GOTO lbl15
            while ((cur = (int)(entry = tab[index = index - 1 & capacityMask])) != k) {
                if (cur != 0x7FFFFFFE) continue;
lbl15:
                // 2 sources

                this.incrementModCount();
                tab[index] = (long)k & 0xFFFFFFFFL | (long)value.intValue() << 32;
                this.postInsertHook();
                return value;
            }
        }
        if ((newValue = remappingFunction.apply((Integer)((int)(entry >>> 32)), value)) != null) {
            UpdatableLHashParallelKVFloatIntMapGO.U.putInt(tab, UpdatableLHashParallelKVFloatIntMapGO.LONG_BASE + UpdatableLHashParallelKVFloatIntMapGO.INT_VALUE_OFFSET + ((long)index << 3), newValue);
            return newValue;
        }
        throw new UnsupportedOperationException("Merge operation of updatable map doesn't support removals");
    }

    /*
     * Unable to fully structure code
     */
    public int merge(float key, int value, IntBinaryOperator remappingFunction) {
        block2: {
            k = Float.floatToIntBits(key);
            if (remappingFunction == null) {
                throw new NullPointerException();
            }
            tab = this.table;
            capacityMask = tab.length - 1;
            index = LHash.ParallelKVFloatKeyMixing.mix((int)k) & capacityMask;
            entry = tab[index];
            cur = (int)entry;
            if (cur == k) break block2;
            if (cur == 0x7FFFFFFE) ** GOTO lbl13
            while ((cur = (int)(entry = tab[index = index - 1 & capacityMask])) != k) {
                if (cur != 0x7FFFFFFE) continue;
lbl13:
                // 2 sources

                this.incrementModCount();
                tab[index] = (long)k & 0xFFFFFFFFL | (long)value << 32;
                this.postInsertHook();
                return value;
            }
        }
        newValue = remappingFunction.applyAsInt((int)(entry >>> 32), value);
        UpdatableLHashParallelKVFloatIntMapGO.U.putInt(tab, UpdatableLHashParallelKVFloatIntMapGO.LONG_BASE + UpdatableLHashParallelKVFloatIntMapGO.INT_VALUE_OFFSET + ((long)index << 3), newValue);
        return newValue;
    }

    /*
     * Unable to fully structure code
     */
    public int addValue(float key, int value) {
        block1: {
            k = Float.floatToIntBits(key);
            tab = this.table;
            capacityMask = tab.length - 1;
            index = LHash.ParallelKVFloatKeyMixing.mix((int)k) & capacityMask;
            entry = tab[index];
            cur = (int)entry;
            if (cur == k) break block1;
            if (cur == 0x7FFFFFFE) ** GOTO lbl11
            while ((cur = (int)(entry = tab[index = index - 1 & capacityMask])) != k) {
                if (cur != 0x7FFFFFFE) continue;
lbl11:
                // 2 sources

                newValue = this.defaultValue() + value;
                this.incrementModCount();
                tab[index] = (long)k & 0xFFFFFFFFL | (long)newValue << 32;
                this.postInsertHook();
                return newValue;
            }
        }
        newValue = (int)(entry >>> 32) + value;
        UpdatableLHashParallelKVFloatIntMapGO.U.putInt(tab, UpdatableLHashParallelKVFloatIntMapGO.LONG_BASE + UpdatableLHashParallelKVFloatIntMapGO.INT_VALUE_OFFSET + ((long)index << 3), newValue);
        return newValue;
    }

    /*
     * Unable to fully structure code
     */
    public int addValue(float key, int addition, int initialValue) {
        block1: {
            k = Float.floatToIntBits(key);
            tab = this.table;
            capacityMask = tab.length - 1;
            index = LHash.ParallelKVFloatKeyMixing.mix((int)k) & capacityMask;
            entry = tab[index];
            cur = (int)entry;
            if (cur == k) break block1;
            if (cur == 0x7FFFFFFE) ** GOTO lbl11
            while ((cur = (int)(entry = tab[index = index - 1 & capacityMask])) != k) {
                if (cur != 0x7FFFFFFE) continue;
lbl11:
                // 2 sources

                newValue = initialValue + addition;
                this.incrementModCount();
                tab[index] = (long)k & 0xFFFFFFFFL | (long)newValue << 32;
                this.postInsertHook();
                return newValue;
            }
        }
        newValue = (int)(entry >>> 32) + addition;
        UpdatableLHashParallelKVFloatIntMapGO.U.putInt(tab, UpdatableLHashParallelKVFloatIntMapGO.LONG_BASE + UpdatableLHashParallelKVFloatIntMapGO.INT_VALUE_OFFSET + ((long)index << 3), newValue);
        return newValue;
    }

    public void putAll(@Nonnull Map<? extends Float, ? extends Integer> m) {
        CommonFloatIntMapOps.putAll((InternalFloatIntMapOps)this, m);
    }

    public Integer replace(Float key, Integer value) {
        int k = Float.floatToIntBits(key.floatValue());
        long[] tab = this.table;
        int capacityMask = tab.length - 1;
        int index = LHash.ParallelKVFloatKeyMixing.mix((int)k) & capacityMask;
        long entry = tab[index];
        int cur = (int)entry;
        if (cur != k) {
            if (cur == 0x7FFFFFFE) {
                return null;
            }
            while ((cur = (int)(entry = tab[index = index - 1 & capacityMask])) != k) {
                if (cur != 0x7FFFFFFE) continue;
                return null;
            }
        }
        int oldValue = (int)(entry >>> 32);
        U.putInt(tab, LONG_BASE + INT_VALUE_OFFSET + ((long)index << 3), value);
        return oldValue;
    }

    public int replace(float key, int value) {
        int k = Float.floatToIntBits(key);
        long[] tab = this.table;
        int capacityMask = tab.length - 1;
        int index = LHash.ParallelKVFloatKeyMixing.mix((int)k) & capacityMask;
        long entry = tab[index];
        int cur = (int)entry;
        if (cur != k) {
            if (cur == 0x7FFFFFFE) {
                return this.defaultValue();
            }
            while ((cur = (int)(entry = tab[index = index - 1 & capacityMask])) != k) {
                if (cur != 0x7FFFFFFE) continue;
                return this.defaultValue();
            }
        }
        int oldValue = (int)(entry >>> 32);
        U.putInt(tab, LONG_BASE + INT_VALUE_OFFSET + ((long)index << 3), value);
        return oldValue;
    }

    public boolean replace(Float key, Integer oldValue, Integer newValue) {
        return this.replace(key.floatValue(), (int)oldValue, (int)newValue);
    }

    public boolean replace(float key, int oldValue, int newValue) {
        int k = Float.floatToIntBits(key);
        long[] tab = this.table;
        int capacityMask = tab.length - 1;
        int index = LHash.ParallelKVFloatKeyMixing.mix((int)k) & capacityMask;
        long entry = tab[index];
        int cur = (int)entry;
        if (cur != k) {
            if (cur == 0x7FFFFFFE) {
                return false;
            }
            while ((cur = (int)(entry = tab[index = index - 1 & capacityMask])) != k) {
                if (cur != 0x7FFFFFFE) continue;
                return false;
            }
        }
        if ((int)(entry >>> 32) == oldValue) {
            U.putInt(tab, LONG_BASE + INT_VALUE_OFFSET + ((long)index << 3), newValue);
            return true;
        }
        return false;
    }

    public void replaceAll(BiFunction<? super Float, ? super Integer, ? extends Integer> function) {
        if (function == null) {
            throw new NullPointerException();
        }
        if (this.isEmpty()) {
            return;
        }
        int mc = this.modCount();
        long[] tab = this.table;
        for (int i = tab.length - 1; i >= 0; --i) {
            long entry = tab[i];
            int key = (int)entry;
            if (key >= 0x7FFFFFFE) continue;
            U.putInt(tab, LONG_BASE + INT_VALUE_OFFSET + ((long)i << 3), function.apply(Float.valueOf(Float.intBitsToFloat(key)), (Integer)((int)(entry >>> 32))));
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
    }

    public void replaceAll(FloatIntToIntFunction function) {
        if (function == null) {
            throw new NullPointerException();
        }
        if (this.isEmpty()) {
            return;
        }
        int mc = this.modCount();
        long[] tab = this.table;
        for (int i = tab.length - 1; i >= 0; --i) {
            long entry = tab[i];
            int key = (int)entry;
            if (key >= 0x7FFFFFFE) continue;
            U.putInt(tab, LONG_BASE + INT_VALUE_OFFSET + ((long)i << 3), function.applyAsInt(Float.intBitsToFloat(key), (int)(entry >>> 32)));
        }
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
    }

    @Override
    public void clear() {
        this.doClear();
    }

    private void doClear() {
        int mc = this.modCount() + 1;
        super.clear();
        if (mc != this.modCount()) {
            throw new ConcurrentModificationException();
        }
    }

    public Integer remove(Object key) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean justRemove(float key) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean justRemove(int key) {
        throw new UnsupportedOperationException();
    }

    public int remove(float key) {
        throw new UnsupportedOperationException();
    }

    public boolean remove(Object key, Object value) {
        return this.remove(((Float)key).floatValue(), (Integer)value);
    }

    public boolean remove(float key, int value) {
        throw new UnsupportedOperationException();
    }

    public boolean removeIf(FloatIntPredicate filter) {
        throw new UnsupportedOperationException();
    }

    class NoRemovedMapCursor
    implements FloatIntCursor {
        final long[] tab;
        int expectedModCount;
        int index;
        int curKey;
        int curValue;

        NoRemovedMapCursor(int mc) {
            this.expectedModCount = mc;
            this.tab = UpdatableLHashParallelKVFloatIntMapGO.this.table;
            this.index = this.tab.length;
            this.curKey = 0x7FFFFFFE;
        }

        public void forEachForward(FloatIntConsumer action) {
            if (action == null) {
                throw new NullPointerException();
            }
            int mc = this.expectedModCount;
            long[] tab = this.tab;
            int index = this.index;
            for (int i = index - 1; i >= 0; --i) {
                long entry = tab[i];
                int key = (int)entry;
                if (key >= 0x7FFFFFFE) continue;
                action.accept(Float.intBitsToFloat(key), (int)(entry >>> 32));
            }
            if (index != this.index || mc != UpdatableLHashParallelKVFloatIntMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            this.index = -1;
            this.curKey = 0x7FFFFFFE;
        }

        public float key() {
            int curKey = this.curKey;
            if (curKey != 0x7FFFFFFE) {
                return Float.intBitsToFloat(curKey);
            }
            throw new IllegalStateException();
        }

        public int value() {
            if (this.curKey != 0x7FFFFFFE) {
                return this.curValue;
            }
            throw new IllegalStateException();
        }

        public void setValue(int value) {
            if (this.curKey != 0x7FFFFFFE) {
                if (this.expectedModCount != UpdatableLHashParallelKVFloatIntMapGO.this.modCount()) {
                    throw new ConcurrentModificationException();
                }
            } else {
                throw new IllegalStateException();
            }
            UnsafeConstants.U.putInt(this.tab, UnsafeConstants.LONG_BASE + UnsafeConstants.INT_VALUE_OFFSET + ((long)this.index << 3), value);
        }

        public boolean moveNext() {
            if (this.expectedModCount == UpdatableLHashParallelKVFloatIntMapGO.this.modCount()) {
                long[] tab = this.tab;
                for (int i = this.index - 1; i >= 0; --i) {
                    long entry = tab[i];
                    int key = (int)entry;
                    if (key >= 0x7FFFFFFE) continue;
                    this.index = i;
                    this.curKey = key;
                    this.curValue = (int)(entry >>> 32);
                    return true;
                }
                this.curKey = 0x7FFFFFFE;
                this.index = -1;
                return false;
            }
            throw new ConcurrentModificationException();
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    class NoRemovedValueCursor
    implements IntCursor {
        final long[] tab;
        int expectedModCount;
        int index;
        int curKey;
        int curValue;

        NoRemovedValueCursor(int mc) {
            this.expectedModCount = mc;
            this.tab = UpdatableLHashParallelKVFloatIntMapGO.this.table;
            this.index = this.tab.length;
            this.curKey = 0x7FFFFFFE;
        }

        public void forEachForward(IntConsumer action) {
            if (action == null) {
                throw new NullPointerException();
            }
            int mc = this.expectedModCount;
            long[] tab = this.tab;
            int index = this.index;
            for (int i = index - 1; i >= 0; --i) {
                long entry = tab[i];
                if ((int)entry >= 0x7FFFFFFE) continue;
                action.accept((int)(entry >>> 32));
            }
            if (index != this.index || mc != UpdatableLHashParallelKVFloatIntMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            this.index = -1;
            this.curKey = 0x7FFFFFFE;
        }

        public int elem() {
            if (this.curKey != 0x7FFFFFFE) {
                return this.curValue;
            }
            throw new IllegalStateException();
        }

        public boolean moveNext() {
            if (this.expectedModCount == UpdatableLHashParallelKVFloatIntMapGO.this.modCount()) {
                long[] tab = this.tab;
                for (int i = this.index - 1; i >= 0; --i) {
                    long entry = tab[i];
                    int key = (int)entry;
                    if (key >= 0x7FFFFFFE) continue;
                    this.index = i;
                    this.curKey = key;
                    this.curValue = (int)(entry >>> 32);
                    return true;
                }
                this.curKey = 0x7FFFFFFE;
                this.index = -1;
                return false;
            }
            throw new ConcurrentModificationException();
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    class NoRemovedValueIterator
    implements IntIterator {
        final long[] tab;
        int expectedModCount;
        int nextIndex;
        int next;

        NoRemovedValueIterator(int mc) {
            this.expectedModCount = mc;
            this.tab = UpdatableLHashParallelKVFloatIntMapGO.this.table;
            long[] tab = UpdatableLHashParallelKVFloatIntMapGO.this.table;
            int nextI = tab.length;
            while (--nextI >= 0) {
                long entry = tab[nextI];
                if ((int)entry >= 0x7FFFFFFE) continue;
                this.next = (int)(entry >>> 32);
                break;
            }
            this.nextIndex = nextI;
        }

        public int nextInt() {
            if (this.expectedModCount == UpdatableLHashParallelKVFloatIntMapGO.this.modCount()) {
                int nextI = this.nextIndex;
                if (nextI >= 0) {
                    long[] tab = this.tab;
                    int prev = this.next;
                    while (--nextI >= 0) {
                        long entry = tab[nextI];
                        if ((int)entry >= 0x7FFFFFFE) continue;
                        this.next = (int)(entry >>> 32);
                        break;
                    }
                    this.nextIndex = nextI;
                    return prev;
                }
                throw new NoSuchElementException();
            }
            throw new ConcurrentModificationException();
        }

        public void forEachRemaining(Consumer<? super Integer> action) {
            int nextI;
            if (action == null) {
                throw new NullPointerException();
            }
            int mc = this.expectedModCount;
            long[] tab = this.tab;
            for (int i = nextI = this.nextIndex; i >= 0; --i) {
                long entry = tab[i];
                if ((int)entry >= 0x7FFFFFFE) continue;
                action.accept((Integer)((int)(entry >>> 32)));
            }
            if (nextI != this.nextIndex || mc != UpdatableLHashParallelKVFloatIntMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            this.nextIndex = -1;
        }

        public void forEachRemaining(IntConsumer action) {
            int nextI;
            if (action == null) {
                throw new NullPointerException();
            }
            int mc = this.expectedModCount;
            long[] tab = this.tab;
            for (int i = nextI = this.nextIndex; i >= 0; --i) {
                long entry = tab[i];
                if ((int)entry >= 0x7FFFFFFE) continue;
                action.accept((int)(entry >>> 32));
            }
            if (nextI != this.nextIndex || mc != UpdatableLHashParallelKVFloatIntMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            this.nextIndex = -1;
        }

        public boolean hasNext() {
            return this.nextIndex >= 0;
        }

        public Integer next() {
            return this.nextInt();
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    class NoRemovedEntryCursor
    implements ObjCursor<Map.Entry<Float, Integer>> {
        final long[] tab;
        int expectedModCount;
        int index;
        int curKey;
        int curValue;

        NoRemovedEntryCursor(int mc) {
            this.expectedModCount = mc;
            this.tab = UpdatableLHashParallelKVFloatIntMapGO.this.table;
            this.index = this.tab.length;
            this.curKey = 0x7FFFFFFE;
        }

        public void forEachForward(Consumer<? super Map.Entry<Float, Integer>> action) {
            if (action == null) {
                throw new NullPointerException();
            }
            int mc = this.expectedModCount;
            long[] tab = this.tab;
            int index = this.index;
            for (int i = index - 1; i >= 0; --i) {
                long entry = tab[i];
                int key = (int)entry;
                if (key >= 0x7FFFFFFE) continue;
                action.accept((Map.Entry<Float, Integer>)((Object)new MutableEntry(mc, i, key, (int)(entry >>> 32))));
            }
            if (index != this.index || mc != UpdatableLHashParallelKVFloatIntMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            this.index = -1;
            this.curKey = 0x7FFFFFFE;
        }

        public Map.Entry<Float, Integer> elem() {
            int curKey = this.curKey;
            if (curKey != 0x7FFFFFFE) {
                return new MutableEntry(this.expectedModCount, this.index, curKey, this.curValue);
            }
            throw new IllegalStateException();
        }

        public boolean moveNext() {
            if (this.expectedModCount == UpdatableLHashParallelKVFloatIntMapGO.this.modCount()) {
                long[] tab = this.tab;
                for (int i = this.index - 1; i >= 0; --i) {
                    long entry = tab[i];
                    int key = (int)entry;
                    if (key >= 0x7FFFFFFE) continue;
                    this.index = i;
                    this.curKey = key;
                    this.curValue = (int)(entry >>> 32);
                    return true;
                }
                this.curKey = 0x7FFFFFFE;
                this.index = -1;
                return false;
            }
            throw new ConcurrentModificationException();
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    class NoRemovedEntryIterator
    implements ObjIterator<Map.Entry<Float, Integer>> {
        final long[] tab;
        int expectedModCount;
        int nextIndex;
        MutableEntry next;

        NoRemovedEntryIterator(int mc) {
            this.expectedModCount = mc;
            this.tab = UpdatableLHashParallelKVFloatIntMapGO.this.table;
            long[] tab = UpdatableLHashParallelKVFloatIntMapGO.this.table;
            int nextI = tab.length;
            while (--nextI >= 0) {
                long entry = tab[nextI];
                int key = (int)entry;
                if (key >= 0x7FFFFFFE) continue;
                this.next = new MutableEntry(mc, nextI, key, (int)(entry >>> 32));
                break;
            }
            this.nextIndex = nextI;
        }

        public void forEachRemaining(@Nonnull Consumer<? super Map.Entry<Float, Integer>> action) {
            int nextI;
            if (action == null) {
                throw new NullPointerException();
            }
            int mc = this.expectedModCount;
            long[] tab = this.tab;
            for (int i = nextI = this.nextIndex; i >= 0; --i) {
                long entry = tab[i];
                int key = (int)entry;
                if (key >= 0x7FFFFFFE) continue;
                action.accept((Map.Entry<Float, Integer>)((Object)new MutableEntry(mc, i, key, (int)(entry >>> 32))));
            }
            if (nextI != this.nextIndex || mc != UpdatableLHashParallelKVFloatIntMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            this.nextIndex = -1;
        }

        public boolean hasNext() {
            return this.nextIndex >= 0;
        }

        public Map.Entry<Float, Integer> next() {
            int mc = this.expectedModCount;
            if (mc == UpdatableLHashParallelKVFloatIntMapGO.this.modCount()) {
                int nextI = this.nextIndex;
                if (nextI >= 0) {
                    long[] tab = this.tab;
                    MutableEntry prev = this.next;
                    while (--nextI >= 0) {
                        long entry = tab[nextI];
                        int key = (int)entry;
                        if (key >= 0x7FFFFFFE) continue;
                        this.next = new MutableEntry(mc, nextI, key, (int)(entry >>> 32));
                        break;
                    }
                    this.nextIndex = nextI;
                    return prev;
                }
                throw new NoSuchElementException();
            }
            throw new ConcurrentModificationException();
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    class ValueView
    extends AbstractIntValueView {
        ValueView() {
        }

        public int size() {
            return UpdatableLHashParallelKVFloatIntMapGO.this.size();
        }

        public boolean shrink() {
            return UpdatableLHashParallelKVFloatIntMapGO.this.shrink();
        }

        public boolean contains(Object o) {
            return UpdatableLHashParallelKVFloatIntMapGO.this.containsValue(o);
        }

        public boolean contains(int v) {
            return UpdatableLHashParallelKVFloatIntMapGO.this.containsValue(v);
        }

        public void forEach(Consumer<? super Integer> action) {
            if (action == null) {
                throw new NullPointerException();
            }
            if (this.isEmpty()) {
                return;
            }
            int mc = UpdatableLHashParallelKVFloatIntMapGO.this.modCount();
            long[] tab = UpdatableLHashParallelKVFloatIntMapGO.this.table;
            for (int i = tab.length - 1; i >= 0; --i) {
                long entry = tab[i];
                if ((int)entry >= 0x7FFFFFFE) continue;
                action.accept((Integer)((int)(entry >>> 32)));
            }
            if (mc != UpdatableLHashParallelKVFloatIntMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
        }

        public void forEach(IntConsumer action) {
            if (action == null) {
                throw new NullPointerException();
            }
            if (this.isEmpty()) {
                return;
            }
            int mc = UpdatableLHashParallelKVFloatIntMapGO.this.modCount();
            long[] tab = UpdatableLHashParallelKVFloatIntMapGO.this.table;
            for (int i = tab.length - 1; i >= 0; --i) {
                long entry = tab[i];
                if ((int)entry >= 0x7FFFFFFE) continue;
                action.accept((int)(entry >>> 32));
            }
            if (mc != UpdatableLHashParallelKVFloatIntMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
        }

        public boolean forEachWhile(IntPredicate predicate) {
            if (predicate == null) {
                throw new NullPointerException();
            }
            if (this.isEmpty()) {
                return true;
            }
            boolean terminated = false;
            int mc = UpdatableLHashParallelKVFloatIntMapGO.this.modCount();
            long[] tab = UpdatableLHashParallelKVFloatIntMapGO.this.table;
            for (int i = tab.length - 1; i >= 0; --i) {
                long entry = tab[i];
                if ((int)entry >= 0x7FFFFFFE || predicate.test((int)(entry >>> 32))) continue;
                terminated = true;
                break;
            }
            if (mc != UpdatableLHashParallelKVFloatIntMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return !terminated;
        }

        public boolean allContainingIn(IntCollection c) {
            if (this.isEmpty()) {
                return true;
            }
            boolean containsAll = true;
            int mc = UpdatableLHashParallelKVFloatIntMapGO.this.modCount();
            long[] tab = UpdatableLHashParallelKVFloatIntMapGO.this.table;
            for (int i = tab.length - 1; i >= 0; --i) {
                long entry = tab[i];
                if ((int)entry >= 0x7FFFFFFE || c.contains((int)(entry >>> 32))) continue;
                containsAll = false;
                break;
            }
            if (mc != UpdatableLHashParallelKVFloatIntMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return containsAll;
        }

        public boolean reverseAddAllTo(IntCollection c) {
            if (this.isEmpty()) {
                return false;
            }
            boolean changed = false;
            int mc = UpdatableLHashParallelKVFloatIntMapGO.this.modCount();
            long[] tab = UpdatableLHashParallelKVFloatIntMapGO.this.table;
            for (int i = tab.length - 1; i >= 0; --i) {
                long entry = tab[i];
                if ((int)entry >= 0x7FFFFFFE) continue;
                changed |= c.add((int)(entry >>> 32));
            }
            if (mc != UpdatableLHashParallelKVFloatIntMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return changed;
        }

        public boolean reverseRemoveAllFrom(IntSet s) {
            if (this.isEmpty() || s.isEmpty()) {
                return false;
            }
            boolean changed = false;
            int mc = UpdatableLHashParallelKVFloatIntMapGO.this.modCount();
            long[] tab = UpdatableLHashParallelKVFloatIntMapGO.this.table;
            for (int i = tab.length - 1; i >= 0; --i) {
                long entry = tab[i];
                if ((int)entry >= 0x7FFFFFFE) continue;
                changed |= s.removeInt((int)(entry >>> 32));
            }
            if (mc != UpdatableLHashParallelKVFloatIntMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return changed;
        }

        @Nonnull
        public IntIterator iterator() {
            int mc = UpdatableLHashParallelKVFloatIntMapGO.this.modCount();
            return new NoRemovedValueIterator(mc);
        }

        @Nonnull
        public IntCursor cursor() {
            int mc = UpdatableLHashParallelKVFloatIntMapGO.this.modCount();
            return new NoRemovedValueCursor(mc);
        }

        @Nonnull
        public Object[] toArray() {
            int size = this.size();
            Object[] result = new Object[size];
            if (size == 0) {
                return result;
            }
            int resultIndex = 0;
            int mc = UpdatableLHashParallelKVFloatIntMapGO.this.modCount();
            long[] tab = UpdatableLHashParallelKVFloatIntMapGO.this.table;
            for (int i = tab.length - 1; i >= 0; --i) {
                long entry = tab[i];
                if ((int)entry >= 0x7FFFFFFE) continue;
                result[resultIndex++] = (int)(entry >>> 32);
            }
            if (mc != UpdatableLHashParallelKVFloatIntMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return result;
        }

        @Nonnull
        public <T> T[] toArray(@Nonnull T[] a) {
            int size = this.size();
            if (a.length < size) {
                Class<?> elementType = a.getClass().getComponentType();
                a = (Object[])Array.newInstance(elementType, size);
            }
            if (size == 0) {
                if (a.length > 0) {
                    a[0] = null;
                }
                return a;
            }
            int resultIndex = 0;
            int mc = UpdatableLHashParallelKVFloatIntMapGO.this.modCount();
            long[] tab = UpdatableLHashParallelKVFloatIntMapGO.this.table;
            for (int i = tab.length - 1; i >= 0; --i) {
                long entry = tab[i];
                if ((int)entry >= 0x7FFFFFFE) continue;
                a[resultIndex++] = (int)(entry >>> 32);
            }
            if (mc != UpdatableLHashParallelKVFloatIntMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            if (a.length > resultIndex) {
                a[resultIndex] = null;
            }
            return a;
        }

        public int[] toIntArray() {
            int size = this.size();
            int[] result = new int[size];
            if (size == 0) {
                return result;
            }
            int resultIndex = 0;
            int mc = UpdatableLHashParallelKVFloatIntMapGO.this.modCount();
            long[] tab = UpdatableLHashParallelKVFloatIntMapGO.this.table;
            for (int i = tab.length - 1; i >= 0; --i) {
                long entry = tab[i];
                if ((int)entry >= 0x7FFFFFFE) continue;
                result[resultIndex++] = (int)(entry >>> 32);
            }
            if (mc != UpdatableLHashParallelKVFloatIntMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return result;
        }

        public int[] toArray(int[] a) {
            int size = this.size();
            if (a.length < size) {
                a = new int[size];
            }
            if (size == 0) {
                if (a.length > 0) {
                    a[0] = 0;
                }
                return a;
            }
            int resultIndex = 0;
            int mc = UpdatableLHashParallelKVFloatIntMapGO.this.modCount();
            long[] tab = UpdatableLHashParallelKVFloatIntMapGO.this.table;
            for (int i = tab.length - 1; i >= 0; --i) {
                long entry = tab[i];
                if ((int)entry >= 0x7FFFFFFE) continue;
                a[resultIndex++] = (int)(entry >>> 32);
            }
            if (mc != UpdatableLHashParallelKVFloatIntMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            if (a.length > resultIndex) {
                a[resultIndex] = 0;
            }
            return a;
        }

        public String toString() {
            if (this.isEmpty()) {
                return "[]";
            }
            StringBuilder sb = new StringBuilder();
            int elementCount = 0;
            int mc = UpdatableLHashParallelKVFloatIntMapGO.this.modCount();
            long[] tab = UpdatableLHashParallelKVFloatIntMapGO.this.table;
            for (int i = tab.length - 1; i >= 0; --i) {
                long entry = tab[i];
                if ((int)entry >= 0x7FFFFFFE) continue;
                sb.append(' ').append((int)(entry >>> 32)).append(',');
                if (++elementCount != 8) continue;
                int expectedLength = sb.length() * (this.size() / 8);
                sb.ensureCapacity(expectedLength + expectedLength / 2);
            }
            if (mc != UpdatableLHashParallelKVFloatIntMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            sb.setCharAt(0, '[');
            sb.setCharAt(sb.length() - 1, ']');
            return sb.toString();
        }

        public boolean remove(Object o) {
            return this.removeInt((Integer)o);
        }

        public boolean removeInt(int v) {
            return UpdatableLHashParallelKVFloatIntMapGO.this.removeValue(v);
        }

        public void clear() {
            UpdatableLHashParallelKVFloatIntMapGO.this.clear();
        }

        public boolean removeIf(Predicate<? super Integer> filter) {
            throw new UnsupportedOperationException();
        }

        public boolean removeIf(IntPredicate filter) {
            throw new UnsupportedOperationException();
        }

        public boolean removeAll(@Nonnull Collection<?> c) {
            throw new UnsupportedOperationException();
        }

        public boolean retainAll(@Nonnull Collection<?> c) {
            throw new UnsupportedOperationException();
        }
    }

    class ReusableEntry
    extends FloatIntEntry {
        private int key;
        private int value;

        ReusableEntry() {
        }

        ReusableEntry with(int key, int value) {
            this.key = key;
            this.value = value;
            return this;
        }

        @Override
        public int key() {
            return this.key;
        }

        @Override
        public int value() {
            return this.value;
        }
    }

    class MutableEntry
    extends FloatIntEntry {
        final int modCount;
        private final int index;
        final int key;
        private int value;

        MutableEntry(int modCount, int index, int key, int value) {
            this.modCount = modCount;
            this.index = index;
            this.key = key;
            this.value = value;
        }

        @Override
        public int key() {
            return this.key;
        }

        @Override
        public int value() {
            return this.value;
        }

        public Integer setValue(Integer newValue) {
            int unwrappedNewValue;
            if (this.modCount != UpdatableLHashParallelKVFloatIntMapGO.this.modCount()) {
                throw new IllegalStateException();
            }
            int oldValue = this.value;
            this.value = unwrappedNewValue = newValue.intValue();
            this.updateValueInTable(unwrappedNewValue);
            return oldValue;
        }

        void updateValueInTable(int newValue) {
            UnsafeConstants.U.putInt(UpdatableLHashParallelKVFloatIntMapGO.this.table, UnsafeConstants.LONG_BASE + UnsafeConstants.INT_VALUE_OFFSET + ((long)this.index << 3), newValue);
        }
    }

    abstract class FloatIntEntry
    extends AbstractEntry<Float, Integer> {
        FloatIntEntry() {
        }

        abstract int key();

        public final Float getKey() {
            return Float.valueOf(Float.intBitsToFloat(this.key()));
        }

        abstract int value();

        public final Integer getValue() {
            return this.value();
        }

        public boolean equals(Object o) {
            try {
                Map.Entry e2 = (Map.Entry)o;
                int k2 = Float.floatToIntBits(((Float)e2.getKey()).floatValue());
                int v2 = (Integer)e2.getValue();
                return this.key() == k2 && this.value() == v2;
            }
            catch (ClassCastException e) {
                return false;
            }
            catch (NullPointerException e) {
                return false;
            }
        }

        public int hashCode() {
            return Primitives.hashCode((int)this.key()) ^ Primitives.hashCode((int)this.value());
        }
    }

    class EntryView
    extends AbstractSetView<Map.Entry<Float, Integer>>
    implements HashObjSet<Map.Entry<Float, Integer>>,
    InternalObjCollectionOps<Map.Entry<Float, Integer>> {
        EntryView() {
        }

        @Nonnull
        public Equivalence<Map.Entry<Float, Integer>> equivalence() {
            return Equivalence.entryEquivalence((Equivalence)Equivalence.defaultEquality(), (Equivalence)Equivalence.defaultEquality());
        }

        @Nonnull
        public HashConfig hashConfig() {
            return UpdatableLHashParallelKVFloatIntMapGO.this.hashConfig();
        }

        public int size() {
            return UpdatableLHashParallelKVFloatIntMapGO.this.size;
        }

        public double currentLoad() {
            return UpdatableLHashParallelKVFloatIntMapGO.this.currentLoad();
        }

        public boolean contains(Object o) {
            try {
                Map.Entry e = (Map.Entry)o;
                return UpdatableLHashParallelKVFloatIntMapGO.this.containsEntry(((Float)e.getKey()).floatValue(), (int)((Integer)e.getValue()));
            }
            catch (NullPointerException e) {
                return false;
            }
            catch (ClassCastException e) {
                return false;
            }
        }

        @Nonnull
        public final Object[] toArray() {
            int size = this.size();
            Object[] result = new Object[size];
            if (size == 0) {
                return result;
            }
            int resultIndex = 0;
            int mc = UpdatableLHashParallelKVFloatIntMapGO.this.modCount();
            long[] tab = UpdatableLHashParallelKVFloatIntMapGO.this.table;
            for (int i = tab.length - 1; i >= 0; --i) {
                long entry = tab[i];
                int key = (int)entry;
                if (key >= 0x7FFFFFFE) continue;
                result[resultIndex++] = new MutableEntry(mc, i, key, (int)(entry >>> 32));
            }
            if (mc != UpdatableLHashParallelKVFloatIntMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return result;
        }

        @Nonnull
        public final <T> T[] toArray(@Nonnull T[] a) {
            int size = this.size();
            if (a.length < size) {
                Class<?> elementType = a.getClass().getComponentType();
                a = (Object[])Array.newInstance(elementType, size);
            }
            if (size == 0) {
                if (a.length > 0) {
                    a[0] = null;
                }
                return a;
            }
            int resultIndex = 0;
            int mc = UpdatableLHashParallelKVFloatIntMapGO.this.modCount();
            long[] tab = UpdatableLHashParallelKVFloatIntMapGO.this.table;
            for (int i = tab.length - 1; i >= 0; --i) {
                long entry = tab[i];
                int key = (int)entry;
                if (key >= 0x7FFFFFFE) continue;
                a[resultIndex++] = new MutableEntry(mc, i, key, (int)(entry >>> 32));
            }
            if (mc != UpdatableLHashParallelKVFloatIntMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            if (a.length > resultIndex) {
                a[resultIndex] = null;
            }
            return a;
        }

        public final void forEach(@Nonnull Consumer<? super Map.Entry<Float, Integer>> action) {
            if (action == null) {
                throw new NullPointerException();
            }
            if (this.isEmpty()) {
                return;
            }
            int mc = UpdatableLHashParallelKVFloatIntMapGO.this.modCount();
            long[] tab = UpdatableLHashParallelKVFloatIntMapGO.this.table;
            for (int i = tab.length - 1; i >= 0; --i) {
                long entry = tab[i];
                int key = (int)entry;
                if (key >= 0x7FFFFFFE) continue;
                action.accept((Map.Entry<Float, Integer>)((Object)new MutableEntry(mc, i, key, (int)(entry >>> 32))));
            }
            if (mc != UpdatableLHashParallelKVFloatIntMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
        }

        public boolean forEachWhile(@Nonnull Predicate<? super Map.Entry<Float, Integer>> predicate) {
            if (predicate == null) {
                throw new NullPointerException();
            }
            if (this.isEmpty()) {
                return true;
            }
            boolean terminated = false;
            int mc = UpdatableLHashParallelKVFloatIntMapGO.this.modCount();
            long[] tab = UpdatableLHashParallelKVFloatIntMapGO.this.table;
            for (int i = tab.length - 1; i >= 0; --i) {
                long entry = tab[i];
                int key = (int)entry;
                if (key >= 0x7FFFFFFE || predicate.test((Map.Entry<Float, Integer>)((Object)new MutableEntry(mc, i, key, (int)(entry >>> 32))))) continue;
                terminated = true;
                break;
            }
            if (mc != UpdatableLHashParallelKVFloatIntMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return !terminated;
        }

        @Nonnull
        public ObjIterator<Map.Entry<Float, Integer>> iterator() {
            int mc = UpdatableLHashParallelKVFloatIntMapGO.this.modCount();
            return new NoRemovedEntryIterator(mc);
        }

        @Nonnull
        public ObjCursor<Map.Entry<Float, Integer>> cursor() {
            int mc = UpdatableLHashParallelKVFloatIntMapGO.this.modCount();
            return new NoRemovedEntryCursor(mc);
        }

        public final boolean containsAll(@Nonnull Collection<?> c) {
            return CommonObjCollectionOps.containsAll((ObjCollection)this, c);
        }

        public final boolean allContainingIn(ObjCollection<?> c) {
            if (this.isEmpty()) {
                return true;
            }
            boolean containsAll = true;
            ReusableEntry e = new ReusableEntry();
            int mc = UpdatableLHashParallelKVFloatIntMapGO.this.modCount();
            long[] tab = UpdatableLHashParallelKVFloatIntMapGO.this.table;
            for (int i = tab.length - 1; i >= 0; --i) {
                long entry = tab[i];
                int key = (int)entry;
                if (key >= 0x7FFFFFFE || c.contains((Object)e.with(key, (int)(entry >>> 32)))) continue;
                containsAll = false;
                break;
            }
            if (mc != UpdatableLHashParallelKVFloatIntMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return containsAll;
        }

        public boolean reverseRemoveAllFrom(ObjSet<?> s) {
            if (this.isEmpty() || s.isEmpty()) {
                return false;
            }
            boolean changed = false;
            ReusableEntry e = new ReusableEntry();
            int mc = UpdatableLHashParallelKVFloatIntMapGO.this.modCount();
            long[] tab = UpdatableLHashParallelKVFloatIntMapGO.this.table;
            for (int i = tab.length - 1; i >= 0; --i) {
                long entry = tab[i];
                int key = (int)entry;
                if (key >= 0x7FFFFFFE) continue;
                changed |= s.remove((Object)e.with(key, (int)(entry >>> 32)));
            }
            if (mc != UpdatableLHashParallelKVFloatIntMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return changed;
        }

        public final boolean reverseAddAllTo(ObjCollection<? super Map.Entry<Float, Integer>> c) {
            if (this.isEmpty()) {
                return false;
            }
            boolean changed = false;
            int mc = UpdatableLHashParallelKVFloatIntMapGO.this.modCount();
            long[] tab = UpdatableLHashParallelKVFloatIntMapGO.this.table;
            for (int i = tab.length - 1; i >= 0; --i) {
                long entry = tab[i];
                int key = (int)entry;
                if (key >= 0x7FFFFFFE) continue;
                changed |= c.add((Object)new MutableEntry(mc, i, key, (int)(entry >>> 32)));
            }
            if (mc != UpdatableLHashParallelKVFloatIntMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            return changed;
        }

        public int hashCode() {
            return UpdatableLHashParallelKVFloatIntMapGO.this.hashCode();
        }

        public String toString() {
            if (this.isEmpty()) {
                return "[]";
            }
            StringBuilder sb = new StringBuilder();
            int elementCount = 0;
            int mc = UpdatableLHashParallelKVFloatIntMapGO.this.modCount();
            long[] tab = UpdatableLHashParallelKVFloatIntMapGO.this.table;
            for (int i = tab.length - 1; i >= 0; --i) {
                long entry = tab[i];
                int key = (int)entry;
                if (key >= 0x7FFFFFFE) continue;
                sb.append(' ');
                sb.append(Float.intBitsToFloat(key));
                sb.append('=');
                sb.append((int)(entry >>> 32));
                sb.append(',');
                if (++elementCount != 8) continue;
                int expectedLength = sb.length() * (this.size() / 8);
                sb.ensureCapacity(expectedLength + expectedLength / 2);
            }
            if (mc != UpdatableLHashParallelKVFloatIntMapGO.this.modCount()) {
                throw new ConcurrentModificationException();
            }
            sb.setCharAt(0, '[');
            sb.setCharAt(sb.length() - 1, ']');
            return sb.toString();
        }

        public boolean shrink() {
            return UpdatableLHashParallelKVFloatIntMapGO.this.shrink();
        }

        public boolean remove(Object o) {
            try {
                Map.Entry e = (Map.Entry)o;
                float key = ((Float)e.getKey()).floatValue();
                int value = (Integer)e.getValue();
                return UpdatableLHashParallelKVFloatIntMapGO.this.remove(key, value);
            }
            catch (NullPointerException e) {
                return false;
            }
            catch (ClassCastException e) {
                return false;
            }
        }

        public final boolean removeIf(@Nonnull Predicate<? super Map.Entry<Float, Integer>> filter) {
            throw new UnsupportedOperationException();
        }

        public final boolean removeAll(@Nonnull Collection<?> c) {
            if (c instanceof InternalObjCollectionOps) {
                InternalObjCollectionOps c2 = (InternalObjCollectionOps)c;
                if (this.equivalence().equals((Object)c2.equivalence()) && c2.size() < this.size()) {
                    c2.reverseRemoveAllFrom((ObjSet)this);
                }
            }
            throw new UnsupportedOperationException();
        }

        public final boolean retainAll(@Nonnull Collection<?> c) {
            throw new UnsupportedOperationException();
        }

        public void clear() {
            UpdatableLHashParallelKVFloatIntMapGO.this.doClear();
        }
    }
}

