/*
 * Decompiled with CFR 0.152.
 */
package com.koloboke.collect.impl.hash;

import com.koloboke.collect.FloatCollection;
import com.koloboke.collect.FloatCursor;
import com.koloboke.collect.impl.CommonFloatCollectionOps;
import com.koloboke.collect.impl.CommonSetOps;
import com.koloboke.collect.impl.InternalFloatCollectionOps;
import com.koloboke.collect.impl.hash.QHash;
import com.koloboke.collect.impl.hash.SeparateKVFloatQHash;
import com.koloboke.collect.impl.hash.UpdatableFloatQHashSetSO;
import com.koloboke.collect.set.hash.HashFloatSet;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.Set;
import javax.annotation.Nonnull;

public class UpdatableQHashFloatSetGO
extends UpdatableFloatQHashSetSO
implements HashFloatSet,
InternalFloatCollectionOps {
    @Override
    final void copy(SeparateKVFloatQHash hash) {
        int myMC = this.modCount();
        int hashMC = hash.modCount();
        super.copy(hash);
        if (myMC != this.modCount() || hashMC != hash.modCount()) {
            throw new ConcurrentModificationException();
        }
    }

    @Override
    final void move(SeparateKVFloatQHash hash) {
        int myMC = this.modCount();
        int hashMC = hash.modCount();
        super.move(hash);
        if (myMC != this.modCount() || hashMC != hash.modCount()) {
            throw new ConcurrentModificationException();
        }
    }

    @Override
    public int hashCode() {
        return this.setHashCode();
    }

    @Override
    public String toString() {
        return this.setToString();
    }

    @Override
    public boolean equals(Object obj) {
        return CommonSetOps.equals((Set)((Object)this), (Object)obj);
    }

    public boolean containsAll(@Nonnull Collection<?> c) {
        return CommonFloatCollectionOps.containsAll((FloatCollection)this, c);
    }

    @Nonnull
    public FloatCursor cursor() {
        return this.setCursor();
    }

    public boolean add(Float e) {
        return this.add(e.floatValue());
    }

    public boolean add(int key) {
        int[] keys = this.set;
        int capacity = keys.length;
        int index = QHash.SeparateKVFloatKeyMixing.mix((int)key) % capacity;
        int cur = keys[index];
        if (cur != 0x7FFFFFFE) {
            if (cur == key) {
                return false;
            }
            int bIndex = index;
            int fIndex = index;
            int step = 1;
            while (true) {
                if ((bIndex -= step) < 0) {
                    bIndex += capacity;
                }
                if ((cur = keys[bIndex]) == 0x7FFFFFFE) {
                    index = bIndex;
                    break;
                }
                if (cur == key) {
                    return false;
                }
                int t = (fIndex += step) - capacity;
                if (t >= 0) {
                    fIndex = t;
                }
                if ((cur = keys[fIndex]) == 0x7FFFFFFE) {
                    index = fIndex;
                    break;
                }
                if (cur == key) {
                    return false;
                }
                step += 2;
            }
        }
        this.incrementModCount();
        keys[index] = key;
        this.postInsertHook();
        return true;
    }

    public boolean add(float key) {
        return this.add(Float.floatToIntBits(key));
    }

    public boolean addAll(@Nonnull Collection<? extends Float> c) {
        return CommonFloatCollectionOps.addAll((FloatCollection)this, c);
    }

    public boolean remove(Object key) {
        return this.removeFloat(((Float)key).floatValue());
    }

    @Override
    boolean justRemove(int key) {
        return this.removeFloat(key);
    }

    public boolean removeFloat(int key) {
        throw new UnsupportedOperationException();
    }

    public boolean removeFloat(float key) {
        return this.removeFloat(Float.floatToIntBits(key));
    }

    public boolean removeAll(@Nonnull Collection<?> c) {
        throw new UnsupportedOperationException();
    }

    public boolean retainAll(@Nonnull Collection<?> c) {
        return this.retainAll(this, c);
    }
}

