/*
 * Decompiled with CFR 0.152.
 */
package co.aikar.timings;

import co.aikar.timings.Timings;
import co.aikar.timings.TimingsReportListener;
import io.github.crucible.CrucibleModContainer;
import java.util.ArrayList;
import java.util.concurrent.TimeUnit;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.scheduler.BukkitRunnable;

public class TimedTimings
extends Thread {
    public static TimedTimings timedTimings = null;
    public final int waitSeconds;
    public final long startTime;
    public long endTime = 0L;

    public static boolean isRunning() {
        return timedTimings != null && timedTimings.isAlive();
    }

    public static TimedTimings getCurrentTimedTimings() {
        return TimedTimings.isRunning() ? timedTimings : null;
    }

    public static void interruptCurrent() {
        if (TimedTimings.isRunning()) {
            timedTimings.interrupt();
        }
    }

    public long getStartTime() {
        return this.startTime;
    }

    public long getEndTime() {
        return this.endTime;
    }

    public long getSecondsTillEnds() {
        long secondsLeft = TimeUnit.MILLISECONDS.toSeconds(this.endTime - System.currentTimeMillis());
        return secondsLeft > 0L ? secondsLeft : 0L;
    }

    private TimedTimings(int waitSeconds) {
        this.waitSeconds = waitSeconds;
        this.startTime = System.currentTimeMillis();
    }

    public static void scheduleTimedTimings(int waitSeconds) {
        TimedTimings.interruptCurrent();
        timedTimings = new TimedTimings(waitSeconds);
        timedTimings.setName("Crucible Timed TimingsV2");
        timedTimings.setDaemon(true);
        timedTimings.start();
    }

    private void runSync(final Runnable runnable) {
        new BukkitRunnable(){

            @Override
            public void run() {
                runnable.run();
            }
        }.runTask(CrucibleModContainer.instance);
    }

    @Override
    public void run() {
        try {
            this.runSync(() -> Timings.setTimingsEnabled(true));
            long millisToWait = TimeUnit.SECONDS.toMillis(this.waitSeconds);
            this.endTime = System.currentTimeMillis() + millisToWait;
            Thread.sleep(millisToWait);
            ArrayList<CommandSender> staffPlayers = new ArrayList<CommandSender>();
            for (Player player : Bukkit.getOnlinePlayers()) {
                if (!player.hasPermission("bukkit.command.timings")) continue;
                staffPlayers.add(player);
            }
            TimingsReportListener timingsReportListener = new TimingsReportListener(staffPlayers, () -> Timings.setTimingsEnabled(false));
            this.runSync(() -> Timings.generateReport(timingsReportListener));
        }
        catch (InterruptedException millisToWait) {
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

