/*
 * Decompiled with CFR 0.152.
 */
package co.aikar.timings;

import co.aikar.timings.Timing;
import co.aikar.timings.TimingData;
import co.aikar.timings.TimingIdentifier;
import co.aikar.timings.Timings;
import co.aikar.timings.TimingsManager;
import co.aikar.util.LoadingIntMap;
import io.github.crucible.CrucibleConfigs;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.bukkit.Bukkit;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TimingHandler
implements Timing {
    private static AtomicInteger idPool = new AtomicInteger(1);
    private static Deque<TimingHandler> TIMING_STACK = new ArrayDeque<TimingHandler>();
    final int id = idPool.getAndIncrement();
    final TimingIdentifier identifier;
    private final boolean verbose;
    private final Int2ObjectOpenHashMap<TimingData> children = new LoadingIntMap<TimingData>(TimingData::new);
    final TimingData record;
    private TimingHandler startParent;
    private final TimingHandler groupHandler;
    private long start = 0L;
    private int timingDepth = 0;
    private boolean added;
    private boolean timed;
    private boolean enabled;

    TimingHandler(@NotNull TimingIdentifier id) {
        this.identifier = id;
        this.verbose = id.name.startsWith("##");
        this.record = new TimingData(this.id);
        this.groupHandler = id.groupHandler;
        TimingIdentifier.getGroup((String)id.group).handlers.add(this);
        this.checkEnabled();
    }

    final void checkEnabled() {
        this.enabled = Timings.timingsEnabled && (!this.verbose || Timings.verboseEnabled);
    }

    void processTick(boolean violated) {
        if (this.timingDepth != 0 || this.record.getCurTickCount() == 0) {
            this.timingDepth = 0;
            this.start = 0L;
            return;
        }
        this.record.processTick(violated);
        for (TimingData handler : this.children.values()) {
            handler.processTick(violated);
        }
    }

    @Override
    @NotNull
    public Timing startTimingIfSync() {
        this.startTiming();
        return this;
    }

    @Override
    public void stopTimingIfSync() {
        this.stopTiming();
    }

    @Override
    @NotNull
    public Timing startTiming() {
        if (!this.enabled || !Bukkit.isPrimaryThread()) {
            return this;
        }
        if (++this.timingDepth == 1) {
            this.startParent = TIMING_STACK.peekLast();
            this.start = System.nanoTime();
        }
        TIMING_STACK.addLast(this);
        return this;
    }

    @Override
    public void stopTiming() {
        if (!this.enabled || this.timingDepth <= 0 || this.start == 0L || !Bukkit.isPrimaryThread()) {
            return;
        }
        this.popTimingStack();
        if (--this.timingDepth == 0) {
            this.addDiff(System.nanoTime() - this.start, this.startParent);
            this.startParent = null;
            this.start = 0L;
        }
    }

    private void popTimingStack() {
        TimingHandler last;
        while ((last = TIMING_STACK.removeLast()) != this) {
            last.timingDepth = 0;
            String reportTo = "Minecraft".equalsIgnoreCase(last.identifier.group) ? "Crucible! This is a potential bug in Crucible" : "the plugin " + last.identifier.group + "(Look for errors above this in the logs)";
            Logger.getGlobal().log(Level.SEVERE, "TIMING_STACK_CORRUPTION - Report this to " + reportTo + " (" + last.identifier + " did not stopTiming)", new Throwable());
            boolean found = TIMING_STACK.contains(this);
            if (found) continue;
            TIMING_STACK.addLast(last);
            break;
        }
    }

    @Override
    public final void abort() {
    }

    void addDiff(long diff, @Nullable TimingHandler parent) {
        if (parent != null) {
            ((TimingData)parent.children.get(this.id)).add(diff);
        }
        this.record.add(diff);
        if (!this.added) {
            this.added = true;
            this.timed = true;
            TimingsManager.HANDLERS.add(this);
        }
        if (this.groupHandler != null) {
            this.groupHandler.addDiff(diff, parent);
            ((TimingData)this.groupHandler.children.get(this.id)).add(diff);
        }
    }

    void reset(boolean full) {
        this.record.reset();
        if (full) {
            this.timed = false;
        }
        this.start = 0L;
        this.timingDepth = 0;
        this.added = false;
        this.children.clear();
        this.checkEnabled();
    }

    @Override
    @NotNull
    public TimingHandler getTimingHandler() {
        return this;
    }

    public boolean equals(Object o) {
        return this == o;
    }

    public int hashCode() {
        return this.id;
    }

    @Override
    public void close() {
        this.stopTimingIfSync();
    }

    public boolean isSpecial() {
        return this == TimingsManager.FULL_SERVER_TICK || this == TimingsManager.TIMINGS_TICK;
    }

    boolean isTimed() {
        return this.timed;
    }

    public boolean shouldBeSkiped() {
        double result = (double)this.record.getTotalTime() / (double)this.record.getCount();
        return result < (double)CrucibleConfigs.configs.timings_ultraverbose_limiar;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    @NotNull
    TimingData[] cloneChildren() {
        TimingData[] clonedChildren = new TimingData[this.children.size()];
        int i = 0;
        for (TimingData child : this.children.values()) {
            clonedChildren[i++] = child.clone();
        }
        return clonedChildren;
    }
}

