/*
 * Decompiled with CFR 0.152.
 */
package co.aikar.timings;

import co.aikar.timings.Timing;
import co.aikar.timings.TimingHandler;
import co.aikar.timings.TimingIdentifier;
import org.bukkit.Bukkit;
import org.jetbrains.annotations.NotNull;

public class UnsafeTimingHandler
extends TimingHandler {
    UnsafeTimingHandler(@NotNull TimingIdentifier id) {
        super(id);
    }

    private static void checkThread() {
        if (!Bukkit.isPrimaryThread()) {
            throw new IllegalStateException("Calling Timings from Async Operation");
        }
    }

    @Override
    @NotNull
    public Timing startTiming() {
        UnsafeTimingHandler.checkThread();
        return super.startTiming();
    }

    @Override
    public void stopTiming() {
        UnsafeTimingHandler.checkThread();
        super.stopTiming();
    }
}

