/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.base;

import com.google.common.annotations.Beta;
import com.google.common.annotations.GwtCompatible;
import com.google.common.base.Converter;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import javax.annotation.Nullable;

@Beta
@GwtCompatible
public abstract class Converter<A, B>
implements Function<A, B> {
    private final boolean handleNullAutomatically;
    private transient Converter<B, A> reverse;

    protected Converter() {
        this(true);
    }

    Converter(boolean handleNullAutomatically) {
        this.handleNullAutomatically = handleNullAutomatically;
    }

    protected abstract B doForward(A var1);

    protected abstract A doBackward(B var1);

    @Nullable
    public final B convert(@Nullable A a2) {
        return (B)this.correctedDoForward(a2);
    }

    @Nullable
    B correctedDoForward(@Nullable A a2) {
        if (this.handleNullAutomatically) {
            return (B)(a2 == null ? null : Preconditions.checkNotNull((Object)this.doForward(a2)));
        }
        return (B)this.doForward(a2);
    }

    @Nullable
    A correctedDoBackward(@Nullable B b2) {
        if (this.handleNullAutomatically) {
            return (A)(b2 == null ? null : Preconditions.checkNotNull((Object)this.doBackward(b2)));
        }
        return (A)this.doBackward(b2);
    }

    public Iterable<B> convertAll(Iterable<? extends A> fromIterable) {
        Preconditions.checkNotNull(fromIterable, (Object)"fromIterable");
        return new /* Unavailable Anonymous Inner Class!! */;
    }

    public Converter<B, A> reverse() {
        Converter result = this.reverse;
        return result == null ? (this.reverse = new ReverseConverter(this)) : result;
    }

    public <C> Converter<A, C> andThen(Converter<B, C> secondConverter) {
        return new ConverterComposition(this, (Converter)Preconditions.checkNotNull(secondConverter));
    }

    @Deprecated
    @Nullable
    public final B apply(@Nullable A a2) {
        return (B)this.convert(a2);
    }

    public boolean equals(@Nullable Object object) {
        return super.equals(object);
    }

    public static <A, B> Converter<A, B> from(Function<? super A, ? extends B> forwardFunction, Function<? super B, ? extends A> backwardFunction) {
        return new FunctionBasedConverter(forwardFunction, backwardFunction, null);
    }

    public static <T> Converter<T, T> identity() {
        return IdentityConverter.INSTANCE;
    }
}

