/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.cache;

import com.google.common.annotations.Beta;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheBuilderSpec;
import com.google.common.cache.LocalCache;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;

/*
 * Exception performing whole class analysis ignored.
 */
@Beta
public final class CacheBuilderSpec {
    private static final Splitter KEYS_SPLITTER = Splitter.on((char)',').trimResults();
    private static final Splitter KEY_VALUE_SPLITTER = Splitter.on((char)'=').trimResults();
    private static final ImmutableMap<String, ValueParser> VALUE_PARSERS = ImmutableMap.builder().put((Object)"initialCapacity", (Object)new InitialCapacityParser()).put((Object)"maximumSize", (Object)new MaximumSizeParser()).put((Object)"maximumWeight", (Object)new MaximumWeightParser()).put((Object)"concurrencyLevel", (Object)new ConcurrencyLevelParser()).put((Object)"weakKeys", (Object)new KeyStrengthParser(LocalCache.Strength.WEAK)).put((Object)"softValues", (Object)new ValueStrengthParser(LocalCache.Strength.SOFT)).put((Object)"weakValues", (Object)new ValueStrengthParser(LocalCache.Strength.WEAK)).put((Object)"recordStats", (Object)new RecordStatsParser()).put((Object)"expireAfterAccess", (Object)new AccessDurationParser()).put((Object)"expireAfterWrite", (Object)new WriteDurationParser()).put((Object)"refreshAfterWrite", (Object)new RefreshDurationParser()).put((Object)"refreshInterval", (Object)new RefreshDurationParser()).build();
    @VisibleForTesting
    Integer initialCapacity;
    @VisibleForTesting
    Long maximumSize;
    @VisibleForTesting
    Long maximumWeight;
    @VisibleForTesting
    Integer concurrencyLevel;
    @VisibleForTesting
    LocalCache.Strength keyStrength;
    @VisibleForTesting
    LocalCache.Strength valueStrength;
    @VisibleForTesting
    Boolean recordStats;
    @VisibleForTesting
    long writeExpirationDuration;
    @VisibleForTesting
    TimeUnit writeExpirationTimeUnit;
    @VisibleForTesting
    long accessExpirationDuration;
    @VisibleForTesting
    TimeUnit accessExpirationTimeUnit;
    @VisibleForTesting
    long refreshDuration;
    @VisibleForTesting
    TimeUnit refreshTimeUnit;
    private final String specification;

    private CacheBuilderSpec(String specification) {
        this.specification = specification;
    }

    public static CacheBuilderSpec parse(String cacheBuilderSpecification) {
        CacheBuilderSpec spec = new CacheBuilderSpec(cacheBuilderSpecification);
        if (!cacheBuilderSpecification.isEmpty()) {
            for (String keyValuePair : KEYS_SPLITTER.split((CharSequence)cacheBuilderSpecification)) {
                ImmutableList keyAndValue = ImmutableList.copyOf((Iterable)KEY_VALUE_SPLITTER.split((CharSequence)keyValuePair));
                Preconditions.checkArgument((!keyAndValue.isEmpty() ? 1 : 0) != 0, (Object)"blank key-value pair");
                Preconditions.checkArgument((keyAndValue.size() <= 2 ? 1 : 0) != 0, (String)"key-value pair %s with more than one equals sign", (Object[])new Object[]{keyValuePair});
                String key = (String)keyAndValue.get(0);
                ValueParser valueParser = (ValueParser)VALUE_PARSERS.get((Object)key);
                Preconditions.checkArgument((valueParser != null ? 1 : 0) != 0, (String)"unknown key %s", (Object[])new Object[]{key});
                String value = keyAndValue.size() == 1 ? null : (String)keyAndValue.get(1);
                valueParser.parse(spec, key, value);
            }
        }
        return spec;
    }

    public static CacheBuilderSpec disableCaching() {
        return CacheBuilderSpec.parse((String)"maximumSize=0");
    }

    CacheBuilder<Object, Object> toCacheBuilder() {
        CacheBuilder builder = CacheBuilder.newBuilder();
        if (this.initialCapacity != null) {
            builder.initialCapacity(this.initialCapacity.intValue());
        }
        if (this.maximumSize != null) {
            builder.maximumSize(this.maximumSize.longValue());
        }
        if (this.maximumWeight != null) {
            builder.maximumWeight(this.maximumWeight.longValue());
        }
        if (this.concurrencyLevel != null) {
            builder.concurrencyLevel(this.concurrencyLevel.intValue());
        }
        if (this.keyStrength != null) {
            switch (1.$SwitchMap$com$google$common$cache$LocalCache$Strength[this.keyStrength.ordinal()]) {
                case 1: {
                    builder.weakKeys();
                    break;
                }
                default: {
                    throw new AssertionError();
                }
            }
        }
        if (this.valueStrength != null) {
            switch (1.$SwitchMap$com$google$common$cache$LocalCache$Strength[this.valueStrength.ordinal()]) {
                case 2: {
                    builder.softValues();
                    break;
                }
                case 1: {
                    builder.weakValues();
                    break;
                }
                default: {
                    throw new AssertionError();
                }
            }
        }
        if (this.recordStats != null && this.recordStats.booleanValue()) {
            builder.recordStats();
        }
        if (this.writeExpirationTimeUnit != null) {
            builder.expireAfterWrite(this.writeExpirationDuration, this.writeExpirationTimeUnit);
        }
        if (this.accessExpirationTimeUnit != null) {
            builder.expireAfterAccess(this.accessExpirationDuration, this.accessExpirationTimeUnit);
        }
        if (this.refreshTimeUnit != null) {
            builder.refreshAfterWrite(this.refreshDuration, this.refreshTimeUnit);
        }
        return builder;
    }

    public String toParsableString() {
        return this.specification;
    }

    public String toString() {
        return Objects.toStringHelper((Object)this).addValue((Object)this.toParsableString()).toString();
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.initialCapacity, this.maximumSize, this.maximumWeight, this.concurrencyLevel, this.keyStrength, this.valueStrength, this.recordStats, CacheBuilderSpec.durationInNanos((long)this.writeExpirationDuration, (TimeUnit)this.writeExpirationTimeUnit), CacheBuilderSpec.durationInNanos((long)this.accessExpirationDuration, (TimeUnit)this.accessExpirationTimeUnit), CacheBuilderSpec.durationInNanos((long)this.refreshDuration, (TimeUnit)this.refreshTimeUnit)});
    }

    public boolean equals(@Nullable Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof CacheBuilderSpec)) {
            return false;
        }
        CacheBuilderSpec that = (CacheBuilderSpec)obj;
        return Objects.equal((Object)this.initialCapacity, (Object)that.initialCapacity) && Objects.equal((Object)this.maximumSize, (Object)that.maximumSize) && Objects.equal((Object)this.maximumWeight, (Object)that.maximumWeight) && Objects.equal((Object)this.concurrencyLevel, (Object)that.concurrencyLevel) && Objects.equal((Object)this.keyStrength, (Object)that.keyStrength) && Objects.equal((Object)this.valueStrength, (Object)that.valueStrength) && Objects.equal((Object)this.recordStats, (Object)that.recordStats) && Objects.equal((Object)CacheBuilderSpec.durationInNanos((long)this.writeExpirationDuration, (TimeUnit)this.writeExpirationTimeUnit), (Object)CacheBuilderSpec.durationInNanos((long)that.writeExpirationDuration, (TimeUnit)that.writeExpirationTimeUnit)) && Objects.equal((Object)CacheBuilderSpec.durationInNanos((long)this.accessExpirationDuration, (TimeUnit)this.accessExpirationTimeUnit), (Object)CacheBuilderSpec.durationInNanos((long)that.accessExpirationDuration, (TimeUnit)that.accessExpirationTimeUnit)) && Objects.equal((Object)CacheBuilderSpec.durationInNanos((long)this.refreshDuration, (TimeUnit)this.refreshTimeUnit), (Object)CacheBuilderSpec.durationInNanos((long)that.refreshDuration, (TimeUnit)that.refreshTimeUnit));
    }

    @Nullable
    private static Long durationInNanos(long duration, @Nullable TimeUnit unit) {
        return unit == null ? null : Long.valueOf(unit.toNanos(duration));
    }
}

