/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.cache;

import com.google.common.annotations.Beta;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheStats;
import com.google.common.collect.ForwardingObject;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutionException;
import javax.annotation.Nullable;

@Beta
public abstract class ForwardingCache<K, V>
extends ForwardingObject
implements Cache<K, V> {
    protected ForwardingCache() {
    }

    protected abstract Cache<K, V> delegate();

    @Nullable
    public V getIfPresent(Object key) {
        return (V)this.delegate().getIfPresent(key);
    }

    public V get(K key, Callable<? extends V> valueLoader) throws ExecutionException {
        return (V)this.delegate().get(key, valueLoader);
    }

    public ImmutableMap<K, V> getAllPresent(Iterable<?> keys) {
        return this.delegate().getAllPresent(keys);
    }

    public void put(K key, V value) {
        this.delegate().put(key, value);
    }

    public void putAll(Map<? extends K, ? extends V> m) {
        this.delegate().putAll(m);
    }

    public void invalidate(Object key) {
        this.delegate().invalidate(key);
    }

    public void invalidateAll(Iterable<?> keys) {
        this.delegate().invalidateAll(keys);
    }

    public void invalidateAll() {
        this.delegate().invalidateAll();
    }

    public long size() {
        return this.delegate().size();
    }

    public CacheStats stats() {
        return this.delegate().stats();
    }

    public ConcurrentMap<K, V> asMap() {
        return this.delegate().asMap();
    }

    public void cleanUp() {
        this.delegate().cleanUp();
    }
}

