/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.collect;

import com.google.common.annotations.GwtCompatible;
import com.google.common.base.Preconditions;
import com.google.common.collect.AbstractMultiset;
import com.google.common.collect.BoundType;
import com.google.common.collect.GwtTransient;
import com.google.common.collect.Multiset;
import com.google.common.collect.Multisets;
import com.google.common.collect.Ordering;
import com.google.common.collect.SortedMultiset;
import com.google.common.collect.SortedMultisets;
import java.util.Comparator;
import java.util.Iterator;
import java.util.NavigableSet;
import javax.annotation.Nullable;

@GwtCompatible(emulated=true)
abstract class AbstractSortedMultiset<E>
extends AbstractMultiset<E>
implements SortedMultiset<E> {
    @GwtTransient
    final Comparator<? super E> comparator;
    private transient SortedMultiset<E> descendingMultiset;

    AbstractSortedMultiset() {
        this((Comparator)Ordering.natural());
    }

    AbstractSortedMultiset(Comparator<? super E> comparator) {
        this.comparator = (Comparator)Preconditions.checkNotNull(comparator);
    }

    public NavigableSet<E> elementSet() {
        return (NavigableSet)super.elementSet();
    }

    NavigableSet<E> createElementSet() {
        return new SortedMultisets.NavigableElementSet((SortedMultiset)this);
    }

    public Comparator<? super E> comparator() {
        return this.comparator;
    }

    public Multiset.Entry<E> firstEntry() {
        Iterator entryIterator = this.entryIterator();
        return entryIterator.hasNext() ? (Multiset.Entry)entryIterator.next() : null;
    }

    public Multiset.Entry<E> lastEntry() {
        Iterator entryIterator = this.descendingEntryIterator();
        return entryIterator.hasNext() ? (Multiset.Entry)entryIterator.next() : null;
    }

    public Multiset.Entry<E> pollFirstEntry() {
        Iterator entryIterator = this.entryIterator();
        if (entryIterator.hasNext()) {
            Multiset.Entry result = (Multiset.Entry)entryIterator.next();
            result = Multisets.immutableEntry((Object)result.getElement(), (int)result.getCount());
            entryIterator.remove();
            return result;
        }
        return null;
    }

    public Multiset.Entry<E> pollLastEntry() {
        Iterator entryIterator = this.descendingEntryIterator();
        if (entryIterator.hasNext()) {
            Multiset.Entry result = (Multiset.Entry)entryIterator.next();
            result = Multisets.immutableEntry((Object)result.getElement(), (int)result.getCount());
            entryIterator.remove();
            return result;
        }
        return null;
    }

    public SortedMultiset<E> subMultiset(@Nullable E fromElement, BoundType fromBoundType, @Nullable E toElement, BoundType toBoundType) {
        Preconditions.checkNotNull((Object)fromBoundType);
        Preconditions.checkNotNull((Object)toBoundType);
        return this.tailMultiset(fromElement, fromBoundType).headMultiset(toElement, toBoundType);
    }

    abstract Iterator<Multiset.Entry<E>> descendingEntryIterator();

    Iterator<E> descendingIterator() {
        return Multisets.iteratorImpl((Multiset)this.descendingMultiset());
    }

    public SortedMultiset<E> descendingMultiset() {
        SortedMultiset result = this.descendingMultiset;
        return result == null ? (this.descendingMultiset = this.createDescendingMultiset()) : result;
    }

    SortedMultiset<E> createDescendingMultiset() {
        return new /* Unavailable Anonymous Inner Class!! */;
    }
}

