/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.collect;

import com.google.common.annotations.GwtCompatible;
import com.google.common.annotations.GwtIncompatible;
import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableMapValues;
import com.google.common.collect.Iterators;
import com.google.common.collect.Maps;
import com.google.common.collect.UnmodifiableIterator;
import java.util.Iterator;
import javax.annotation.Nullable;

@GwtCompatible(emulated=true)
final class ImmutableMapValues<K, V>
extends ImmutableCollection<V> {
    private final ImmutableMap<K, V> map;

    ImmutableMapValues(ImmutableMap<K, V> map) {
        this.map = map;
    }

    public int size() {
        return this.map.size();
    }

    public UnmodifiableIterator<V> iterator() {
        return Maps.valueIterator((UnmodifiableIterator)this.map.entrySet().iterator());
    }

    public boolean contains(@Nullable Object object) {
        return object != null && Iterators.contains((Iterator)this.iterator(), (Object)object);
    }

    boolean isPartialView() {
        return true;
    }

    ImmutableList<V> createAsList() {
        ImmutableList entryList = this.map.entrySet().asList();
        return new /* Unavailable Anonymous Inner Class!! */;
    }

    @GwtIncompatible(value="serialization")
    Object writeReplace() {
        return new SerializedForm(this.map);
    }
}

