/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.collect;

import com.google.common.annotations.GwtCompatible;
import com.google.common.collect.CollectPreconditions;
import com.google.common.collect.Hashing;
import com.google.common.collect.ImmutableBiMap;
import com.google.common.collect.ImmutableMapEntry;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.RegularImmutableBiMap;
import java.util.Map;
import javax.annotation.Nullable;

/*
 * Exception performing whole class analysis ignored.
 */
@GwtCompatible(serializable=true, emulated=true)
class RegularImmutableBiMap<K, V>
extends ImmutableBiMap<K, V> {
    static final double MAX_LOAD_FACTOR = 1.2;
    private final transient ImmutableMapEntry<K, V>[] keyTable;
    private final transient ImmutableMapEntry<K, V>[] valueTable;
    private final transient ImmutableMapEntry<K, V>[] entries;
    private final transient int mask;
    private final transient int hashCode;
    private transient ImmutableBiMap<V, K> inverse;

    RegularImmutableBiMap(ImmutableMapEntry.TerminalEntry<?, ?> ... entriesToAdd) {
        this(entriesToAdd.length, entriesToAdd);
    }

    RegularImmutableBiMap(int n, ImmutableMapEntry.TerminalEntry<?, ?>[] entriesToAdd) {
        int tableSize = Hashing.closedTableSize((int)n, (double)1.2);
        this.mask = tableSize - 1;
        ImmutableMapEntry[] keyTable = RegularImmutableBiMap.createEntryArray((int)tableSize);
        ImmutableMapEntry[] valueTable = RegularImmutableBiMap.createEntryArray((int)tableSize);
        ImmutableMapEntry[] entries = RegularImmutableBiMap.createEntryArray((int)n);
        int hashCode = 0;
        for (int i = 0; i < n; ++i) {
            ImmutableMapEntry.TerminalEntry<?, ?> newEntry;
            ImmutableMapEntry.TerminalEntry<?, ?> terminalEntry;
            ImmutableMapEntry nextInValueBucket;
            ImmutableMapEntry nextInKeyBucket;
            ImmutableMapEntry.TerminalEntry<?, ?> entry = entriesToAdd[i];
            Object key = entry.getKey();
            Object value = entry.getValue();
            int keyHash = key.hashCode();
            int valueHash = value.hashCode();
            int keyBucket = Hashing.smear((int)keyHash) & this.mask;
            int valueBucket = Hashing.smear((int)valueHash) & this.mask;
            for (ImmutableMapEntry keyEntry = nextInKeyBucket = keyTable[keyBucket]; keyEntry != null; keyEntry = keyEntry.getNextInKeyBucket()) {
                RegularImmutableBiMap.checkNoConflict((!key.equals(keyEntry.getKey()) ? 1 : 0) != 0, (String)"key", entry, (Map.Entry)keyEntry);
            }
            for (ImmutableMapEntry valueEntry = nextInValueBucket = valueTable[valueBucket]; valueEntry != null; valueEntry = valueEntry.getNextInValueBucket()) {
                RegularImmutableBiMap.checkNoConflict((!value.equals(valueEntry.getValue()) ? 1 : 0) != 0, (String)"value", entry, (Map.Entry)valueEntry);
            }
            if (nextInKeyBucket == null && nextInValueBucket == null) {
                terminalEntry = entry;
            } else {
                ImmutableMapEntry.TerminalEntry<?, ?> terminalEntry2;
                terminalEntry = terminalEntry2;
                super(entry, nextInKeyBucket, nextInValueBucket);
            }
            keyTable[keyBucket] = newEntry = terminalEntry;
            valueTable[valueBucket] = newEntry;
            entries[i] = newEntry;
            hashCode += keyHash ^ valueHash;
        }
        this.keyTable = keyTable;
        this.valueTable = valueTable;
        this.entries = entries;
        this.hashCode = hashCode;
    }

    RegularImmutableBiMap(Map.Entry<?, ?>[] entriesToAdd) {
        int n = entriesToAdd.length;
        int tableSize = Hashing.closedTableSize((int)n, (double)1.2);
        this.mask = tableSize - 1;
        ImmutableMapEntry[] keyTable = RegularImmutableBiMap.createEntryArray((int)tableSize);
        ImmutableMapEntry[] valueTable = RegularImmutableBiMap.createEntryArray((int)tableSize);
        ImmutableMapEntry[] entries = RegularImmutableBiMap.createEntryArray((int)n);
        int hashCode = 0;
        for (int i = 0; i < n; ++i) {
            ImmutableMapEntry nextInValueBucket;
            ImmutableMapEntry nextInKeyBucket;
            Map.Entry<?, ?> entry = entriesToAdd[i];
            Object key = entry.getKey();
            Object value = entry.getValue();
            CollectPreconditions.checkEntryNotNull(key, value);
            int keyHash = key.hashCode();
            int valueHash = value.hashCode();
            int keyBucket = Hashing.smear((int)keyHash) & this.mask;
            int valueBucket = Hashing.smear((int)valueHash) & this.mask;
            for (ImmutableMapEntry keyEntry = nextInKeyBucket = keyTable[keyBucket]; keyEntry != null; keyEntry = keyEntry.getNextInKeyBucket()) {
                RegularImmutableBiMap.checkNoConflict((!key.equals(keyEntry.getKey()) ? 1 : 0) != 0, (String)"key", entry, (Map.Entry)keyEntry);
            }
            for (ImmutableMapEntry valueEntry = nextInValueBucket = valueTable[valueBucket]; valueEntry != null; valueEntry = valueEntry.getNextInValueBucket()) {
                RegularImmutableBiMap.checkNoConflict((!value.equals(valueEntry.getValue()) ? 1 : 0) != 0, (String)"value", entry, (Map.Entry)valueEntry);
            }
            NonTerminalBiMapEntry newEntry = nextInKeyBucket == null && nextInValueBucket == null ? new ImmutableMapEntry.TerminalEntry(key, value) : new NonTerminalBiMapEntry(key, value, nextInKeyBucket, nextInValueBucket);
            keyTable[keyBucket] = newEntry;
            valueTable[valueBucket] = newEntry;
            entries[i] = newEntry;
            hashCode += keyHash ^ valueHash;
        }
        this.keyTable = keyTable;
        this.valueTable = valueTable;
        this.entries = entries;
        this.hashCode = hashCode;
    }

    private static <K, V> ImmutableMapEntry<K, V>[] createEntryArray(int length) {
        return new ImmutableMapEntry[length];
    }

    @Nullable
    public V get(@Nullable Object key) {
        if (key == null) {
            return null;
        }
        int bucket = Hashing.smear((int)key.hashCode()) & this.mask;
        for (ImmutableMapEntry entry = this.keyTable[bucket]; entry != null; entry = entry.getNextInKeyBucket()) {
            if (!key.equals(entry.getKey())) continue;
            return (V)entry.getValue();
        }
        return null;
    }

    ImmutableSet<Map.Entry<K, V>> createEntrySet() {
        return new /* Unavailable Anonymous Inner Class!! */;
    }

    boolean isPartialView() {
        return false;
    }

    public int size() {
        return this.entries.length;
    }

    public ImmutableBiMap<V, K> inverse() {
        ImmutableBiMap result = this.inverse;
        return result == null ? (this.inverse = new Inverse(this, null)) : result;
    }

    static /* synthetic */ ImmutableMapEntry[] access$000(RegularImmutableBiMap x0) {
        return x0.entries;
    }

    static /* synthetic */ int access$100(RegularImmutableBiMap x0) {
        return x0.hashCode;
    }

    static /* synthetic */ int access$300(RegularImmutableBiMap x0) {
        return x0.mask;
    }

    static /* synthetic */ ImmutableMapEntry[] access$400(RegularImmutableBiMap x0) {
        return x0.valueTable;
    }
}

