/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.hash;

import com.google.common.annotations.Beta;
import com.google.common.base.Preconditions;
import com.google.common.hash.HashCode;
import com.google.common.primitives.Ints;
import java.security.MessageDigest;
import javax.annotation.Nullable;

/*
 * Exception performing whole class analysis ignored.
 */
@Beta
public abstract class HashCode {
    private static final char[] hexDigits = "0123456789abcdef".toCharArray();

    HashCode() {
    }

    public abstract int bits();

    public abstract int asInt();

    public abstract long asLong();

    public abstract long padToLong();

    public abstract byte[] asBytes();

    public int writeBytesTo(byte[] dest, int offset, int maxLength) {
        maxLength = Ints.min((int[])new int[]{maxLength, this.bits() / 8});
        Preconditions.checkPositionIndexes((int)offset, (int)(offset + maxLength), (int)dest.length);
        this.writeBytesToImpl(dest, offset, maxLength);
        return maxLength;
    }

    abstract void writeBytesToImpl(byte[] var1, int var2, int var3);

    byte[] getBytesInternal() {
        return this.asBytes();
    }

    public static HashCode fromInt(int hash) {
        return new IntHashCode(hash);
    }

    public static HashCode fromLong(long hash) {
        return new LongHashCode(hash);
    }

    public static HashCode fromBytes(byte[] bytes) {
        Preconditions.checkArgument((bytes.length >= 1 ? 1 : 0) != 0, (Object)"A HashCode must contain at least 1 byte.");
        return HashCode.fromBytesNoCopy((byte[])((byte[])bytes.clone()));
    }

    static HashCode fromBytesNoCopy(byte[] bytes) {
        return new BytesHashCode(bytes);
    }

    public static HashCode fromString(String string) {
        Preconditions.checkArgument((string.length() >= 2 ? 1 : 0) != 0, (String)"input string (%s) must have at least 2 characters", (Object[])new Object[]{string});
        Preconditions.checkArgument((string.length() % 2 == 0 ? 1 : 0) != 0, (String)"input string (%s) must have an even number of characters", (Object[])new Object[]{string});
        byte[] bytes = new byte[string.length() / 2];
        for (int i = 0; i < string.length(); i += 2) {
            int ch1 = HashCode.decode((char)string.charAt(i)) << 4;
            int ch2 = HashCode.decode((char)string.charAt(i + 1));
            bytes[i / 2] = (byte)(ch1 + ch2);
        }
        return HashCode.fromBytesNoCopy((byte[])bytes);
    }

    private static int decode(char ch) {
        if (ch >= '0' && ch <= '9') {
            return ch - 48;
        }
        if (ch >= 'a' && ch <= 'f') {
            return ch - 97 + 10;
        }
        throw new IllegalArgumentException("Illegal hexadecimal character: " + ch);
    }

    public final boolean equals(@Nullable Object object) {
        if (object instanceof HashCode) {
            HashCode that = (HashCode)object;
            return MessageDigest.isEqual(this.asBytes(), that.asBytes());
        }
        return false;
    }

    public final int hashCode() {
        if (this.bits() >= 32) {
            return this.asInt();
        }
        byte[] bytes = this.asBytes();
        int val = bytes[0] & 0xFF;
        for (int i = 1; i < bytes.length; ++i) {
            val |= (bytes[i] & 0xFF) << i * 8;
        }
        return val;
    }

    public final String toString() {
        byte[] bytes = this.asBytes();
        StringBuilder sb = new StringBuilder(2 * bytes.length);
        for (byte b2 : bytes) {
            sb.append(hexDigits[b2 >> 4 & 0xF]).append(hexDigits[b2 & 0xF]);
        }
        return sb.toString();
    }
}

