/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.io;

import com.google.common.annotations.Beta;
import com.google.common.annotations.GwtCompatible;
import com.google.common.annotations.GwtIncompatible;
import com.google.common.base.CharMatcher;
import com.google.common.base.Preconditions;
import com.google.common.io.BaseEncoding;
import com.google.common.io.ByteSink;
import com.google.common.io.ByteSource;
import com.google.common.io.CharSink;
import com.google.common.io.CharSource;
import com.google.common.io.GwtWorkarounds;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import javax.annotation.CheckReturnValue;

/*
 * Exception performing whole class analysis ignored.
 */
@Beta
@GwtCompatible(emulated=true)
public abstract class BaseEncoding {
    private static final BaseEncoding BASE64 = new StandardBaseEncoding("base64()", "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/", Character.valueOf('='));
    private static final BaseEncoding BASE64_URL = new StandardBaseEncoding("base64Url()", "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789-_", Character.valueOf('='));
    private static final BaseEncoding BASE32 = new StandardBaseEncoding("base32()", "ABCDEFGHIJKLMNOPQRSTUVWXYZ234567", Character.valueOf('='));
    private static final BaseEncoding BASE32_HEX = new StandardBaseEncoding("base32Hex()", "0123456789ABCDEFGHIJKLMNOPQRSTUV", Character.valueOf('='));
    private static final BaseEncoding BASE16 = new StandardBaseEncoding("base16()", "0123456789ABCDEF", null);

    BaseEncoding() {
    }

    public String encode(byte[] bytes) {
        return this.encode((byte[])Preconditions.checkNotNull((Object)bytes), 0, bytes.length);
    }

    public final String encode(byte[] bytes, int off, int len) {
        Preconditions.checkNotNull((Object)bytes);
        Preconditions.checkPositionIndexes((int)off, (int)(off + len), (int)bytes.length);
        GwtWorkarounds.CharOutput result = GwtWorkarounds.stringBuilderOutput((int)this.maxEncodedSize(len));
        GwtWorkarounds.ByteOutput byteOutput = this.encodingStream(result);
        try {
            for (int i = 0; i < len; ++i) {
                byteOutput.write(bytes[off + i]);
            }
            byteOutput.close();
        }
        catch (IOException impossible) {
            throw new AssertionError((Object)"impossible");
        }
        return result.toString();
    }

    @GwtIncompatible(value="Writer,OutputStream")
    public final OutputStream encodingStream(Writer writer) {
        return GwtWorkarounds.asOutputStream((GwtWorkarounds.ByteOutput)this.encodingStream(GwtWorkarounds.asCharOutput((Writer)writer)));
    }

    @GwtIncompatible(value="ByteSink,CharSink")
    public final ByteSink encodingSink(CharSink encodedSink) {
        Preconditions.checkNotNull((Object)encodedSink);
        return new /* Unavailable Anonymous Inner Class!! */;
    }

    private static byte[] extract(byte[] result, int length) {
        if (length == result.length) {
            return result;
        }
        byte[] trunc = new byte[length];
        System.arraycopy(result, 0, trunc, 0, length);
        return trunc;
    }

    public final byte[] decode(CharSequence chars) {
        try {
            return this.decodeChecked(chars);
        }
        catch (DecodingException badInput) {
            throw new IllegalArgumentException(badInput);
        }
    }

    final byte[] decodeChecked(CharSequence chars) throws DecodingException {
        chars = this.padding().trimTrailingFrom(chars);
        GwtWorkarounds.ByteInput decodedInput = this.decodingStream(GwtWorkarounds.asCharInput((CharSequence)chars));
        byte[] tmp = new byte[this.maxDecodedSize(chars.length())];
        int index = 0;
        try {
            int i = decodedInput.read();
            while (i != -1) {
                tmp[index++] = (byte)i;
                i = decodedInput.read();
            }
        }
        catch (DecodingException badInput) {
            throw badInput;
        }
        catch (IOException impossible) {
            throw new AssertionError((Object)impossible);
        }
        return BaseEncoding.extract((byte[])tmp, (int)index);
    }

    @GwtIncompatible(value="Reader,InputStream")
    public final InputStream decodingStream(Reader reader) {
        return GwtWorkarounds.asInputStream((GwtWorkarounds.ByteInput)this.decodingStream(GwtWorkarounds.asCharInput((Reader)reader)));
    }

    @GwtIncompatible(value="ByteSource,CharSource")
    public final ByteSource decodingSource(CharSource encodedSource) {
        Preconditions.checkNotNull((Object)encodedSource);
        return new /* Unavailable Anonymous Inner Class!! */;
    }

    abstract int maxEncodedSize(int var1);

    abstract GwtWorkarounds.ByteOutput encodingStream(GwtWorkarounds.CharOutput var1);

    abstract int maxDecodedSize(int var1);

    abstract GwtWorkarounds.ByteInput decodingStream(GwtWorkarounds.CharInput var1);

    abstract CharMatcher padding();

    @CheckReturnValue
    public abstract BaseEncoding omitPadding();

    @CheckReturnValue
    public abstract BaseEncoding withPadChar(char var1);

    @CheckReturnValue
    public abstract BaseEncoding withSeparator(String var1, int var2);

    @CheckReturnValue
    public abstract BaseEncoding upperCase();

    @CheckReturnValue
    public abstract BaseEncoding lowerCase();

    public static BaseEncoding base64() {
        return BASE64;
    }

    public static BaseEncoding base64Url() {
        return BASE64_URL;
    }

    public static BaseEncoding base32() {
        return BASE32;
    }

    public static BaseEncoding base32Hex() {
        return BASE32_HEX;
    }

    public static BaseEncoding base16() {
        return BASE16;
    }

    static GwtWorkarounds.CharInput ignoringInput(GwtWorkarounds.CharInput delegate, CharMatcher toIgnore) {
        Preconditions.checkNotNull((Object)delegate);
        Preconditions.checkNotNull((Object)toIgnore);
        return new /* Unavailable Anonymous Inner Class!! */;
    }

    static GwtWorkarounds.CharOutput separatingOutput(GwtWorkarounds.CharOutput delegate, String separator, int afterEveryChars) {
        Preconditions.checkNotNull((Object)delegate);
        Preconditions.checkNotNull((Object)separator);
        Preconditions.checkArgument((afterEveryChars > 0 ? 1 : 0) != 0);
        return new /* Unavailable Anonymous Inner Class!! */;
    }
}

