/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.math;

import com.google.common.annotations.GwtCompatible;
import com.google.common.annotations.GwtIncompatible;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.math.IntMath;
import com.google.common.math.MathPreconditions;
import java.math.RoundingMode;

/*
 * Exception performing whole class analysis ignored.
 */
@GwtCompatible(emulated=true)
public final class IntMath {
    @VisibleForTesting
    static final int MAX_POWER_OF_SQRT2_UNSIGNED = -1257966797;
    @VisibleForTesting
    static final byte[] maxLog10ForLeadingZeros = new byte[]{9, 9, 9, 8, 8, 8, 7, 7, 7, 6, 6, 6, 6, 5, 5, 5, 4, 4, 4, 3, 3, 3, 3, 2, 2, 2, 1, 1, 1, 0, 0, 0, 0};
    @VisibleForTesting
    static final int[] powersOf10 = new int[]{1, 10, 100, 1000, 10000, 100000, 1000000, 10000000, 100000000, 1000000000};
    @VisibleForTesting
    static final int[] halfPowersOf10 = new int[]{3, 31, 316, 3162, 31622, 316227, 3162277, 31622776, 316227766, Integer.MAX_VALUE};
    @VisibleForTesting
    static final int FLOOR_SQRT_MAX_INT = 46340;
    private static final int[] factorials = new int[]{1, 1, 2, 6, 24, 120, 720, 5040, 40320, 362880, 3628800, 39916800, 479001600};
    @VisibleForTesting
    static int[] biggestBinomials = new int[]{Integer.MAX_VALUE, Integer.MAX_VALUE, 65536, 2345, 477, 193, 110, 75, 58, 49, 43, 39, 37, 35, 34, 34, 33};

    public static boolean isPowerOfTwo(int x) {
        return x > 0 & (x & x - 1) == 0;
    }

    @VisibleForTesting
    static int lessThanBranchFree(int x, int y) {
        return ~(~(x - y)) >>> 31;
    }

    public static int log2(int x, RoundingMode mode) {
        MathPreconditions.checkPositive((String)"x", (int)x);
        switch (1.$SwitchMap$java$math$RoundingMode[mode.ordinal()]) {
            case 1: {
                MathPreconditions.checkRoundingUnnecessary((boolean)IntMath.isPowerOfTwo((int)x));
            }
            case 2: 
            case 3: {
                return 31 - Integer.numberOfLeadingZeros(x);
            }
            case 4: 
            case 5: {
                return 32 - Integer.numberOfLeadingZeros(x - 1);
            }
            case 6: 
            case 7: 
            case 8: {
                int leadingZeros = Integer.numberOfLeadingZeros(x);
                int cmp = -1257966797 >>> leadingZeros;
                int logFloor = 31 - leadingZeros;
                return logFloor + IntMath.lessThanBranchFree((int)cmp, (int)x);
            }
        }
        throw new AssertionError();
    }

    @GwtIncompatible(value="need BigIntegerMath to adequately test")
    public static int log10(int x, RoundingMode mode) {
        MathPreconditions.checkPositive((String)"x", (int)x);
        int logFloor = IntMath.log10Floor((int)x);
        int floorPow = powersOf10[logFloor];
        switch (1.$SwitchMap$java$math$RoundingMode[mode.ordinal()]) {
            case 1: {
                MathPreconditions.checkRoundingUnnecessary((x == floorPow ? 1 : 0) != 0);
            }
            case 2: 
            case 3: {
                return logFloor;
            }
            case 4: 
            case 5: {
                return logFloor + IntMath.lessThanBranchFree((int)floorPow, (int)x);
            }
            case 6: 
            case 7: 
            case 8: {
                return logFloor + IntMath.lessThanBranchFree((int)halfPowersOf10[logFloor], (int)x);
            }
        }
        throw new AssertionError();
    }

    private static int log10Floor(int x) {
        byte y = maxLog10ForLeadingZeros[Integer.numberOfLeadingZeros(x)];
        return y - IntMath.lessThanBranchFree((int)x, (int)powersOf10[y]);
    }

    @GwtIncompatible(value="failing tests")
    public static int pow(int b2, int k2) {
        MathPreconditions.checkNonNegative((String)"exponent", (int)k2);
        switch (b2) {
            case 0: {
                return k2 == 0 ? 1 : 0;
            }
            case 1: {
                return 1;
            }
            case -1: {
                return (k2 & 1) == 0 ? 1 : -1;
            }
            case 2: {
                return k2 < 32 ? 1 << k2 : 0;
            }
            case -2: {
                if (k2 < 32) {
                    return (k2 & 1) == 0 ? 1 << k2 : -(1 << k2);
                }
                return 0;
            }
        }
        int accum = 1;
        while (true) {
            switch (k2) {
                case 0: {
                    return accum;
                }
                case 1: {
                    return b2 * accum;
                }
            }
            accum *= (k2 & 1) == 0 ? 1 : b2;
            b2 *= b2;
            k2 >>= 1;
        }
    }

    @GwtIncompatible(value="need BigIntegerMath to adequately test")
    public static int sqrt(int x, RoundingMode mode) {
        MathPreconditions.checkNonNegative((String)"x", (int)x);
        int sqrtFloor = IntMath.sqrtFloor((int)x);
        switch (1.$SwitchMap$java$math$RoundingMode[mode.ordinal()]) {
            case 1: {
                MathPreconditions.checkRoundingUnnecessary((sqrtFloor * sqrtFloor == x ? 1 : 0) != 0);
            }
            case 2: 
            case 3: {
                return sqrtFloor;
            }
            case 4: 
            case 5: {
                return sqrtFloor + IntMath.lessThanBranchFree((int)(sqrtFloor * sqrtFloor), (int)x);
            }
            case 6: 
            case 7: 
            case 8: {
                int halfSquare = sqrtFloor * sqrtFloor + sqrtFloor;
                return sqrtFloor + IntMath.lessThanBranchFree((int)halfSquare, (int)x);
            }
        }
        throw new AssertionError();
    }

    private static int sqrtFloor(int x) {
        return (int)Math.sqrt(x);
    }

    public static int divide(int p, int q, RoundingMode mode) {
        boolean increment;
        Preconditions.checkNotNull((Object)((Object)mode));
        if (q == 0) {
            throw new ArithmeticException("/ by zero");
        }
        int div = p / q;
        int rem = p - q * div;
        if (rem == 0) {
            return div;
        }
        int signum = 1 | (p ^ q) >> 31;
        switch (1.$SwitchMap$java$math$RoundingMode[mode.ordinal()]) {
            case 1: {
                MathPreconditions.checkRoundingUnnecessary((rem == 0 ? 1 : 0) != 0);
            }
            case 2: {
                increment = false;
                break;
            }
            case 4: {
                increment = true;
                break;
            }
            case 5: {
                increment = signum > 0;
                break;
            }
            case 3: {
                increment = signum < 0;
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                int absRem = Math.abs(rem);
                int cmpRemToHalfDivisor = absRem - (Math.abs(q) - absRem);
                if (cmpRemToHalfDivisor == 0) {
                    increment = mode == RoundingMode.HALF_UP || mode == RoundingMode.HALF_EVEN & (div & 1) != 0;
                    break;
                }
                increment = cmpRemToHalfDivisor > 0;
                break;
            }
            default: {
                throw new AssertionError();
            }
        }
        return increment ? div + signum : div;
    }

    public static int mod(int x, int m) {
        if (m <= 0) {
            throw new ArithmeticException("Modulus " + m + " must be > 0");
        }
        int result = x % m;
        return result >= 0 ? result : result + m;
    }

    public static int gcd(int a2, int b2) {
        MathPreconditions.checkNonNegative((String)"a", (int)a2);
        MathPreconditions.checkNonNegative((String)"b", (int)b2);
        if (a2 == 0) {
            return b2;
        }
        if (b2 == 0) {
            return a2;
        }
        int aTwos = Integer.numberOfTrailingZeros(a2);
        a2 >>= aTwos;
        int bTwos = Integer.numberOfTrailingZeros(b2);
        b2 >>= bTwos;
        while (a2 != b2) {
            int delta = a2 - b2;
            int minDeltaOrZero = delta & delta >> 31;
            a2 = delta - minDeltaOrZero - minDeltaOrZero;
            b2 += minDeltaOrZero;
            a2 >>= Integer.numberOfTrailingZeros(a2);
        }
        return a2 << Math.min(aTwos, bTwos);
    }

    public static int checkedAdd(int a2, int b2) {
        long result = (long)a2 + (long)b2;
        MathPreconditions.checkNoOverflow((result == (long)((int)result) ? 1 : 0) != 0);
        return (int)result;
    }

    public static int checkedSubtract(int a2, int b2) {
        long result = (long)a2 - (long)b2;
        MathPreconditions.checkNoOverflow((result == (long)((int)result) ? 1 : 0) != 0);
        return (int)result;
    }

    public static int checkedMultiply(int a2, int b2) {
        long result = (long)a2 * (long)b2;
        MathPreconditions.checkNoOverflow((result == (long)((int)result) ? 1 : 0) != 0);
        return (int)result;
    }

    public static int checkedPow(int b2, int k2) {
        MathPreconditions.checkNonNegative((String)"exponent", (int)k2);
        switch (b2) {
            case 0: {
                return k2 == 0 ? 1 : 0;
            }
            case 1: {
                return 1;
            }
            case -1: {
                return (k2 & 1) == 0 ? 1 : -1;
            }
            case 2: {
                MathPreconditions.checkNoOverflow((k2 < 31 ? 1 : 0) != 0);
                return 1 << k2;
            }
            case -2: {
                MathPreconditions.checkNoOverflow((k2 < 32 ? 1 : 0) != 0);
                return (k2 & 1) == 0 ? 1 << k2 : -1 << k2;
            }
        }
        int accum = 1;
        while (true) {
            switch (k2) {
                case 0: {
                    return accum;
                }
                case 1: {
                    return IntMath.checkedMultiply((int)accum, (int)b2);
                }
            }
            if ((k2 & 1) != 0) {
                accum = IntMath.checkedMultiply((int)accum, (int)b2);
            }
            if ((k2 >>= 1) <= 0) continue;
            MathPreconditions.checkNoOverflow((boolean)(-46340 <= b2 & b2 <= 46340));
            b2 *= b2;
        }
    }

    public static int factorial(int n) {
        MathPreconditions.checkNonNegative((String)"n", (int)n);
        return n < factorials.length ? factorials[n] : Integer.MAX_VALUE;
    }

    @GwtIncompatible(value="need BigIntegerMath to adequately test")
    public static int binomial(int n, int k2) {
        MathPreconditions.checkNonNegative((String)"n", (int)n);
        MathPreconditions.checkNonNegative((String)"k", (int)k2);
        Preconditions.checkArgument((k2 <= n ? 1 : 0) != 0, (String)"k (%s) > n (%s)", (Object[])new Object[]{k2, n});
        if (k2 > n >> 1) {
            k2 = n - k2;
        }
        if (k2 >= biggestBinomials.length || n > biggestBinomials[k2]) {
            return Integer.MAX_VALUE;
        }
        switch (k2) {
            case 0: {
                return 1;
            }
            case 1: {
                return n;
            }
        }
        long result = 1L;
        for (int i = 0; i < k2; ++i) {
            result *= (long)(n - i);
            result /= (long)(i + 1);
        }
        return (int)result;
    }

    public static int mean(int x, int y) {
        return (x & y) + ((x ^ y) >> 1);
    }

    private IntMath() {
    }
}

