/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.util.concurrent;

import com.google.common.annotations.Beta;
import com.google.common.util.concurrent.CheckedFuture;
import com.google.common.util.concurrent.ForwardingListenableFuture;
import com.google.common.util.concurrent.ListenableFuture;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

@Beta
public abstract class AbstractCheckedFuture<V, X extends Exception>
extends ForwardingListenableFuture.SimpleForwardingListenableFuture<V>
implements CheckedFuture<V, X> {
    protected AbstractCheckedFuture(ListenableFuture<V> delegate) {
        super(delegate);
    }

    protected abstract X mapException(Exception var1);

    public V checkedGet() throws X {
        try {
            return (V)this.get();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw this.mapException((Exception)e);
        }
        catch (CancellationException e) {
            throw this.mapException((Exception)e);
        }
        catch (ExecutionException e) {
            throw this.mapException((Exception)e);
        }
    }

    public V checkedGet(long timeout, TimeUnit unit) throws TimeoutException, X {
        try {
            return (V)this.get(timeout, unit);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw this.mapException((Exception)e);
        }
        catch (CancellationException e) {
            throw this.mapException((Exception)e);
        }
        catch (ExecutionException e) {
            throw this.mapException((Exception)e);
        }
    }
}

