/*
 * Decompiled with CFR 0.152.
 */
package io.github.crucible;

import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.Loader;
import cpw.mods.fml.common.ModContainer;
import io.github.crucible.CrucibleConfigs;
import io.github.crucible.CrucibleModContainer;
import java.io.File;
import java.lang.ref.WeakReference;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import net.minecraft.server.MinecraftServer;
import net.minecraftforge.cauldron.CauldronHooks;
import net.minecraftforge.common.DimensionManager;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.spigotmc.RestartCommand;

public class CrucibleCommand
extends Command {
    private static final DecimalFormat timeFormat = new DecimalFormat("########0.000");
    private static WeakReference<MinecraftServer> serveReference;

    protected CrucibleCommand(MinecraftServer server) {
        super("crucible");
        serveReference = new WeakReference<MinecraftServer>(server);
        String usage = "&7&m-------------------&7[&bCrucible&7]&m-------------------\n&b  >&e crucible tps &7-&a Show tps statistics.\n&b  >&e crucible restart &7-&a Restart the server.\n&b  >&e crucible info &7-&a Print some information about the server.\n&b  >&e crucible chunks &7-&a Print some information about loaded chunks.\n&b  >&e crucible heap &7-&a Dump the server heap.\n&b  >&e crucible plugins &7-&a Shows all your loaded plugins and mod plugins.\n&b  >&e crucible mods &7-&a Shows all your loaded mods.\n&b  >&e crucible findChunks &7-&a Find and filter *loaded* chunks by their content.";
        this.setUsage(ChatColor.translateAlternateColorCodes('&', usage));
        this.setPermission("crucible");
    }

    public static String generateInfo() {
        String info = "This server is running &3Crucible&r [" + CrucibleModContainer.instance.getVersion() + "] (Thermos fork by CrucibleMC Team).\n&9https://github.com/CrucibleMC/Crucible\n&rBukkit API implemented: 1.7.9-R0.3-SNAPSHOT\nPlugins: " + Bukkit.getPluginManager().getPlugins().length + "\n&rMods: " + Loader.instance().getActiveModList().size() + " &r| Loaded: " + Loader.instance().getModList().size() + "\n&r" + String.format("Java is %s, version %s, running on %s:%s:%s, installed at %s", System.getProperty("java.vm.name"), System.getProperty("java.version"), System.getProperty("os.name"), System.getProperty("os.arch"), System.getProperty("os.version"), System.getProperty("java.home"));
        return ChatColor.translateAlternateColorCodes('&', info);
    }

    private static String getPluginList() {
        Plugin[] plugins;
        StringBuilder pluginList = new StringBuilder();
        for (Plugin plugin : plugins = Bukkit.getPluginManager().getPlugins()) {
            if (pluginList.length() > 0) {
                pluginList.append((Object)ChatColor.WHITE);
                pluginList.append(", ");
            }
            if (CrucibleModContainer.isModPlugin(plugin)) {
                pluginList.append((Object)ChatColor.AQUA);
            } else {
                pluginList.append((Object)(plugin.isEnabled() ? ChatColor.GREEN : ChatColor.RED));
            }
            pluginList.append(plugin.getDescription().getName()).append("@").append(plugin.getDescription().getVersion());
        }
        return "(" + plugins.length + "): " + pluginList;
    }

    private static String getModList() {
        StringBuilder modList = new StringBuilder();
        List<ModContainer> mods = Loader.instance().getModList();
        for (ModContainer mod : mods) {
            if (modList.length() > 0) {
                modList.append((Object)ChatColor.WHITE);
                modList.append(", ");
            }
            modList.append((Object)ChatColor.GREEN).append(mod.getName()).append("@").append(mod.getVersion());
        }
        return "(" + mods.size() + "): " + modList;
    }

    private static String getTps() {
        double[] recentTps;
        StringBuilder tps = new StringBuilder();
        tps.append("\n&8[&e&l\u26a1&r&8] &7TPS from last 1m, 5m, 15m: &r");
        for (double t : recentTps = MinecraftServer.I().recentTps) {
            tps.append(CrucibleCommand.parseTps(t));
        }
        double meanTickTime = (double)CrucibleCommand.mean(CrucibleCommand.getServer().g) * 1.0E-6;
        tps.append("\n&r&8[&e&l\u26a1&r&8]&7 Mean tick time: &l").append(timeFormat.format(meanTickTime)).append("&r&7ms&r\n");
        for (Integer dimId : DimensionManager.getIDs()) {
            double worldTickTime = (double)CrucibleCommand.mean((long[])CrucibleCommand.getServer().worldTickTimes.get(dimId)) * 1.0E-6;
            double worldTPS = Math.min(1000.0 / worldTickTime, (double)CrucibleConfigs.configs.crucible_tickHandler_serverTickRate);
            aqo worldProvider = DimensionManager.getProvider(dimId);
            String name = worldProvider.l();
            if (name.equals("Overworld")) {
                name = worldProvider.b.M().g();
            }
            tps.append("&8(&2&l").append(dimId).append(" &r&7&o\u279c &r&b").append(name).append("&r&8) &7Time: &l").append(timeFormat.format(worldTickTime)).append("&r&7ms TPS: ").append(CrucibleCommand.parseTps(worldTPS)).append("&r\n");
        }
        return ChatColor.translateAlternateColorCodes('&', tps.toString());
    }

    private static String parseTps(double tps) {
        StringBuilder parsedTps = new StringBuilder();
        if (tps <= 10.0) {
            parsedTps.append("&c&l");
        } else if (tps <= 15.0) {
            parsedTps.append("&e&l");
        } else {
            parsedTps.append("&a&l");
        }
        parsedTps.append(String.format("%.2f", Math.min((double)Math.round(tps * 100.0) / 100.0, (double)CrucibleConfigs.configs.crucible_tickHandler_serverTickRate))).append("&r ");
        return parsedTps.toString();
    }

    private static long mean(long[] values) {
        long sum = 0L;
        for (long v : values) {
            sum += v;
        }
        return sum / (long)values.length;
    }

    private static MinecraftServer getServer() {
        return (MinecraftServer)serveReference.get();
    }

    @Override
    public boolean execute(CommandSender sender, String commandLabel, String[] args) {
        if (!this.testPermission(sender)) {
            return true;
        }
        if (args.length == 0) {
            sender.sendMessage((Object)((Object)ChatColor.BLUE) + "[Crucible] " + (Object)((Object)ChatColor.GRAY) + "Please specify action");
            sender.sendMessage(this.usageMessage);
            return true;
        }
        if (args[0].equalsIgnoreCase("tps")) {
            if (!this.testPermission(sender, "crucible.tps")) {
                return true;
            }
            sender.sendMessage(CrucibleCommand.getTps());
        } else if (args[0].equalsIgnoreCase("restart")) {
            if (!this.testPermission(sender, "crucible.restart")) {
                return true;
            }
            RestartCommand.restart(true);
        } else if (args[0].equalsIgnoreCase("info")) {
            if (!this.testPermission(sender, "crucible.info")) {
                return true;
            }
            sender.sendMessage(CrucibleCommand.generateInfo());
        } else if (args[0].equalsIgnoreCase("chunks")) {
            if (!this.testPermission(sender, "crucible.chunks")) {
                return true;
            }
            this.processChunks(sender, args);
        } else if (args[0].equalsIgnoreCase("heap")) {
            if (!this.testPermission(sender, "crucible.heap")) {
                return true;
            }
            this.processHeap(sender, args);
        } else if (args[0].equalsIgnoreCase("mods")) {
            if (!this.testPermission(sender, "crucible.mods")) {
                return true;
            }
            sender.sendMessage("Mods " + CrucibleCommand.getModList());
        } else if (args[0].equalsIgnoreCase("plugins")) {
            if (!this.testPermission(sender, "crucible.plugins")) {
                return true;
            }
            sender.sendMessage("Plugins " + CrucibleCommand.getPluginList());
        } else if (args[0].equalsIgnoreCase("findChunks")) {
            if (!this.testPermission(sender, "crucible.findChunks")) {
                return true;
            }
            this.findChunks(sender, args);
        } else if (args[0].equalsIgnoreCase("")) {
            if (!this.testPermission(sender, "crucible.")) {
                return true;
            }
        } else {
            sender.sendMessage((Object)((Object)ChatColor.RED) + "Unknown subcommand.");
            sender.sendMessage(this.usageMessage);
        }
        return true;
    }

    private void findChunks(CommandSender sender, String[] args) {
        mt world;
        if (args.length >= 2) {
            int id;
            try {
                id = Integer.parseInt(args[1]);
            }
            catch (NumberFormatException e) {
                sender.sendMessage((Object)((Object)ChatColor.BLUE) + "[Crucible] " + (Object)((Object)ChatColor.DARK_RED) + "World ID is not a valid number!");
                return;
            }
            world = DimensionManager.getWorld(id);
            if (world == null) {
                sender.sendMessage((Object)((Object)ChatColor.BLUE) + "[Crucible] " + (Object)((Object)ChatColor.DARK_RED) + "World not found!");
                return;
            }
        } else {
            world = sender instanceof Player ? ((Player)sender).getWorld().getWorldServer() : FMLCommonHandler.instance().getMinecraftServerInstance().c[0];
        }
        ArrayList<apx> chunks = new ArrayList<apx>(world.b.loadedChunkHashMap_KC.rawVanilla().values());
        chunks.sort(Collections.reverseOrder(Comparator.comparingInt(c -> c.i.size())));
        for (int i = 0; i < Math.min(chunks.size(), 20); ++i) {
            apx chunk = (apx)chunks.get(i);
            sender.sendMessage(String.format(ChatColor.translateAlternateColorCodes('&', "&7[&e%s&7, &e%s&7] &r Tile Entities:%s"), chunk.g << 4, chunk.h << 4, chunk.i.size()));
        }
    }

    public boolean testPermission(CommandSender target, String permission) {
        if (this.testPermissionSilent(target, permission)) {
            return true;
        }
        target.sendMessage((Object)((Object)ChatColor.BLUE) + "[Crucible] " + (Object)((Object)ChatColor.DARK_RED) + "I'm sorry, but you do not have permission to perform this command. Please contact the server administrators if you believe that this is an error.");
        return false;
    }

    public boolean testPermissionSilent(CommandSender target, String permission) {
        if (!super.testPermissionSilent(target)) {
            return false;
        }
        for (String p : permission.split(";")) {
            if (!target.hasPermission(p)) continue;
            return true;
        }
        return false;
    }

    private void processHeap(CommandSender sender, String[] args) {
        File file = new File(new File(new File("."), "dumps"), "heap-dump-" + new SimpleDateFormat("yyyy-MM-dd_HH.mm.ss").format(new Date()) + "-server.hprof");
        sender.sendMessage("Writing heap dump to: " + file);
        CauldronHooks.dumpHeap(file, true);
        sender.sendMessage("Heap dump complete.");
    }

    private void processChunks(CommandSender sender, String[] args) {
        sender.sendMessage((Object)((Object)ChatColor.GOLD) + "Dimension stats: ");
        for (mt world : MinecraftServer.I().worlds) {
            sender.sendMessage((Object)((Object)ChatColor.GOLD) + "Dimension: " + (Object)((Object)ChatColor.GRAY) + world.t.i + (Object)((Object)ChatColor.GOLD) + " Loaded Chunks: " + (Object)((Object)ChatColor.GRAY) + world.b.loadedChunkHashMap_KC.size() + (Object)((Object)ChatColor.GOLD) + " Active Chunks: " + (Object)((Object)ChatColor.GRAY) + world.F.size() + (Object)((Object)ChatColor.GOLD) + " Entities: " + (Object)((Object)ChatColor.GRAY) + world.e.size() + (Object)((Object)ChatColor.GOLD) + " Tile Entities: " + (Object)((Object)ChatColor.GRAY) + world.g.size());
            sender.sendMessage((Object)((Object)ChatColor.GOLD) + " Entities Last Tick: " + (Object)((Object)ChatColor.GRAY) + world.entitiesTicked + (Object)((Object)ChatColor.GOLD) + " Tiles Last Tick: " + (Object)((Object)ChatColor.GRAY) + world.tilesTicked + (Object)((Object)ChatColor.GOLD) + " Removed Entities: " + (Object)((Object)ChatColor.GRAY) + world.f.size() + (Object)((Object)ChatColor.GOLD) + " Removed Tile Entities: " + (Object)((Object)ChatColor.GRAY) + world.b.size());
        }
        if (args.length < 2 || !"dump".equalsIgnoreCase(args[1])) {
            return;
        }
        boolean dumpAll = args.length > 2 && "all".equalsIgnoreCase(args[2]);
        File file = new File(new File(new File("."), "chunk-dumps"), "chunk-info-" + new SimpleDateFormat("yyyy-MM-dd_HH.mm.ss").format(new Date()) + "-server.txt");
        sender.sendMessage("Writing chunk info to: " + file);
        CauldronHooks.writeChunks(file, dumpAll);
        sender.sendMessage("Chunk info complete");
    }
}

