/*
 * Decompiled with CFR 0.152.
 */
package io.github.crucible;

import co.aikar.timings.Timings;
import co.aikar.timings.TimingsManager;
import com.avaje.ebean.EbeanServer;
import com.google.common.collect.ImmutableList;
import com.google.common.eventbus.EventBus;
import com.google.common.eventbus.Subscribe;
import cpw.mods.fml.common.DummyModContainer;
import cpw.mods.fml.common.LoadController;
import cpw.mods.fml.common.Loader;
import cpw.mods.fml.common.ModMetadata;
import cpw.mods.fml.common.event.FMLConstructionEvent;
import cpw.mods.fml.common.event.FMLLoadCompleteEvent;
import cpw.mods.fml.common.event.FMLPostInitializationEvent;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import cpw.mods.fml.common.event.FMLServerStartingEvent;
import cpw.mods.fml.common.network.NetworkRegistry;
import io.github.crucible.CrucibleCommand;
import io.github.crucible.CrucibleConfigs;
import io.github.crucible.Metrics;
import io.github.crucible.api.CrucibleAPI;
import io.github.crucible.bootstrap.CrucibleMetadata;
import java.io.File;
import java.io.InputStream;
import java.lang.management.ManagementFactory;
import java.lang.management.ThreadMXBean;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import net.minecraft.server.MinecraftServer;
import org.apache.logging.log4j.LogManager;
import org.bukkit.Bukkit;
import org.bukkit.Server;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.event.Event;
import org.bukkit.event.Listener;
import org.bukkit.generator.ChunkGenerator;
import org.bukkit.plugin.InvalidDescriptionException;
import org.bukkit.plugin.InvalidPluginException;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.PluginDescriptionFile;
import org.bukkit.plugin.PluginLoader;
import org.bukkit.plugin.PluginLogger;
import org.bukkit.plugin.RegisteredListener;
import org.bukkit.plugin.UnknownDependencyException;

public class CrucibleModContainer
extends DummyModContainer
implements Plugin {
    public static final org.apache.logging.log4j.Logger logger = LogManager.getLogger((String)"Crucible");
    public static CrucibleModContainer instance;
    public static Metrics metrics;
    private PluginLoader dummyPluginLoader;
    private PluginDescriptionFile dummyPluginDescription;
    private boolean isPluginEnabled = false;
    private Logger pluginLogger;

    public CrucibleModContainer() {
        super(new ModMetadata());
        ModMetadata meta = this.getMetadata();
        meta.modId = "Crucible";
        meta.name = "Crucible Server";
        meta.version = CrucibleMetadata.CRUCIBLE_VERSION;
        meta.credits = "TODO: Add credits";
        meta.authorList = Arrays.asList("juanmuscaria", "brunoxkk0", "evernife");
        meta.description = "Pure black magic and gambiarras!";
        meta.url = "https://github.com/CrucibleMC/Crucible";
        instance = this;
    }

    @Override
    public boolean registerBus(EventBus bus, LoadController controller) {
        bus.register((Object)this);
        return true;
    }

    @Subscribe
    public void modConstruction(FMLConstructionEvent evt) {
        NetworkRegistry.INSTANCE.register(this, this.getClass(), "*", evt.getASMHarvestedData());
        logger.info("Crucible DummyMod injected successfully!");
        CrucibleModContainer.configureTimings();
    }

    @Subscribe
    public void preInit(FMLPreInitializationEvent evt) {
    }

    @Subscribe
    public void postInit(FMLPostInitializationEvent evt) {
    }

    @Subscribe
    public void onAvailable(FMLLoadCompleteEvent evt) {
    }

    @Subscribe
    public void serverStarting(FMLServerStartingEvent evt) {
        evt.registerServerCommand("crucible", new CrucibleCommand(evt.getServer()));
        CrucibleAPI.registerModPlugin(this);
        metrics = new Metrics(this, 6555);
    }

    @Override
    public List<String> getOwnedPackages() {
        return ImmutableList.of((Object)"io.github.crucible.api", (Object)"io.github.crucible.bootstrap", (Object)"io.github.crucible.entity", (Object)"io.github.crucible.event", (Object)"io.github.crucible.nbt", (Object)"io.github.crucible.patches", (Object)"io.github.crucible.util", (Object)"io.github.crucible.wrapper", (Object)"io.github.crucible");
    }

    @Override
    public File getDataFolder() {
        return new File((File)MinecraftServer.options.valueOf("plugins"), "forge");
    }

    @Override
    public PluginDescriptionFile getDescription() {
        if (this.dummyPluginDescription == null) {
            this.dummyPluginDescription = new PluginDescriptionFile(instance.getName(), instance.getVersion(), CrucibleModContainer.class.getName());
        }
        return this.dummyPluginDescription;
    }

    @Override
    public FileConfiguration getConfig() {
        return null;
    }

    @Override
    public InputStream getResource(String filename) {
        return null;
    }

    @Override
    public void saveConfig() {
    }

    @Override
    public void saveDefaultConfig() {
    }

    @Override
    public void saveResource(String resourcePath, boolean replace) {
    }

    @Override
    public void reloadConfig() {
    }

    @Override
    public PluginLoader getPluginLoader() {
        if (this.dummyPluginLoader == null) {
            this.dummyPluginLoader = new PluginLoader(){

                @Override
                public Plugin loadPlugin(File file) throws InvalidPluginException, UnknownDependencyException {
                    try {
                        return CrucibleModContainer.this.getServer().getPluginManager().loadPlugin(file);
                    }
                    catch (InvalidDescriptionException e) {
                        e.printStackTrace();
                        return null;
                    }
                }

                @Override
                public PluginDescriptionFile getPluginDescription(File file) {
                    if (CrucibleModContainer.this.dummyPluginDescription == null) {
                        CrucibleModContainer.this.dummyPluginDescription = new PluginDescriptionFile(instance.getName(), instance.getVersion(), CrucibleModContainer.class.getName());
                    }
                    return CrucibleModContainer.this.dummyPluginDescription;
                }

                @Override
                public Pattern[] getPluginFileFilters() {
                    return new Pattern[0];
                }

                @Override
                public Map<Class<? extends Event>, Set<RegisteredListener>> createRegisteredListeners(Listener listener, Plugin plugin) {
                    return null;
                }

                @Override
                public void enablePlugin(Plugin plugin) {
                    CrucibleModContainer.this.isPluginEnabled = true;
                }

                @Override
                public void disablePlugin(Plugin plugin) {
                    if (!MinecraftServer.I().q()) {
                        CrucibleModContainer.this.isPluginEnabled = false;
                    }
                }
            };
        }
        return this.dummyPluginLoader;
    }

    @Override
    public Server getServer() {
        return Bukkit.getServer();
    }

    @Override
    public boolean isEnabled() {
        return this.isPluginEnabled;
    }

    @Override
    public void onDisable() {
    }

    @Override
    public void onLoad() {
        this.getLogger().info("Crucible DummyPlugin injected successfully!");
    }

    @Override
    public void onEnable() {
    }

    @Override
    public boolean isNaggable() {
        return false;
    }

    @Override
    public void setNaggable(boolean canNag) {
    }

    @Override
    public EbeanServer getDatabase() {
        return null;
    }

    @Override
    public ChunkGenerator getDefaultWorldGenerator(String worldName, String id) {
        return null;
    }

    @Override
    public Logger getLogger() {
        if (this.pluginLogger == null) {
            this.pluginLogger = new PluginLogger(this);
        }
        return this.pluginLogger;
    }

    @Override
    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        return false;
    }

    @Override
    public List<String> onTabComplete(CommandSender sender, Command command, String alias, String[] args) {
        return Collections.emptyList();
    }

    public static boolean isModPlugin(Plugin plugin) {
        return plugin.getClass().getClassLoader().equals(Loader.instance().getModClassLoader()) || plugin.getClass().getClassLoader().equals(CrucibleModContainer.class.getClassLoader());
    }

    public static void configureTimings() {
        TimingsManager.privacy = CrucibleConfigs.configs.timings_serverNamePrivacy;
        TimingsManager.hiddenConfigs = CrucibleConfigs.configs.timings_hiddenConfigEntries;
        Timings.setVerboseTimingsEnabled(CrucibleConfigs.configs.timings_verbose);
        Timings.setHistoryInterval(CrucibleConfigs.configs.timings_historyInterval * 20);
        Timings.setHistoryLength(CrucibleConfigs.configs.timings_historyLength * 20);
        Timings.setTimingsEnabled(CrucibleConfigs.configs.timings_enabledSinceServerStartup);
    }

    public static void reapplyConfigs() {
        for (mt world : MinecraftServer.I().worlds) {
            world.b.a = CrucibleConfigs.configs.cauldron_settings_loadChunkOnRequest;
        }
        ThreadMXBean mbean = ManagementFactory.getThreadMXBean();
        if (mbean.isThreadContentionMonitoringSupported()) {
            mbean.setThreadContentionMonitoringEnabled(CrucibleConfigs.configs.cauldron_debug_enableThreadContentionMonitoring);
        } else {
            logger.warn("Thread monitoring is not supported!");
        }
    }
}

