/*
 * Decompiled with CFR 0.152.
 */
package io.github.crucible.nbt;

import io.github.crucible.nbt.Crucible_NBTException;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import org.apache.commons.lang.ArrayUtils;

public class Crucible_JsonToNBT {
    private static final Pattern DOUBLE_PATTERN_NOSUFFIX = Pattern.compile("[-+]?(?:[0-9]+[.]|[0-9]*[.][0-9]+)(?:e[-+]?[0-9]+)?", 2);
    private static final Pattern DOUBLE_PATTERN = Pattern.compile("[-+]?(?:[0-9]+[.]?|[0-9]*[.][0-9]+)(?:e[-+]?[0-9]+)?d", 2);
    private static final Pattern FLOAT_PATTERN = Pattern.compile("[-+]?(?:[0-9]+[.]?|[0-9]*[.][0-9]+)(?:e[-+]?[0-9]+)?f", 2);
    private static final Pattern BYTE_PATTERN = Pattern.compile("[-+]?(?:0|[1-9][0-9]*)b", 2);
    private static final Pattern LONG_PATTERN = Pattern.compile("[-+]?(?:0|[1-9][0-9]*)l", 2);
    private static final Pattern SHORT_PATTERN = Pattern.compile("[-+]?(?:0|[1-9][0-9]*)s", 2);
    private static final Pattern INT_PATTERN = Pattern.compile("[-+]?(?:0|[1-9][0-9]*)");
    private final String string;
    private int cursor;

    public static dh getTagFromJson(String jsonString) throws ea {
        return new Crucible_JsonToNBT(jsonString).readSingleStruct();
    }

    dh readSingleStruct() throws ea {
        dh nbttagcompound = this.readStruct();
        this.skipWhitespace();
        if (this.canRead()) {
            ++this.cursor;
            throw this.exception("Trailing data found");
        }
        return nbttagcompound;
    }

    Crucible_JsonToNBT(String stringIn) {
        this.string = stringIn;
    }

    protected String readKey() throws ea {
        this.skipWhitespace();
        if (!this.canRead()) {
            throw this.exception("Expected key");
        }
        return this.peek() == '\"' ? this.readQuotedString() : this.readString();
    }

    private ea exception(String message) {
        return new Crucible_NBTException(message, this.string, this.cursor);
    }

    protected dy readTypedValue() throws ea {
        this.skipWhitespace();
        if (this.peek() == '\"') {
            return new dx(this.readQuotedString());
        }
        String type = this.readString();
        if (type.isEmpty()) {
            throw this.exception("Expected value");
        }
        return this.type(type);
    }

    private dy type(String stringIn) {
        try {
            if (FLOAT_PATTERN.matcher(stringIn).matches()) {
                return new dm(Float.parseFloat(stringIn.substring(0, stringIn.length() - 1)));
            }
            if (BYTE_PATTERN.matcher(stringIn).matches()) {
                return new dg(Byte.parseByte(stringIn.substring(0, stringIn.length() - 1)));
            }
            if (LONG_PATTERN.matcher(stringIn).matches()) {
                return new dr(Long.parseLong(stringIn.substring(0, stringIn.length() - 1)));
            }
            if (SHORT_PATTERN.matcher(stringIn).matches()) {
                return new dw(Short.parseShort(stringIn.substring(0, stringIn.length() - 1)));
            }
            if (INT_PATTERN.matcher(stringIn).matches()) {
                return new dp(Integer.parseInt(stringIn));
            }
            if (DOUBLE_PATTERN.matcher(stringIn).matches()) {
                return new dk(Double.parseDouble(stringIn.substring(0, stringIn.length() - 1)));
            }
            if (DOUBLE_PATTERN_NOSUFFIX.matcher(stringIn).matches()) {
                return new dk(Double.parseDouble(stringIn));
            }
            if ("true".equalsIgnoreCase(stringIn)) {
                return new dg(1);
            }
            if ("false".equalsIgnoreCase(stringIn)) {
                return new dg(0);
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return new dx(stringIn);
    }

    private String readQuotedString() throws ea {
        int i = ++this.cursor;
        StringBuilder sb = null;
        boolean flag = false;
        while (this.canRead()) {
            char currentChar = this.pop();
            if (flag) {
                if (currentChar != '\\' && currentChar != '\"') {
                    throw this.exception("Invalid escape of '" + currentChar + "'");
                }
                flag = false;
            } else {
                if (currentChar == '\\') {
                    flag = true;
                    if (sb != null) continue;
                    sb = new StringBuilder(this.string.substring(i, this.cursor - 1));
                    continue;
                }
                if (currentChar == '\"') {
                    return sb == null ? this.string.substring(i, this.cursor - 1) : sb.toString();
                }
            }
            if (sb == null) continue;
            sb.append(currentChar);
        }
        throw this.exception("Missing termination quote");
    }

    private String readString() {
        int lastPos = this.cursor;
        while (this.canRead() && this.isAllowedInKey(this.peek())) {
            ++this.cursor;
        }
        return this.string.substring(lastPos, this.cursor);
    }

    protected dy readValue() throws ea {
        this.skipWhitespace();
        if (!this.canRead()) {
            throw this.exception("Expected value");
        }
        char c0 = this.peek();
        if (c0 == '{') {
            return this.readStruct();
        }
        return c0 == '[' ? this.readList() : this.readTypedValue();
    }

    protected dy readList() throws ea {
        return this.canRead(2) && this.peek(1) != '\"' && this.peek(2) == ';' ? this.readArrayTag() : this.readListTag();
    }

    protected dh readStruct() throws ea {
        this.expect('{');
        dh tag = new dh();
        this.skipWhitespace();
        while (this.canRead() && this.peek() != '}') {
            String key = this.readKey();
            if (key.isEmpty()) {
                throw this.exception("Expected non-empty key");
            }
            this.expect(':');
            tag.a(key, this.readValue());
            if (!this.hasElementSeparator()) break;
            if (this.canRead()) continue;
            throw this.exception("Expected key");
        }
        this.expect('}');
        return tag;
    }

    private dy readListTag() throws ea {
        this.expect('[');
        this.skipWhitespace();
        if (!this.canRead()) {
            throw this.exception("Expected value");
        }
        dq list = new dq();
        byte i = -1;
        while (this.peek() != ']') {
            dy tag = this.readValue();
            byte id = tag.a();
            if (i < 0) {
                i = id;
            } else if (id != i) {
                throw this.exception("Unable to insert " + dy.a[id] + " into ListTag of type " + dy.a[i]);
            }
            list.a(tag);
            if (!this.hasElementSeparator()) break;
            if (this.canRead()) continue;
            throw this.exception("Expected value");
        }
        this.expect(']');
        return list;
    }

    private dy readArrayTag() throws ea {
        this.expect('[');
        char currentChar = this.pop();
        this.pop();
        this.skipWhitespace();
        if (!this.canRead()) {
            throw this.exception("Expected value");
        }
        if (currentChar == 'B') {
            return new df(ArrayUtils.toPrimitive((Byte[])this.readArray((byte)7, (byte)1).toArray(new Byte[0])));
        }
        if (currentChar == 'L') {
            return new dn(ArrayUtils.toPrimitive((Integer[])this.readArray((byte)11, (byte)3).toArray(new Integer[0])));
        }
        if (currentChar == 'I') {
            return new dn(ArrayUtils.toPrimitive((Integer[])this.readArray((byte)11, (byte)3).toArray(new Integer[0])));
        }
        throw this.exception("Invalid array type '" + currentChar + "' found");
    }

    private <T extends Number> List<T> readArray(byte typeId, byte primitiveType) throws ea {
        ArrayList<Number> list = new ArrayList<Number>();
        while (this.peek() != ']') {
            dy tag = this.readValue();
            byte i = tag.a();
            if (i != primitiveType) {
                throw this.exception("Unable to insert " + dy.a[i] + " into " + dy.a[typeId]);
            }
            if (primitiveType == 1) {
                list.add(((dz)tag).f());
            } else if (primitiveType == 4) {
                list.add(((dz)tag).c());
            } else {
                list.add(((dz)tag).d());
            }
            if (!this.hasElementSeparator()) break;
            if (this.canRead()) continue;
            throw this.exception("Expected value");
        }
        this.expect(']');
        return list;
    }

    private void skipWhitespace() {
        while (this.canRead() && Character.isWhitespace(this.peek())) {
            ++this.cursor;
        }
    }

    private boolean hasElementSeparator() {
        this.skipWhitespace();
        if (this.canRead() && this.peek() == ',') {
            ++this.cursor;
            this.skipWhitespace();
            return true;
        }
        return false;
    }

    private void expect(char expected) throws ea {
        this.skipWhitespace();
        boolean flag = this.canRead();
        if (flag && this.peek() == expected) {
            ++this.cursor;
        } else {
            throw new Crucible_NBTException("Expected '" + expected + "' but got '" + (flag ? Character.valueOf(this.peek()) : "<EOF>") + "'", this.string, this.cursor + 1);
        }
    }

    protected boolean isAllowedInKey(char charIn) {
        return charIn >= '0' && charIn <= '9' || charIn >= 'A' && charIn <= 'Z' || charIn >= 'a' && charIn <= 'z' || charIn == '_' || charIn == '-' || charIn == '.' || charIn == '+';
    }

    private boolean canRead(int index) {
        return this.cursor + index < this.string.length();
    }

    boolean canRead() {
        return this.canRead(0);
    }

    private char peek(int index) {
        return this.string.charAt(this.cursor + index);
    }

    private char peek() {
        return this.peek(0);
    }

    private char pop() {
        return this.string.charAt(this.cursor++);
    }
}

