/*
 * Decompiled with CFR 0.152.
 */
package io.github.crucible.util;

import io.github.crucible.CrucibleConfigs;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.Marker;
import org.apache.logging.log4j.MarkerManager;
import org.apache.logging.log4j.ThreadContext;
import org.bukkit.Bukkit;
import org.bukkit.craftbukkit.v1_7_R4.command.ColouredConsoleSender;
import org.bukkit.plugin.PluginLoader;
import org.bukkit.plugin.SimplePluginManager;
import org.bukkit.plugin.java.JavaPlugin;
import org.bukkit.plugin.java.JavaPluginLoader;
import org.bukkit.plugin.java.PluginClassLoader;

public class CrucibleTracingLoggerOutputStream
extends ByteArrayOutputStream {
    private static final int BASE_DEPTH = 11;
    private final String separator = System.getProperty("line.separator");
    private final Logger logger;
    private final Level level;
    private final Marker outMaker;

    public CrucibleTracingLoggerOutputStream(Logger logger, Level level) {
        this.logger = logger;
        this.level = level;
        this.outMaker = MarkerManager.getMarker((String)logger.getName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void flush() throws IOException {
        CrucibleTracingLoggerOutputStream crucibleTracingLoggerOutputStream = this;
        synchronized (crucibleTracingLoggerOutputStream) {
            super.flush();
            String record = this.toString();
            super.reset();
            if (record.length() > 0 && !record.equals(this.separator)) {
                if (CrucibleConfigs.configs.crucible_logging_logStdOutCaller) {
                    LogManager.getLogger((String)this.getPrefix()).log(this.level, this.outMaker, record);
                } else {
                    this.logger.log(this.level, this.outMaker, record);
                }
            }
            ThreadContext.remove((String)"crucible-className");
            ThreadContext.remove((String)"crucible-methodName");
            ThreadContext.remove((String)"crucible-lineNumer");
        }
    }

    private String getPrefix() {
        String plugin;
        StackTraceElement[] elems = Thread.currentThread().getStackTrace();
        if (elems.length == 0) {
            return this.logger.getName();
        }
        StackTraceElement elem = elems[11];
        if (elem.getClassName().startsWith("kotlin.io.")) {
            elem = elems[13];
        } else if (elem.getClassName().equals(ColouredConsoleSender.class.getCanonicalName()) && (plugin = this.figureOutPluginPrefix((elem = elems[12]).getClassName())) != null) {
            ThreadContext.put((String)"crucible-className", (String)elem.getClassName());
            ThreadContext.put((String)"crucible-methodName", (String)elem.getMethodName());
            ThreadContext.put((String)"crucible-lineNumer", (String)Integer.toString(elem.getLineNumber()));
            return plugin;
        }
        ThreadContext.put((String)"crucible-className", (String)elem.getClassName());
        ThreadContext.put((String)"crucible-methodName", (String)elem.getMethodName());
        ThreadContext.put((String)"crucible-lineNumer", (String)Integer.toString(elem.getLineNumber()));
        return elem.getClassName();
    }

    private String figureOutPluginPrefix(String clazzName) {
        for (PluginLoader loader : ((SimplePluginManager)Bukkit.getPluginManager()).getLoaders()) {
            JavaPluginLoader jLoader;
            Class<?> clazz;
            if (!(loader instanceof JavaPluginLoader) || (clazz = (jLoader = (JavaPluginLoader)loader).getClassByName(clazzName)) == null || !(clazz.getClassLoader() instanceof PluginClassLoader)) continue;
            JavaPlugin plugin = ((PluginClassLoader)clazz.getClassLoader()).getPlugin();
            String prefix = plugin.getDescription().getPrefix();
            return prefix != null ? prefix : plugin.getDescription().getName();
        }
        return null;
    }
}

