/*
 * Decompiled with CFR 0.152.
 */
package io.github.crucible.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Set;

public class HashedArrayList<TileEntity>
extends ArrayList<TileEntity> {
    private final Set<TileEntity> hashed = Collections.synchronizedSet(new LinkedHashSet());

    @Override
    public boolean add(TileEntity arg0) {
        boolean flag = this.hashed.add(arg0);
        if (flag) {
            super.add(arg0);
        }
        return flag;
    }

    @Override
    public void add(int arg0, TileEntity arg1) {
        boolean flag = this.hashed.add(arg1);
        if (flag) {
            super.add(arg0, arg1);
        }
    }

    @Override
    public boolean addAll(Collection arg0) {
        boolean flag = this.hashed.addAll(arg0);
        if (flag) {
            super.addAll(arg0);
        }
        return flag;
    }

    @Override
    public boolean addAll(int arg0, Collection arg1) {
        boolean flag = this.hashed.addAll(arg1);
        if (flag) {
            super.addAll(arg0, arg1);
        }
        return flag;
    }

    @Override
    public void clear() {
        this.hashed.clear();
        super.clear();
    }

    @Override
    public boolean contains(Object arg0) {
        return this.hashed.contains(arg0);
    }

    @Override
    public boolean containsAll(Collection arg0) {
        return this.hashed.containsAll(arg0);
    }

    @Override
    public TileEntity get(int arg0) {
        return (TileEntity)super.get(arg0);
    }

    @Override
    public int indexOf(Object arg0) {
        return super.indexOf(arg0);
    }

    @Override
    public boolean isEmpty() {
        return super.isEmpty();
    }

    @Override
    public Iterator<TileEntity> iterator() {
        return new HashedArrayIterator<TileEntity>(super.iterator(), this.hashed);
    }

    @Override
    public int lastIndexOf(Object arg0) {
        if (this.hashed.contains(arg0)) {
            return super.lastIndexOf(arg0);
        }
        return -1;
    }

    @Override
    public ListIterator listIterator() {
        return this.listIterator();
    }

    @Override
    public ListIterator listIterator(int arg0) {
        return super.listIterator(arg0);
    }

    @Override
    public boolean remove(Object arg0) {
        boolean flag = this.hashed.remove(arg0);
        if (flag) {
            super.remove(arg0);
        }
        return flag;
    }

    @Override
    public TileEntity remove(int arg0) {
        Object te2 = super.remove(arg0);
        if (te2 != null) {
            this.hashed.remove(te2);
        }
        return (TileEntity)te2;
    }

    @Override
    public boolean removeAll(Collection arg0) {
        boolean flag = this.hashed.removeAll(arg0);
        if (flag) {
            super.clear();
            super.addAll(this.hashed);
        }
        return flag;
    }

    @Override
    public boolean retainAll(Collection arg0) {
        boolean flag = this.hashed.retainAll(arg0);
        if (flag) {
            super.retainAll(arg0);
        }
        return flag;
    }

    @Override
    public TileEntity set(int arg0, TileEntity arg1) {
        TileEntity te2 = super.set(arg0, arg1);
        if (te2 != null) {
            this.hashed.remove(arg1);
        }
        return te2;
    }

    @Override
    public int size() {
        return super.size();
    }

    @Override
    public List<TileEntity> subList(int arg0, int arg1) {
        return super.subList(arg0, arg1);
    }

    @Override
    public Object[] toArray() {
        return super.toArray();
    }

    @Override
    public Object[] toArray(Object[] arg0) {
        return super.toArray(arg0);
    }

    class HashedArrayListIterator<TileEntity>
    implements ListIterator<TileEntity> {
        ListIterator<TileEntity> aritr;
        HashSet<TileEntity> teset;
        private TileEntity lastRet = null;

        public HashedArrayListIterator(ListIterator<TileEntity> aritr, HashSet<TileEntity> teset) {
            this.aritr = aritr;
        }

        @Override
        public void add(TileEntity arg0) {
            boolean flag = this.teset.add(arg0);
            if (flag) {
                this.aritr.add(arg0);
            }
        }

        @Override
        public boolean hasNext() {
            return this.aritr.hasNext();
        }

        @Override
        public boolean hasPrevious() {
            return this.aritr.hasPrevious();
        }

        @Override
        public TileEntity next() {
            this.lastRet = this.aritr.next();
            return this.lastRet;
        }

        @Override
        public int nextIndex() {
            return this.aritr.nextIndex();
        }

        @Override
        public TileEntity previous() {
            this.lastRet = this.aritr.previous();
            return this.lastRet;
        }

        @Override
        public int previousIndex() {
            return this.aritr.previousIndex();
        }

        @Override
        public void remove() {
            this.aritr.remove();
            this.teset.remove(this.lastRet);
        }

        @Override
        public void set(TileEntity arg0) {
            this.aritr.set(arg0);
            this.teset.remove(this.lastRet);
            this.teset.add(arg0);
        }
    }

    class HashedArrayIterator<TileEntity>
    implements Iterator<TileEntity> {
        Iterator<TileEntity> aritr;
        Set<TileEntity> teset;
        private TileEntity last = null;

        public HashedArrayIterator(Iterator aritr, Set<TileEntity> teset) {
            this.aritr = aritr;
            this.teset = teset;
        }

        @Override
        public boolean hasNext() {
            return this.aritr.hasNext();
        }

        @Override
        public TileEntity next() {
            this.last = this.aritr.next();
            return this.last;
        }

        @Override
        public void remove() {
            this.aritr.remove();
            this.teset.remove(this.last);
        }
    }
}

