/*
 * Decompiled with CFR 0.152.
 */
package io.github.crucible.util.config;

import io.github.crucible.util.config.ConfigMode;
import io.github.crucible.util.config.ConfigSection;
import io.github.crucible.util.config.InternalConverter;
import io.github.crucible.util.config.InvalidConverterException;
import io.github.crucible.util.config.PreserveStatic;
import io.github.crucible.util.config.SerializeOptions;
import java.io.File;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;

public class BaseConfig {
    protected transient File CONFIG_FILE = null;
    protected transient String[] CONFIG_HEADER = null;
    protected transient ConfigMode CONFIG_MODE = ConfigMode.DEFAULT;
    protected transient boolean skipFailedObjects = false;
    protected transient InternalConverter converter = new InternalConverter();

    public void update(ConfigSection configSection) {
    }

    public void addConverter(Class addConverter) throws InvalidConverterException {
        this.converter.addCustomConverter(addConverter);
    }

    protected boolean doSkip(Field field) {
        if (Modifier.isTransient(field.getModifiers()) || Modifier.isFinal(field.getModifiers())) {
            return true;
        }
        if (Modifier.isStatic(field.getModifiers())) {
            if (!field.isAnnotationPresent(PreserveStatic.class)) {
                return true;
            }
            PreserveStatic presStatic = field.getAnnotation(PreserveStatic.class);
            return !presStatic.value();
        }
        return false;
    }

    protected void configureFromSerializeOptionsAnnotation() {
        if (!this.getClass().isAnnotationPresent(SerializeOptions.class)) {
            return;
        }
        SerializeOptions options = this.getClass().getAnnotation(SerializeOptions.class);
        this.CONFIG_HEADER = options.configHeader();
        this.CONFIG_MODE = options.configMode();
        this.skipFailedObjects = options.skipFailedObjects();
    }
}

