/*
 * Decompiled with CFR 0.152.
 */
package me.eigenraven.lwjgl3ify.core;

import io.github.crucible.CrucibleModContainer;
import me.eigenraven.lwjgl3ify.api.Lwjgl3Aware;
import net.minecraft.launchwrapper.IClassTransformer;
import org.objectweb.asm.AnnotationVisitor;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.Type;
import org.objectweb.asm.commons.ClassRemapper;
import org.objectweb.asm.commons.Remapper;

public class LwjglRedirectTransformer
extends Remapper
implements IClassTransformer {
    int remaps = 0;
    int calls = 0;
    public static LwjglRedirectTransformer activeInstance = null;
    final String[] fromPrefixes = new String[]{"org/lwjgl/", "javax/xml/bind/", "javax/servlet/"};
    final String[] toPrefixes = new String[]{"org/lwjglx/", "jakarta/xml/bind/", "jakarta/servlet/"};

    public LwjglRedirectTransformer() {
        activeInstance = this;
    }

    public byte[] transform(String name, String transformedName, byte[] basicClass) {
        if (this != activeInstance) {
            return basicClass;
        }
        if (basicClass == null) {
            return null;
        }
        if (name.contains("lwjgl3ify")) {
            return basicClass;
        }
        ClassReader reader = new ClassReader(basicClass);
        ClassWriter writer = new ClassWriter(0);
        EscapingClassRemapper visitor = new EscapingClassRemapper(writer);
        try {
            reader.accept((ClassVisitor)visitor, 8);
        }
        catch (Lwjgl3AwareException e) {
            return basicClass;
        }
        catch (Exception e) {
            CrucibleModContainer.logger.warn("Couldn't remap class {}", new Object[]{transformedName, e});
            return basicClass;
        }
        return writer.toByteArray();
    }

    public String map(String typeName) {
        if (typeName == null) {
            return null;
        }
        ++this.calls;
        for (int pfx = 0; pfx < this.fromPrefixes.length; ++pfx) {
            if (!typeName.startsWith(this.fromPrefixes[pfx])) continue;
            ++this.remaps;
            return this.toPrefixes[pfx] + typeName.substring(this.fromPrefixes[pfx].length());
        }
        return typeName;
    }

    public class EscapingClassRemapper
    extends ClassRemapper {
        public EscapingClassRemapper(ClassWriter writer) {
            super((ClassVisitor)writer, (Remapper)LwjglRedirectTransformer.this);
        }

        public AnnotationVisitor visitAnnotation(String desc, boolean visible) {
            if (desc.equals(Type.getDescriptor(Lwjgl3Aware.class))) {
                throw new Lwjgl3AwareException();
            }
            return super.visitAnnotation(desc, visible);
        }
    }

    public static class Lwjgl3AwareException
    extends RuntimeException {
    }
}

