/*
 * Decompiled with CFR 0.152.
 */
package me.eigenraven.lwjgl3ify.core;

import io.github.crucible.CrucibleConfigs;
import java.util.ArrayList;
import java.util.List;
import me.eigenraven.lwjgl3ify.WasFinalObjectHolder;
import me.eigenraven.lwjgl3ify.core.ExtensibleEnumTransformerHelper;
import me.eigenraven.lwjgl3ify.core.FixConstantPoolInterfaceMethodRefHelper;
import net.minecraft.launchwrapper.IClassTransformer;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.Type;
import org.objectweb.asm.tree.AnnotationNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.FieldNode;

public class UnfinalizeObjectHoldersTransformer
implements IClassTransformer {
    private final Logger LOGGER = LogManager.getLogger((String)"lwjgl3ify");
    final ExtensibleEnumTransformerHelper enumTransformer = new ExtensibleEnumTransformerHelper();
    final FixConstantPoolInterfaceMethodRefHelper cpiMethodRefTransformer = new FixConstantPoolInterfaceMethodRefHelper();

    private static boolean isHolder(List<AnnotationNode> annotations) {
        if (annotations == null) {
            return false;
        }
        for (AnnotationNode annotationNode : annotations) {
            String desc = annotationNode.desc.replace('$', '/');
            if (desc.contains("cpw/mods/fml/common/registry/GameRegistry/ObjectHolder")) {
                return true;
            }
            if (!desc.contains("cpw/mods/fml/common/registry/GameRegistry/ItemStackHolder")) continue;
            return true;
        }
        return false;
    }

    public byte[] transform(String name, String transformedName, byte[] basicClass) {
        if (basicClass == null) {
            return null;
        }
        if (transformedName.startsWith("me.eigenraven.lwjgl3ify")) {
            return basicClass;
        }
        try {
            boolean ifaceMethodRefsTransformed;
            boolean enumsTransformed;
            ClassReader reader = new ClassReader(basicClass);
            ClassNode node = new ClassNode();
            reader.accept((ClassVisitor)node, 8);
            Type classType = Type.getType((String)("L" + name.replace('.', '/') + ";"));
            boolean transformClass = false;
            boolean workDone = false;
            if (transformedName.equals("net.minecraft.init.Blocks") || transformedName.equals("net.minecraft.init.Items")) {
                transformClass = true;
            }
            transformClass |= UnfinalizeObjectHoldersTransformer.isHolder(node.visibleAnnotations);
            if (transformedName.equals("team.chisel.init.ChiselBlocks")) {
                this.LOGGER.debug("chiselblocks");
            }
            int fieldsModified = 0;
            for (FieldNode field : node.fields) {
                boolean transform = transformClass;
                if (!transform) {
                    transform = UnfinalizeObjectHoldersTransformer.isHolder(field.visibleAnnotations);
                }
                if (!transform) continue;
                workDone = true;
                if ((field.access & 0x10) != 0) {
                    if (field.visibleAnnotations == null) {
                        field.visibleAnnotations = new ArrayList(1);
                        field.visibleAnnotations.add(new AnnotationNode(Type.getDescriptor(WasFinalObjectHolder.class)));
                    }
                    field.access &= 0xFFFFFFEF;
                }
                ++fieldsModified;
            }
            if (workDone) {
                this.LOGGER.info("Unfinalized {} Holder fields in {}", new Object[]{fieldsModified, transformedName});
            }
            if (CrucibleConfigs.configs.lwjgl3ify_extensibleEnums.contains(transformedName)) {
                if (node.interfaces == null) {
                    node.interfaces = new ArrayList(1);
                }
                node.interfaces.add(this.enumTransformer.MARKER_IFACE.getInternalName());
            }
            if (enumsTransformed = this.enumTransformer.processClassWithFlags(node, classType)) {
                workDone = true;
                this.LOGGER.info("Dynamicized enum {}={}", new Object[]{name, transformedName});
            }
            if (ifaceMethodRefsTransformed = this.cpiMethodRefTransformer.transform(node)) {
                workDone = true;
                this.LOGGER.warn("Fixed missing CONSTANT_InterfaceMethodRef miscompilation in {}={}", new Object[]{name, transformedName});
            }
            if (workDone) {
                ClassWriter writer = new ClassWriter(3);
                node.accept((ClassVisitor)writer);
                return writer.toByteArray();
            }
        }
        catch (Exception e) {
            this.LOGGER.error("Error when unfinalizing ObjectHolder transformer", (Throwable)e);
        }
        return basicClass;
    }
}

