/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.common.util;

import com.google.common.base.Throwables;
import cpw.mods.fml.relauncher.ReflectionHelper;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.server.MinecraftServer;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.bukkit.World;
import org.bukkit.WorldType;
import org.bukkit.block.Biome;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.event.inventory.InventoryType;

public class EnumHelper {
    private static final Logger logger = LogManager.getLogger();
    private static final Map<Class<? extends Enum<?>>, Map<String, Enum<?>>> enumConstants = new HashMap();
    private static Object reflectionFactory = null;
    private static Method newConstructorAccessor = null;
    private static Method newInstance = null;
    private static Method newFieldAccessor = null;
    private static Method fieldAccessorSet = null;
    private static boolean isSetup = false;
    private static Class[][] commonTypes = new Class[][]{{aei.class}, {abd.class, Integer.TYPE, int[].class, Integer.TYPE}, {tc.class, String.class, Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE}, {sz.class}, {sx.class, Class.class, Integer.TYPE, awt.class, Boolean.TYPE, Boolean.TYPE}, {avd.class}, {afu.class}, {se.class}, {amv.class}, {azv.class}, {ahn.class, Integer.TYPE}, {za.class}, {adc.class, Integer.TYPE, Integer.TYPE, Float.TYPE, Float.TYPE, Integer.TYPE}, {adq.class, a.class, String.class}};
    private static final Class<?> extensibleEnumIface;
    private static final MethodHandle setFieldHandle;

    public static aei addAction(String name) {
        return EnumHelper.addEnum(aei.class, name, new Object[0]);
    }

    public static abd addArmorMaterial(String name, int durability, int[] reductionAmounts, int enchantability) {
        return EnumHelper.addEnum(abd.class, name, durability, reductionAmounts, enchantability);
    }

    public static tc addArt(String name, String tile, int sizeX, int sizeY, int offsetX, int offsetY) {
        return EnumHelper.addEnum(tc.class, name, tile, sizeX, sizeY, offsetX, offsetY);
    }

    public static sz addCreatureAttribute(String name) {
        return EnumHelper.addEnum(sz.class, name, new Object[0]);
    }

    public static sx addCreatureType(String name, Class typeClass, int maxNumber, awt material, boolean peaceful, boolean animal) {
        return EnumHelper.addEnum(sx.class, name, typeClass, maxNumber, material, peaceful, animal);
    }

    public static avd addDoor(String name) {
        return EnumHelper.addEnum(avd.class, name, new Object[0]);
    }

    public static afu addEnchantmentType(String name) {
        return EnumHelper.addEnum(afu.class, name, new Object[0]);
    }

    public static se addEntitySize(String name) {
        return EnumHelper.addEnum(se.class, name, new Object[0]);
    }

    public static amv addSensitivity(String name) {
        return EnumHelper.addEnum(amv.class, name, new Object[0]);
    }

    public static azv addMovingObjectType(String name) {
        return EnumHelper.addEnum(azv.class, name, new Object[0]);
    }

    public static ahn addSkyBlock(String name, int lightValue) {
        return EnumHelper.addEnum(ahn.class, name, lightValue);
    }

    public static za addStatus(String name) {
        return EnumHelper.addEnum(za.class, name, new Object[0]);
    }

    public static adc addToolMaterial(String name, int harvestLevel, int maxUses, float efficiency, float damage, int enchantability) {
        return EnumHelper.addEnum(adc.class, name, harvestLevel, maxUses, Float.valueOf(efficiency), Float.valueOf(damage), enchantability);
    }

    public static adq addRarity(String name, a color, String displayName) {
        return EnumHelper.addEnum(adq.class, name, color, displayName);
    }

    public static void setFailsafeFieldValue(Field field, Object target, Object value) throws Exception {
        try {
            setFieldHandle.invokeExact(field, target, value);
        }
        catch (Throwable e) {
            Throwables.propagate((Throwable)e);
        }
    }

    public static <T extends Enum<?>> T addEnum(Class<T> enumType, String enumName, Object ... paramValues) {
        return EnumHelper.addEnum(commonTypes, enumType, enumName, paramValues);
    }

    public static <T extends Enum<?>> T addEnum(Class[][] map, Class<T> enumType, String enumName, Object ... paramValues) {
        for (Class[] lookup : map) {
            if (lookup[0] != enumType) continue;
            Class[] paramTypes = new Class[lookup.length - 1];
            if (paramTypes.length > 0) {
                System.arraycopy(lookup, 1, paramTypes, 0, paramTypes.length);
            }
            return EnumHelper.addEnum(enumType, enumName, paramTypes, paramValues);
        }
        return null;
    }

    public static <T extends Enum<?>> T addEnum(Class<T> enumType, String enumName, Class<?>[] paramTypes, Object[] paramValues) {
        if (!extensibleEnumIface.isAssignableFrom(enumType)) {
            throw new RuntimeException("Enum " + enumType.getName() + " was not made extensible, add it to Crucible.yml");
        }
        Map<Class<? extends Enum<?>>, Map<String, Enum<?>>> map = enumConstants;
        synchronized (map) {
            Map enumMap = enumConstants.computeIfAbsent(enumType, k2 -> new HashMap());
            if (enumMap.containsKey(enumName.toUpperCase())) {
                String newName;
                int suffix = 1;
                do {
                    newName = enumName + "$" + suffix;
                    ++suffix;
                } while (enumMap.containsKey(newName.toUpperCase()));
                logger.info("Duplicate Enum found! Remapping {} to {}", new Object[]{enumName, newName});
                enumName = newName;
            }
            try {
                paramTypes = (Class[])ArrayUtils.add((Object[])paramTypes, (int)0, String.class);
                paramValues = ArrayUtils.add((Object[])paramValues, (int)0, (Object)enumName);
                Method creatorHandle = enumType.getMethod("dynamicCreate", paramTypes);
                Enum newValue = (Enum)creatorHandle.invoke(null, paramValues);
                enumMap.put(enumName.toUpperCase(), newValue);
                return (T)newValue;
            }
            catch (Exception e) {
                throw new RuntimeException("Failed to add enum constant: " + enumName, e);
            }
        }
    }

    public static Biome addBukkitBiome(String name) {
        return EnumHelper.addEnum(Biome.class, name, new Class[0], new Object[0]);
    }

    public static World.Environment addBukkitEnvironment(int id, String name) {
        return EnumHelper.addEnum(World.Environment.class, name, new Class[]{Integer.TYPE}, new Object[]{id});
    }

    public static WorldType addBukkitWorldType(String name) {
        WorldType worldType = EnumHelper.addEnum(WorldType.class, name, new Class[]{String.class}, new Object[]{name});
        Map BY_NAME = (Map)ReflectionHelper.getPrivateValue(WorldType.class, null, "BY_NAME");
        BY_NAME.put(name.toUpperCase(), worldType);
        return worldType;
    }

    public static EntityType addBukkitEntityType(String name, Class<? extends Entity> clazz, int typeId, boolean independent) {
        String entityType = name.replace("-", "_").toUpperCase();
        EntityType bukkitType = EnumHelper.addEnum(EntityType.class, entityType, new Class[]{String.class, Class.class, Integer.TYPE, Boolean.TYPE}, new Object[]{name, clazz, typeId, independent});
        Map NAME_MAP = (Map)ReflectionHelper.getPrivateValue(EntityType.class, null, "NAME_MAP");
        Map ID_MAP = (Map)ReflectionHelper.getPrivateValue(EntityType.class, null, "ID_MAP");
        NAME_MAP.put(name.toLowerCase(), bukkitType);
        ID_MAP.put((short)typeId, bukkitType);
        return bukkitType;
    }

    public static InventoryType addInventoryType(aor tileentity) {
        if (!rb.class.isAssignableFrom(tileentity.getClass())) {
            return null;
        }
        String id = (String)aor.j.get(tileentity.getClass());
        try {
            rb teInv = (rb)tileentity;
            int size = teInv.a();
            return EnumHelper.addEnum(InventoryType.class, id, new Class[]{Integer.TYPE, String.class}, new Object[]{size, id});
        }
        catch (Throwable e) {
            MinecraftServer.I();
            if (MinecraftServer.tileEntityConfig.enableTEInventoryWarning.getValue().booleanValue()) {
                logger.log(Level.WARN, "Could not create inventory type " + tileentity.getClass().getName() + " Exception: " + e.toString());
                logger.log(Level.WARN, "Could not determine default inventory size for type " + tileentity.getClass().getName() + " using size of 9");
            }
            return EnumHelper.addEnum(InventoryType.class, id, new Class[]{Integer.TYPE, String.class}, new Object[]{9, id});
        }
    }

    static {
        try {
            extensibleEnumIface = Class.forName("me.eigenraven.lwjgl3ify.IExtensibleEnum");
            Class<?> unsafeHacks = Class.forName("me.eigenraven.lwjgl3ify.UnsafeHacks");
            Method setFieldM = unsafeHacks.getMethod("setField", Field.class, Object.class, Object.class);
            setFieldHandle = MethodHandles.publicLookup().unreflect(setFieldM);
        }
        catch (ReflectiveOperationException e) {
            throw new RuntimeException(e);
        }
    }
}

