/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.command.defaults;

import com.google.common.collect.ImmutableList;
import java.util.List;
import org.apache.commons.lang.Validate;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.command.defaults.VanillaCommand;

public class SetIdleTimeoutCommand
extends VanillaCommand {
    public SetIdleTimeoutCommand() {
        super("setidletimeout");
        this.description = "Sets the server's idle timeout";
        this.usageMessage = "/setidletimeout <Minutes until kick>";
        this.setPermission("bukkit.command.setidletimeout");
    }

    @Override
    public boolean execute(CommandSender sender, String currentAlias, String[] args) {
        if (!this.testPermission(sender)) {
            return true;
        }
        if (args.length == 1) {
            int minutes;
            try {
                minutes = this.getInteger(sender, args[0], 0, Integer.MAX_VALUE, true);
            }
            catch (NumberFormatException ex) {
                sender.sendMessage(ex.getMessage());
                return true;
            }
            Bukkit.getServer().setIdleTimeout(minutes);
            Command.broadcastCommandMessage(sender, "Successfully set the idle timeout to " + minutes + " minutes.");
            return true;
        }
        sender.sendMessage((Object)((Object)ChatColor.RED) + "Usage: " + this.usageMessage);
        return false;
    }

    @Override
    public List<String> tabComplete(CommandSender sender, String alias, String[] args) {
        Validate.notNull((Object)sender, (String)"Sender cannot be null");
        Validate.notNull((Object)args, (String)"Arguments cannot be null");
        Validate.notNull((Object)alias, (String)"Alias cannot be null");
        return ImmutableList.of();
    }
}

