/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_7_R4;

import com.google.common.collect.ImmutableSet;
import com.mojang.authlib.GameProfile;
import java.io.IOException;
import java.util.Date;
import java.util.Set;
import net.minecraft.server.MinecraftServer;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.Validate;
import org.bukkit.BanEntry;
import org.bukkit.BanList;
import org.bukkit.craftbukkit.v1_7_R4.CraftProfileBanEntry;

public class CraftProfileBanList
implements BanList {
    private final op list;

    public CraftProfileBanList(op list) {
        this.list = list;
    }

    @Override
    public BanEntry getBanEntry(String target) {
        Validate.notNull((Object)target, (String)"Target cannot be null");
        GameProfile profile = MinecraftServer.I().ax().a(target);
        if (profile == null) {
            return null;
        }
        oq entry = (oq)this.list.b((Object)profile);
        if (entry == null) {
            return null;
        }
        return new CraftProfileBanEntry(profile, entry, this.list);
    }

    @Override
    public BanEntry addBan(String target, String reason, Date expires, String source) {
        Validate.notNull((Object)target, (String)"Ban target cannot be null");
        GameProfile profile = MinecraftServer.I().ax().a(target);
        if (profile == null) {
            return null;
        }
        oq entry = new oq(profile, new Date(), StringUtils.isBlank((String)source) ? null : source, expires, StringUtils.isBlank((String)reason) ? null : reason);
        this.list.a((ol)entry);
        try {
            this.list.f();
        }
        catch (IOException ex) {
            MinecraftServer.getLogger().error("Failed to save banned-players.json, " + ex.getMessage());
        }
        return new CraftProfileBanEntry(profile, entry, this.list);
    }

    @Override
    public Set<BanEntry> getBanEntries() {
        ImmutableSet.Builder builder = ImmutableSet.builder();
        for (ol entry : this.list.getValues()) {
            GameProfile profile = (GameProfile)entry.f();
            builder.add((Object)new CraftProfileBanEntry(profile, (oq)entry, this.list));
        }
        return builder.build();
    }

    @Override
    public boolean isBanned(String target) {
        Validate.notNull((Object)target, (String)"Target cannot be null");
        GameProfile profile = MinecraftServer.I().ax().a(target);
        if (profile == null) {
            return false;
        }
        return this.list.a(profile);
    }

    @Override
    public void pardon(String target) {
        Validate.notNull((Object)target, (String)"Target cannot be null");
        GameProfile profile = MinecraftServer.I().ax().a(target);
        this.list.c((Object)profile);
    }
}

