/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_7_R4;

import cpw.mods.fml.common.registry.EntityRegistry;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Random;
import java.util.Set;
import java.util.UUID;
import net.minecraftforge.common.util.BlockSnapshot;
import org.apache.commons.lang.Validate;
import org.bukkit.BlockChangeDelegate;
import org.bukkit.Bukkit;
import org.bukkit.Chunk;
import org.bukkit.ChunkSnapshot;
import org.bukkit.Difficulty;
import org.bukkit.Effect;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.Sound;
import org.bukkit.TreeType;
import org.bukkit.World;
import org.bukkit.WorldType;
import org.bukkit.block.Biome;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.craftbukkit.v1_7_R4.CraftChunk;
import org.bukkit.craftbukkit.v1_7_R4.CraftEffect;
import org.bukkit.craftbukkit.v1_7_R4.CraftServer;
import org.bukkit.craftbukkit.v1_7_R4.CraftSound;
import org.bukkit.craftbukkit.v1_7_R4.block.CraftBlock;
import org.bukkit.craftbukkit.v1_7_R4.entity.CraftEntity;
import org.bukkit.craftbukkit.v1_7_R4.entity.CraftItem;
import org.bukkit.craftbukkit.v1_7_R4.entity.CraftLightningStrike;
import org.bukkit.craftbukkit.v1_7_R4.entity.CraftPlayer;
import org.bukkit.craftbukkit.v1_7_R4.inventory.CraftItemStack;
import org.bukkit.craftbukkit.v1_7_R4.metadata.BlockMetadataStore;
import org.bukkit.craftbukkit.v1_7_R4.util.LongHash;
import org.bukkit.entity.Ambient;
import org.bukkit.entity.Arrow;
import org.bukkit.entity.Bat;
import org.bukkit.entity.Blaze;
import org.bukkit.entity.Boat;
import org.bukkit.entity.CaveSpider;
import org.bukkit.entity.Chicken;
import org.bukkit.entity.ComplexLivingEntity;
import org.bukkit.entity.Cow;
import org.bukkit.entity.CreatureType;
import org.bukkit.entity.Creeper;
import org.bukkit.entity.Egg;
import org.bukkit.entity.EnderCrystal;
import org.bukkit.entity.EnderDragon;
import org.bukkit.entity.EnderPearl;
import org.bukkit.entity.EnderSignal;
import org.bukkit.entity.Enderman;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.ExperienceOrb;
import org.bukkit.entity.FallingBlock;
import org.bukkit.entity.Fireball;
import org.bukkit.entity.Firework;
import org.bukkit.entity.Ghast;
import org.bukkit.entity.Giant;
import org.bukkit.entity.Golem;
import org.bukkit.entity.Hanging;
import org.bukkit.entity.Horse;
import org.bukkit.entity.IronGolem;
import org.bukkit.entity.Item;
import org.bukkit.entity.ItemFrame;
import org.bukkit.entity.LeashHitch;
import org.bukkit.entity.LightningStrike;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.MagmaCube;
import org.bukkit.entity.Minecart;
import org.bukkit.entity.MushroomCow;
import org.bukkit.entity.Ocelot;
import org.bukkit.entity.Painting;
import org.bukkit.entity.Pig;
import org.bukkit.entity.PigZombie;
import org.bukkit.entity.Player;
import org.bukkit.entity.Projectile;
import org.bukkit.entity.Sheep;
import org.bukkit.entity.Silverfish;
import org.bukkit.entity.Skeleton;
import org.bukkit.entity.Slime;
import org.bukkit.entity.SmallFireball;
import org.bukkit.entity.Snowball;
import org.bukkit.entity.Snowman;
import org.bukkit.entity.Spider;
import org.bukkit.entity.Squid;
import org.bukkit.entity.TNTPrimed;
import org.bukkit.entity.Tameable;
import org.bukkit.entity.ThrownExpBottle;
import org.bukkit.entity.ThrownPotion;
import org.bukkit.entity.Villager;
import org.bukkit.entity.Weather;
import org.bukkit.entity.Witch;
import org.bukkit.entity.Wither;
import org.bukkit.entity.WitherSkull;
import org.bukkit.entity.Wolf;
import org.bukkit.entity.Zombie;
import org.bukkit.entity.minecart.ExplosiveMinecart;
import org.bukkit.entity.minecart.HopperMinecart;
import org.bukkit.entity.minecart.PoweredMinecart;
import org.bukkit.entity.minecart.SpawnerMinecart;
import org.bukkit.entity.minecart.StorageMinecart;
import org.bukkit.event.entity.CreatureSpawnEvent;
import org.bukkit.event.weather.ThunderChangeEvent;
import org.bukkit.event.weather.WeatherChangeEvent;
import org.bukkit.event.world.SpawnChangeEvent;
import org.bukkit.generator.BlockPopulator;
import org.bukkit.generator.ChunkGenerator;
import org.bukkit.inventory.ItemStack;
import org.bukkit.material.MaterialData;
import org.bukkit.metadata.MetadataValue;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.messaging.StandardMessenger;
import org.bukkit.util.Vector;

public class CraftWorld
implements World {
    private static final Random rand = new Random();
    private final mt world;
    private final CraftServer server = (CraftServer)Bukkit.getServer();
    private final List<BlockPopulator> populators = new ArrayList<BlockPopulator>();
    private final BlockMetadataStore blockMetadata = new BlockMetadataStore(this);
    private final World.Spigot spigot = new World.Spigot(){

        @Override
        public void playEffect(Location location, Effect effect, int id, int data, float offsetX, float offsetY, float offsetZ, float speed, int particleCount, int radius) {
            ha packet;
            Validate.notNull((Object)location, (String)"Location cannot be null");
            Validate.notNull((Object)((Object)effect), (String)"Effect cannot be null");
            Validate.notNull((Object)location.getWorld(), (String)"World cannot be null");
            if (effect.getType() != Effect.Type.PARTICLE) {
                int packetData = effect.getId();
                packet = new ha(packetData, location.getBlockX(), location.getBlockY(), location.getBlockZ(), id, false);
            } else {
                StringBuilder particleFullName = new StringBuilder();
                particleFullName.append(effect.getName());
                if (effect.getData() != null && (effect.getData().equals(awt.class) || effect.getData().equals(MaterialData.class))) {
                    particleFullName.append('_').append(id);
                }
                if (effect.getData() != null && effect.getData().equals(MaterialData.class)) {
                    particleFullName.append('_').append(data);
                }
                packet = new hb(particleFullName.toString(), (float)location.getX(), (float)location.getY(), (float)location.getZ(), offsetX, offsetY, offsetZ, speed, particleCount);
            }
            radius *= radius;
            for (Player player : CraftWorld.this.getPlayers()) {
                int distance;
                if (((CraftPlayer)player).getHandle().a == null || !location.getWorld().equals(player.getWorld()) || (distance = (int)player.getLocation().distanceSquared(location)) > radius) continue;
                ((CraftPlayer)player).getHandle().a.a((ft)packet);
            }
        }

        @Override
        public void playEffect(Location location, Effect effect) {
            CraftWorld.this.playEffect(location, effect, 0);
        }
    };
    private World.Environment environment;
    private ChunkGenerator generator;
    private int monsterSpawn = -1;
    private int animalSpawn = -1;
    private int waterAnimalSpawn = -1;
    private int ambientSpawn = -1;
    private int chunkLoadCount = 0;
    private int chunkGCTickCount;

    public CraftWorld(mt world, ChunkGenerator gen, World.Environment env) {
        this.world = world;
        this.generator = gen;
        this.environment = env;
        if (this.server.chunkGCPeriod > 0) {
            this.chunkGCTickCount = rand.nextInt(this.server.chunkGCPeriod);
        }
    }

    @Override
    public Block getBlockAt(int x, int y2, int z2) {
        Chunk chunk = this.getChunkAt(x >> 4, z2 >> 4);
        return chunk == null ? null : chunk.getBlock(x & 0xF, y2 & 0xFF, z2 & 0xF);
    }

    @Override
    public int getBlockTypeIdAt(int x, int y2, int z2) {
        return this.world.getTypeId(x, y2, z2);
    }

    @Override
    public int getHighestBlockYAt(int x, int z2) {
        if (!this.isChunkLoaded(x >> 4, z2 >> 4)) {
            this.loadChunk(x >> 4, z2 >> 4);
        }
        return this.world.f(x, z2);
    }

    @Override
    public Location getSpawnLocation() {
        r spawn = this.world.K();
        return new Location(this, spawn.a, spawn.b, spawn.c);
    }

    @Override
    public boolean setSpawnLocation(int x, int y2, int z2) {
        try {
            Location previousLocation = this.getSpawnLocation();
            this.world.x.a(x, y2, z2);
            SpawnChangeEvent event = new SpawnChangeEvent(this, previousLocation);
            this.server.getPluginManager().callEvent(event);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    @Override
    public Chunk getChunkAt(int x, int z2) {
        apx chunk = this.world.b.c(x, z2);
        return chunk == null ? null : chunk.bukkitChunk;
    }

    @Override
    public Chunk getChunkAt(Block block) {
        return this.getChunkAt(block.getX() >> 4, block.getZ() >> 4);
    }

    @Override
    public boolean isChunkLoaded(int x, int z2) {
        return this.world.b.a(x, z2);
    }

    @Override
    public Chunk[] getLoadedChunks() {
        Object[] chunks = this.world.b.loadedChunkHashMap_KC.rawVanilla().values().toArray();
        Chunk[] craftChunks = new CraftChunk[chunks.length];
        for (int i = 0; i < chunks.length; ++i) {
            apx chunk = (apx)chunks[i];
            craftChunks[i] = chunk.bukkitChunk;
        }
        return craftChunks;
    }

    @Override
    public void loadChunk(int x, int z2) {
        this.loadChunk(x, z2, true);
    }

    @Override
    public boolean unloadChunk(Chunk chunk) {
        return this.unloadChunk(chunk.getX(), chunk.getZ());
    }

    @Override
    public boolean unloadChunk(int x, int z2) {
        return this.unloadChunk(x, z2, true);
    }

    @Override
    public boolean unloadChunk(int x, int z2, boolean save) {
        return this.unloadChunk(x, z2, save, false);
    }

    @Override
    public boolean unloadChunkRequest(int x, int z2) {
        return this.unloadChunkRequest(x, z2, true);
    }

    @Override
    public boolean unloadChunkRequest(int x, int z2, boolean safe) {
        if (this.isChunkInUse(x, z2)) {
            return false;
        }
        if (this.world.b.c.contains(x, z2)) {
            return true;
        }
        this.world.b.b(x, z2);
        return true;
    }

    @Override
    public boolean unloadChunk(int x, int z2, boolean save, boolean safe) {
        if (this.isChunkInUse(x, z2)) {
            return false;
        }
        if (this.world.b.c.contains(x, z2)) {
            return true;
        }
        this.world.b.b(x, z2);
        return true;
    }

    @Override
    public boolean regenerateChunk(int x, int z2) {
        this.unloadChunk(x, z2, false, false);
        apx chunk = null;
        chunk = this.world.b.e == null ? this.world.b.d : this.world.b.e.d(x, z2);
        this.chunkLoadPostProcess(chunk, x, z2);
        this.refreshChunk(x, z2);
        return chunk != null;
    }

    @Override
    public boolean refreshChunk(int x, int z2) {
        if (!this.isChunkLoaded(x, z2)) {
            return false;
        }
        int px = x << 4;
        int pz = z2 << 4;
        int height = this.getMaxHeight() / 16;
        for (int idx = 0; idx < 64; ++idx) {
            this.world.g(px + idx / height, idx % height * 16, pz);
        }
        this.world.g(px + 15, height * 16 - 1, pz + 15);
        return true;
    }

    @Override
    public boolean isChunkInUse(int x, int z2) {
        return this.world.t().isChunkInUse(x, z2) || this.world.isActiveChunk(x, z2);
    }

    @Override
    public boolean loadChunk(int x, int z2, boolean generate) {
        ++this.chunkLoadCount;
        if (generate) {
            return this.world.b.c(x, z2) != null;
        }
        this.world.b.c.remove(x, z2);
        apx chunk = this.world.b.loadedChunkHashMap_KC.rawThermos().get(x, z2);
        if (chunk == null) {
            this.world.timings.syncChunkLoadTimer.startTiming();
            chunk = this.world.b.f(x, z2);
            this.chunkLoadPostProcess(chunk, x, z2);
            this.world.timings.syncChunkLoadTimer.stopTiming();
        }
        return chunk != null;
    }

    private void chunkLoadPostProcess(apx chunk, int x, int z2) {
        if (chunk != null) {
            this.world.b.loadedChunkHashMap_KC.a(LongHash.toLong(x, z2), chunk);
            this.world.b.h.add(chunk);
            chunk.c();
            if (!chunk.k && this.world.b.a(x + 1, z2 + 1) && this.world.b.a(x, z2 + 1) && this.world.b.a(x + 1, z2)) {
                this.world.b.a((apu)this.world.b, x, z2);
            }
            if (this.world.b.a(x - 1, z2) && !this.world.b.d((int)(x - 1), (int)z2).k && this.world.b.a(x - 1, z2 + 1) && this.world.b.a(x, z2 + 1) && this.world.b.a(x - 1, z2)) {
                this.world.b.a((apu)this.world.b, x - 1, z2);
            }
            if (this.world.b.a(x, z2 - 1) && !this.world.b.d((int)x, (int)(z2 - 1)).k && this.world.b.a(x + 1, z2 - 1) && this.world.b.a(x, z2 - 1) && this.world.b.a(x + 1, z2)) {
                this.world.b.a((apu)this.world.b, x, z2 - 1);
            }
            if (this.world.b.a(x - 1, z2 - 1) && !this.world.b.d((int)(x - 1), (int)(z2 - 1)).k && this.world.b.a(x - 1, z2 - 1) && this.world.b.a(x, z2 - 1) && this.world.b.a(x - 1, z2)) {
                this.world.b.a((apu)this.world.b, x - 1, z2 - 1);
            }
        }
    }

    @Override
    public boolean isChunkLoaded(Chunk chunk) {
        return this.isChunkLoaded(chunk.getX(), chunk.getZ());
    }

    @Override
    public void loadChunk(Chunk chunk) {
        this.loadChunk(chunk.getX(), chunk.getZ());
        ((CraftChunk)this.getChunkAt((int)chunk.getX(), (int)chunk.getZ())).getHandle().bukkitChunk = chunk;
    }

    public mt getHandle() {
        return this.world;
    }

    @Override
    public Item dropItem(Location loc, ItemStack item) {
        Validate.notNull((Object)item, (String)"Cannot drop a Null item.");
        Validate.isTrue((item.getTypeId() != 0 ? 1 : 0) != 0, (String)"Cannot drop AIR.");
        xk entity = new xk((ahb)this.world, loc.getX(), loc.getY(), loc.getZ(), CraftItemStack.asNMSCopy(item));
        entity.b = 10;
        this.world.d((sa)entity);
        return new CraftItem(this.world.getServer(), entity);
    }

    @Override
    public Item dropItemNaturally(Location loc, ItemStack item) {
        double xs = (double)(this.world.s.nextFloat() * 0.7f) + (double)0.15f;
        double ys = (double)(this.world.s.nextFloat() * 0.7f) + (double)0.15f;
        double zs2 = (double)(this.world.s.nextFloat() * 0.7f) + (double)0.15f;
        loc = loc.clone();
        loc.setX(loc.getX() + xs);
        loc.setY(loc.getY() + ys);
        loc.setZ(loc.getZ() + zs2);
        return this.dropItem(loc, item);
    }

    @Override
    public Arrow spawnArrow(Location loc, Vector velocity, float speed, float spread) {
        Validate.notNull((Object)loc, (String)"Can not spawn arrow with a null location");
        Validate.notNull((Object)velocity, (String)"Can not spawn arrow with a null velocity");
        zc arrow = new zc((ahb)this.world);
        arrow.b(loc.getX(), loc.getY(), loc.getZ(), loc.getYaw(), loc.getPitch());
        arrow.c(velocity.getX(), velocity.getY(), velocity.getZ(), speed, spread);
        this.world.d((sa)arrow);
        return (Arrow)((Object)arrow.getBukkitEntity());
    }

    @Override
    @Deprecated
    public LivingEntity spawnCreature(Location loc, CreatureType creatureType) {
        return this.spawnCreature(loc, creatureType.toEntityType());
    }

    @Override
    @Deprecated
    public LivingEntity spawnCreature(Location loc, EntityType creatureType) {
        Validate.isTrue((boolean)creatureType.isAlive(), (String)"EntityType not instance of LivingEntity");
        return (LivingEntity)this.spawnEntity(loc, creatureType);
    }

    @Override
    public Entity spawnEntity(Location loc, EntityType entityType) {
        if (EntityRegistry.entityClassMap.get(entityType.getName()) != null) {
            sa entity = null;
            entity = this.getEntity(EntityRegistry.entityClassMap.get(entityType.getName()), (ahb)this.world);
            if (entity != null) {
                entity.b(loc.getX(), loc.getY(), loc.getZ(), 0.0f, 0.0f);
                this.world.addEntity(entity, CreatureSpawnEvent.SpawnReason.CUSTOM);
                return entity.getBukkitEntity();
            }
        }
        return this.spawn(loc, entityType.getEntityClass());
    }

    public sa getEntity(Class<? extends sa> clazz, ahb world) {
        sw entity = null;
        try {
            entity = (sw)clazz.getConstructor(ahb.class).newInstance(world);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return entity;
    }

    @Override
    public LightningStrike strikeLightning(Location loc) {
        xh lightning = new xh((ahb)this.world, loc.getX(), loc.getY(), loc.getZ());
        this.world.c((sa)lightning);
        return new CraftLightningStrike(this.server, lightning);
    }

    @Override
    public LightningStrike strikeLightningEffect(Location loc) {
        xh lightning = new xh((ahb)this.world, loc.getX(), loc.getY(), loc.getZ(), true);
        this.world.c((sa)lightning);
        return new CraftLightningStrike(this.server, lightning);
    }

    @Override
    public boolean generateTree(Location loc, TreeType type) {
        asf gen;
        switch (type) {
            case BIG_TREE: {
                gen = new ard(true);
                break;
            }
            case BIRCH: {
                gen = new are(true, false);
                break;
            }
            case REDWOOD: {
                gen = new asn(true);
                break;
            }
            case TALL_REDWOOD: {
                gen = new asf();
                break;
            }
            case JUNGLE: {
                gen = new arz(true, 10, 20, 3, 3);
                break;
            }
            case SMALL_JUNGLE: {
                gen = new asq(true, 4 + rand.nextInt(7), 3, 3, false);
                break;
            }
            case COCOA_TREE: {
                gen = new asq(true, 4 + rand.nextInt(7), 3, 3, true);
                break;
            }
            case JUNGLE_BUSH: {
                gen = new arp(3, 0);
                break;
            }
            case RED_MUSHROOM: {
                gen = new aru(1);
                break;
            }
            case BROWN_MUSHROOM: {
                gen = new aru(0);
                break;
            }
            case SWAMP: {
                gen = new aso();
                break;
            }
            case ACACIA: {
                gen = new ask(true);
                break;
            }
            case DARK_OAK: {
                gen = new asi(true);
                break;
            }
            case MEGA_REDWOOD: {
                gen = new asa(true, rand.nextBoolean());
                break;
            }
            case TALL_BIRCH: {
                gen = new are(true, true);
                break;
            }
            default: {
                gen = new asq(true);
            }
        }
        return gen.a((ahb)this.world, rand, loc.getBlockX(), loc.getBlockY(), loc.getBlockZ());
    }

    @Override
    public boolean generateTree(Location loc, TreeType type, BlockChangeDelegate delegate) {
        asf gen;
        switch (type) {
            case BIG_TREE: {
                gen = new ard(true);
                break;
            }
            case BIRCH: {
                gen = new are(true, false);
                break;
            }
            case REDWOOD: {
                gen = new asn(true);
                break;
            }
            case TALL_REDWOOD: {
                gen = new asf();
                break;
            }
            case JUNGLE: {
                gen = new arz(true, 10, 20, 3, 3);
                break;
            }
            case SMALL_JUNGLE: {
                gen = new asq(true, 4 + rand.nextInt(7), 3, 3, false);
                break;
            }
            case JUNGLE_BUSH: {
                gen = new arp(3, 0);
                break;
            }
            case RED_MUSHROOM: {
                gen = new aru(1);
                break;
            }
            case BROWN_MUSHROOM: {
                gen = new aru(0);
                break;
            }
            case SWAMP: {
                gen = new aso();
                break;
            }
            case ACACIA: {
                gen = new ask(true);
                break;
            }
            case DARK_OAK: {
                gen = new asi(true);
                break;
            }
            case MEGA_REDWOOD: {
                gen = new asa(true, rand.nextBoolean());
                break;
            }
            case TALL_BIRCH: {
                gen = new are(true, true);
                break;
            }
            default: {
                gen = new asq(true);
            }
        }
        this.world.captureTreeGeneration = true;
        this.world.captureBlockSnapshots = true;
        boolean grownTree = gen.a((ahb)this.world, rand, loc.getBlockX(), loc.getBlockY(), loc.getBlockZ());
        this.world.captureBlockSnapshots = false;
        this.world.captureTreeGeneration = false;
        if (grownTree) {
            for (BlockSnapshot blocksnapshot : this.world.capturedBlockSnapshots) {
                int x = blocksnapshot.x;
                int y2 = blocksnapshot.y;
                int z2 = blocksnapshot.z;
                aji oldBlock = this.world.a(x, y2, z2);
                int newId = aji.b((aji)blocksnapshot.replacedBlock);
                int data = blocksnapshot.meta;
                int flag = blocksnapshot.flag;
                delegate.setTypeIdAndData(x, y2, z2, newId, data);
                aji newBlock = this.world.a(x, y2, z2);
                this.world.markAndNotifyBlock(x, y2, z2, null, oldBlock, newBlock, flag);
            }
            this.world.capturedBlockSnapshots.clear();
            return true;
        }
        this.world.capturedBlockSnapshots.clear();
        return false;
    }

    public aor getTileEntityAt(int x, int y2, int z2) {
        return this.world.o(x, y2, z2);
    }

    @Override
    public String getName() {
        return this.world.x.k();
    }

    @Deprecated
    public long getId() {
        return this.world.x.b();
    }

    @Override
    public UUID getUID() {
        return this.world.M().getUUID();
    }

    public String toString() {
        return "CraftWorld{name=" + this.getName() + '}';
    }

    @Override
    public long getTime() {
        long time = this.getFullTime() % 24000L;
        if (time < 0L) {
            time += 24000L;
        }
        return time;
    }

    @Override
    public void setTime(long time) {
        long margin = (time - this.getFullTime()) % 24000L;
        if (margin < 0L) {
            margin += 24000L;
        }
        this.setFullTime(this.getFullTime() + margin);
    }

    @Override
    public long getFullTime() {
        return this.world.J();
    }

    @Override
    public void setFullTime(long time) {
        this.world.b(time);
        for (Player p2 : this.getPlayers()) {
            CraftPlayer cp = (CraftPlayer)p2;
            if (cp.getHandle().a == null) continue;
            cp.getHandle().a.a((ft)new ih(cp.getHandle().o.I(), cp.getHandle().getPlayerTime(), cp.getHandle().o.O().b("doDaylightCycle")));
        }
    }

    @Override
    public boolean createExplosion(double x, double y2, double z2, float power) {
        return this.createExplosion(x, y2, z2, power, false, true);
    }

    @Override
    public boolean createExplosion(double x, double y2, double z2, float power, boolean setFire) {
        return this.createExplosion(x, y2, z2, power, setFire, true);
    }

    @Override
    public boolean createExplosion(double x, double y2, double z2, float power, boolean setFire, boolean breakBlocks) {
        return !this.world.a(null, (double)x, (double)y2, (double)z2, (float)power, (boolean)setFire, (boolean)breakBlocks).wasCanceled;
    }

    @Override
    public boolean createExplosion(Location loc, float power) {
        return this.createExplosion(loc, power, false);
    }

    @Override
    public boolean createExplosion(Location loc, float power, boolean setFire) {
        return this.createExplosion(loc.getX(), loc.getY(), loc.getZ(), power, setFire);
    }

    @Override
    public World.Environment getEnvironment() {
        return this.environment;
    }

    public void setEnvironment(World.Environment env) {
        if (this.environment != env) {
            this.environment = env;
            this.world.t = aqo.a((int)this.environment.getId());
        }
    }

    @Override
    public Block getBlockAt(Location location) {
        return this.getBlockAt(location.getBlockX(), location.getBlockY(), location.getBlockZ());
    }

    @Override
    public int getBlockTypeIdAt(Location location) {
        return this.getBlockTypeIdAt(location.getBlockX(), location.getBlockY(), location.getBlockZ());
    }

    @Override
    public int getHighestBlockYAt(Location location) {
        return this.getHighestBlockYAt(location.getBlockX(), location.getBlockZ());
    }

    @Override
    public Chunk getChunkAt(Location location) {
        return this.getChunkAt(location.getBlockX() >> 4, location.getBlockZ() >> 4);
    }

    @Override
    public ChunkGenerator getGenerator() {
        return this.generator;
    }

    public void setGenerator(ChunkGenerator generator) {
        if (this.generator == null) {
            this.generator = generator;
        }
    }

    @Override
    public List<BlockPopulator> getPopulators() {
        return this.populators;
    }

    @Override
    public Block getHighestBlockAt(int x, int z2) {
        return this.getBlockAt(x, this.getHighestBlockYAt(x, z2), z2);
    }

    @Override
    public Block getHighestBlockAt(Location location) {
        return this.getHighestBlockAt(location.getBlockX(), location.getBlockZ());
    }

    @Override
    public Biome getBiome(int x, int z2) {
        return CraftBlock.biomeBaseToBiome(this.world.a(x, z2));
    }

    @Override
    public void setBiome(int x, int z2, Biome bio) {
        apx chunk;
        ahu bb2 = CraftBlock.biomeToBiomeBase(bio);
        if (this.world.d(x, 0, z2) && (chunk = this.world.d(x, z2)) != null) {
            byte[] biomevals = chunk.m();
            biomevals[(z2 & 0xF) << 4 | x & 0xF] = (byte)bb2.ay;
        }
    }

    @Override
    public double getTemperature(int x, int z2) {
        return this.world.a((int)x, (int)z2).ao;
    }

    @Override
    public double getHumidity(int x, int z2) {
        return this.world.a((int)x, (int)z2).ap;
    }

    @Override
    public List<Entity> getEntities() {
        ArrayList<Entity> list = new ArrayList<Entity>();
        for (Object o : this.world.e) {
            sa mcEnt;
            CraftEntity bukkitEntity;
            if (!(o instanceof sa) || (bukkitEntity = (mcEnt = (sa)o).getBukkitEntity()) == null) continue;
            list.add(bukkitEntity);
        }
        return list;
    }

    @Override
    public List<LivingEntity> getLivingEntities() {
        ArrayList<LivingEntity> list = new ArrayList<LivingEntity>();
        for (Object o : this.world.e) {
            sa mcEnt;
            CraftEntity bukkitEntity;
            if (!(o instanceof sa) || (bukkitEntity = (mcEnt = (sa)o).getBukkitEntity()) == null || !(bukkitEntity instanceof LivingEntity)) continue;
            list.add((LivingEntity)((Object)bukkitEntity));
        }
        return list;
    }

    @Override
    @Deprecated
    public <T extends Entity> Collection<T> getEntitiesByClass(Class<T> ... classes) {
        return this.getEntitiesByClasses(classes);
    }

    @Override
    public <T extends Entity> Collection<T> getEntitiesByClass(Class<T> clazz) {
        ArrayList<CraftEntity> list = new ArrayList<CraftEntity>();
        for (Object entity : this.world.e) {
            Class<?> bukkitClass;
            CraftEntity bukkitEntity;
            if (!(entity instanceof sa) || (bukkitEntity = ((sa)entity).getBukkitEntity()) == null || !clazz.isAssignableFrom(bukkitClass = bukkitEntity.getClass())) continue;
            list.add(bukkitEntity);
        }
        return list;
    }

    @Override
    public Collection<Entity> getEntitiesByClasses(Class<?> ... classes) {
        ArrayList<Entity> list = new ArrayList<Entity>();
        block0: for (Object entity : this.world.e) {
            CraftEntity bukkitEntity;
            if (!(entity instanceof sa) || (bukkitEntity = ((sa)entity).getBukkitEntity()) == null) continue;
            Class<?> bukkitClass = bukkitEntity.getClass();
            for (Class<?> clazz : classes) {
                if (!clazz.isAssignableFrom(bukkitClass)) continue;
                list.add(bukkitEntity);
                continue block0;
            }
        }
        return list;
    }

    @Override
    public List<Player> getPlayers() {
        ArrayList<Player> list = new ArrayList<Player>();
        for (Object o : this.world.e) {
            sa mcEnt;
            CraftEntity bukkitEntity;
            if (!(o instanceof sa) || (bukkitEntity = (mcEnt = (sa)o).getBukkitEntity()) == null || !(bukkitEntity instanceof Player)) continue;
            list.add((Player)((Object)bukkitEntity));
        }
        return list;
    }

    @Override
    public void save() {
        this.server.checkSaveState();
        try {
            boolean oldSave = this.world.c;
            this.world.c = false;
            this.world.a(true, null);
            this.world.c = oldSave;
        }
        catch (ahg ex) {
            ex.printStackTrace();
        }
    }

    @Override
    public boolean isAutoSave() {
        return !this.world.c;
    }

    @Override
    public void setAutoSave(boolean value) {
        this.world.c = !value;
    }

    @Override
    public Difficulty getDifficulty() {
        return Difficulty.getByValue(this.getHandle().r.ordinal());
    }

    @Override
    public void setDifficulty(Difficulty difficulty) {
        this.getHandle().r = rd.a((int)difficulty.getValue());
    }

    public BlockMetadataStore getBlockMetadata() {
        return this.blockMetadata;
    }

    @Override
    public boolean hasStorm() {
        return this.world.x.p();
    }

    @Override
    public void setStorm(boolean hasStorm) {
        CraftServer server = this.world.getServer();
        WeatherChangeEvent weather = new WeatherChangeEvent(this, hasStorm);
        server.getPluginManager().callEvent(weather);
        if (!weather.isCancelled()) {
            this.world.x.b(hasStorm);
            if (hasStorm) {
                this.setWeatherDuration(rand.nextInt(12000) + 12000);
            } else {
                this.setWeatherDuration(rand.nextInt(168000) + 12000);
            }
        }
    }

    @Override
    public int getWeatherDuration() {
        return this.world.x.q();
    }

    @Override
    public void setWeatherDuration(int duration) {
        this.world.x.g(duration);
    }

    @Override
    public boolean isThundering() {
        return this.hasStorm() && this.world.x.n();
    }

    @Override
    public void setThundering(boolean thundering) {
        if (thundering && !this.hasStorm()) {
            this.setStorm(true);
        }
        CraftServer server = this.world.getServer();
        ThunderChangeEvent thunder = new ThunderChangeEvent(this, thundering);
        server.getPluginManager().callEvent(thunder);
        if (!thunder.isCancelled()) {
            this.world.x.a(thundering);
            if (thundering) {
                this.setThunderDuration(rand.nextInt(12000) + 3600);
            } else {
                this.setThunderDuration(rand.nextInt(168000) + 12000);
            }
        }
    }

    @Override
    public int getThunderDuration() {
        return this.world.x.o();
    }

    @Override
    public void setThunderDuration(int duration) {
        this.world.x.f(duration);
    }

    @Override
    public long getSeed() {
        return this.world.x.b();
    }

    @Override
    public boolean getPVP() {
        return this.world.pvpMode;
    }

    @Override
    public void setPVP(boolean pvp) {
        this.world.pvpMode = pvp;
    }

    public void playEffect(Player player, Effect effect, int data) {
        this.playEffect(player.getLocation(), effect, data, 0);
    }

    @Override
    public void playEffect(Location location, Effect effect, int data) {
        this.playEffect(location, effect, data, 64);
    }

    @Override
    public <T> void playEffect(Location loc, Effect effect, T data) {
        this.playEffect(loc, effect, data, 64);
    }

    @Override
    public <T> void playEffect(Location loc, Effect effect, T data, int radius) {
        if (data != null) {
            Validate.isTrue((boolean)data.getClass().equals(effect.getData()), (String)"Wrong kind of data for this effect!");
        } else {
            Validate.isTrue((effect.getData() == null ? 1 : 0) != 0, (String)"Wrong kind of data for this effect!");
        }
        if (data != null && data.getClass().equals(MaterialData.class)) {
            MaterialData materialData = (MaterialData)data;
            Validate.isTrue((boolean)materialData.getItemType().isBlock(), (String)"Material must be block");
            this.spigot().playEffect(loc, effect, materialData.getItemType().getId(), materialData.getData(), 0.0f, 0.0f, 0.0f, 1.0f, 1, radius);
        } else {
            int dataValue = data == null ? 0 : CraftEffect.getDataValue(effect, data);
            this.playEffect(loc, effect, dataValue, radius);
        }
    }

    @Override
    public void playEffect(Location location, Effect effect, int data, int radius) {
        this.spigot().playEffect(location, effect, data, 0, 0.0f, 0.0f, 0.0f, 1.0f, 1, radius);
    }

    @Override
    public <T extends Entity> T spawn(Location location, Class<T> clazz) throws IllegalArgumentException {
        return this.spawn(location, clazz, CreatureSpawnEvent.SpawnReason.CUSTOM);
    }

    @Override
    public FallingBlock spawnFallingBlock(Location location, Material material, byte data) throws IllegalArgumentException {
        Validate.notNull((Object)location, (String)"Location cannot be null");
        Validate.notNull((Object)((Object)material), (String)"Material cannot be null");
        Validate.isTrue((boolean)material.isBlock(), (String)"Material must be a block");
        double x = (double)location.getBlockX() + 0.5;
        double y2 = (double)location.getBlockY() + 0.5;
        double z2 = (double)location.getBlockZ() + 0.5;
        xj entity = new xj((ahb)this.world, x, y2, z2, aji.e((int)material.getId()), (int)data);
        entity.b = 1;
        this.world.addEntity((sa)entity, CreatureSpawnEvent.SpawnReason.CUSTOM);
        return (FallingBlock)((Object)entity.getBukkitEntity());
    }

    @Override
    public FallingBlock spawnFallingBlock(Location location, int blockId, byte blockData) throws IllegalArgumentException {
        return this.spawnFallingBlock(location, Material.getMaterial(blockId), blockData);
    }

    public <T extends Entity> T spawn(Location location, Class<T> clazz, CreatureSpawnEvent.SpawnReason reason) throws IllegalArgumentException {
        if (location == null || clazz == null) {
            throw new IllegalArgumentException("Location or entity class cannot be null");
        }
        Object entity = null;
        double x = location.getX();
        double y2 = location.getY();
        double z2 = location.getZ();
        float pitch = location.getPitch();
        float yaw = location.getYaw();
        if (Boat.class.isAssignableFrom(clazz)) {
            entity = new xi((ahb)this.world, x, y2, z2);
        } else if (FallingBlock.class.isAssignableFrom(clazz)) {
            x = location.getBlockX();
            y2 = location.getBlockY();
            z2 = location.getBlockZ();
            int type = this.world.getTypeId((int)x, (int)y2, (int)z2);
            int data = this.world.e((int)x, (int)y2, (int)z2);
            entity = new xj((ahb)this.world, x + 0.5, y2 + 0.5, z2 + 0.5, aji.e((int)type), data);
        } else if (Projectile.class.isAssignableFrom(clazz)) {
            if (Snowball.class.isAssignableFrom(clazz)) {
                entity = new zj((ahb)this.world, x, y2, z2);
            } else if (Egg.class.isAssignableFrom(clazz)) {
                entity = new zl((ahb)this.world, x, y2, z2);
            } else if (Arrow.class.isAssignableFrom(clazz)) {
                entity = new zc((ahb)this.world);
                entity.b(x, y2, z2, 0.0f, 0.0f);
            } else if (ThrownExpBottle.class.isAssignableFrom(clazz)) {
                entity = new zn((ahb)this.world);
                entity.b(x, y2, z2, 0.0f, 0.0f);
            } else if (EnderPearl.class.isAssignableFrom(clazz)) {
                entity = new zm((ahb)this.world);
                entity.b(x, y2, z2, 0.0f, 0.0f);
            } else if (ThrownPotion.class.isAssignableFrom(clazz)) {
                entity = new zo((ahb)this.world, x, y2, z2, CraftItemStack.asNMSCopy(new ItemStack(Material.POTION, 1)));
            } else if (Fireball.class.isAssignableFrom(clazz)) {
                entity = SmallFireball.class.isAssignableFrom(clazz) ? new zi((ahb)this.world) : (WitherSkull.class.isAssignableFrom(clazz) ? new zp((ahb)this.world) : new zg((ahb)this.world));
                entity.b(x, y2, z2, yaw, pitch);
                Vector direction = location.getDirection().multiply(10);
                ((ze)entity).setDirection(direction.getX(), direction.getY(), direction.getZ());
            }
        } else if (Minecart.class.isAssignableFrom(clazz)) {
            entity = PoweredMinecart.class.isAssignableFrom(clazz) ? new xq((ahb)this.world, x, y2, z2) : (StorageMinecart.class.isAssignableFrom(clazz) ? new xm((ahb)this.world, x, y2, z2) : (ExplosiveMinecart.class.isAssignableFrom(clazz) ? new xv((ahb)this.world, x, y2, z2) : (HopperMinecart.class.isAssignableFrom(clazz) ? new xr((ahb)this.world, x, y2, z2) : (SpawnerMinecart.class.isAssignableFrom(clazz) ? new xt((ahb)this.world, x, y2, z2) : new xs((ahb)this.world, x, y2, z2)))));
        } else if (EnderSignal.class.isAssignableFrom(clazz)) {
            entity = new zd((ahb)this.world, x, y2, z2);
        } else if (EnderCrystal.class.isAssignableFrom(clazz)) {
            entity = new wz((ahb)this.world);
            entity.b(x, y2, z2, 0.0f, 0.0f);
        } else if (LivingEntity.class.isAssignableFrom(clazz)) {
            if (Chicken.class.isAssignableFrom(clazz)) {
                entity = new wg((ahb)this.world);
            } else if (Cow.class.isAssignableFrom(clazz)) {
                entity = MushroomCow.class.isAssignableFrom(clazz) ? new wm((ahb)this.world) : new wh((ahb)this.world);
            } else if (Golem.class.isAssignableFrom(clazz)) {
                if (Snowman.class.isAssignableFrom(clazz)) {
                    entity = new wr((ahb)this.world);
                } else if (IronGolem.class.isAssignableFrom(clazz)) {
                    entity = new wt((ahb)this.world);
                }
            } else if (Creeper.class.isAssignableFrom(clazz)) {
                entity = new xz((ahb)this.world);
            } else if (Ghast.class.isAssignableFrom(clazz)) {
                entity = new yd((ahb)this.world);
            } else if (Pig.class.isAssignableFrom(clazz)) {
                entity = new wo((ahb)this.world);
            } else if (!Player.class.isAssignableFrom(clazz)) {
                if (Sheep.class.isAssignableFrom(clazz)) {
                    entity = new wp((ahb)this.world);
                } else if (Horse.class.isAssignableFrom(clazz)) {
                    entity = new wi((ahb)this.world);
                } else if (Skeleton.class.isAssignableFrom(clazz)) {
                    entity = new yl((ahb)this.world);
                } else if (Slime.class.isAssignableFrom(clazz)) {
                    entity = MagmaCube.class.isAssignableFrom(clazz) ? new yf((ahb)this.world) : new ym((ahb)this.world);
                } else if (Spider.class.isAssignableFrom(clazz)) {
                    entity = CaveSpider.class.isAssignableFrom(clazz) ? new xy((ahb)this.world) : new yn((ahb)this.world);
                } else if (Squid.class.isAssignableFrom(clazz)) {
                    entity = new ws((ahb)this.world);
                } else if (Tameable.class.isAssignableFrom(clazz)) {
                    if (Wolf.class.isAssignableFrom(clazz)) {
                        entity = new wv((ahb)this.world);
                    } else if (Ocelot.class.isAssignableFrom(clazz)) {
                        entity = new wn((ahb)this.world);
                    }
                } else if (PigZombie.class.isAssignableFrom(clazz)) {
                    entity = new yh((ahb)this.world);
                } else if (Zombie.class.isAssignableFrom(clazz)) {
                    entity = new yq((ahb)this.world);
                } else if (Giant.class.isAssignableFrom(clazz)) {
                    entity = new ye((ahb)this.world);
                } else if (Silverfish.class.isAssignableFrom(clazz)) {
                    entity = new yk((ahb)this.world);
                } else if (Enderman.class.isAssignableFrom(clazz)) {
                    entity = new ya((ahb)this.world);
                } else if (Blaze.class.isAssignableFrom(clazz)) {
                    entity = new xx((ahb)this.world);
                } else if (Villager.class.isAssignableFrom(clazz)) {
                    entity = new yv((ahb)this.world);
                } else if (Witch.class.isAssignableFrom(clazz)) {
                    entity = new yp((ahb)this.world);
                } else if (Wither.class.isAssignableFrom(clazz)) {
                    entity = new xc((ahb)this.world);
                } else if (ComplexLivingEntity.class.isAssignableFrom(clazz)) {
                    if (EnderDragon.class.isAssignableFrom(clazz)) {
                        entity = new xa((ahb)this.world);
                    }
                } else if (Ambient.class.isAssignableFrom(clazz) && Bat.class.isAssignableFrom(clazz)) {
                    entity = new we((ahb)this.world);
                }
            }
            if (entity != null) {
                entity.a(x, y2, z2, yaw, pitch);
            }
        } else if (Hanging.class.isAssignableFrom(clazz)) {
            int dir;
            Block block = this.getBlockAt(location);
            BlockFace face = BlockFace.SELF;
            if (block.getRelative(BlockFace.EAST).getTypeId() == 0) {
                face = BlockFace.EAST;
            } else if (block.getRelative(BlockFace.NORTH).getTypeId() == 0) {
                face = BlockFace.NORTH;
            } else if (block.getRelative(BlockFace.WEST).getTypeId() == 0) {
                face = BlockFace.WEST;
            } else if (block.getRelative(BlockFace.SOUTH).getTypeId() == 0) {
                face = BlockFace.SOUTH;
            }
            switch (face) {
                default: {
                    dir = 0;
                    break;
                }
                case WEST: {
                    dir = 1;
                    break;
                }
                case NORTH: {
                    dir = 2;
                    break;
                }
                case EAST: {
                    dir = 3;
                }
            }
            if (Painting.class.isAssignableFrom(clazz)) {
                entity = new tb((ahb)this.world, (int)x, (int)y2, (int)z2, dir);
            } else if (ItemFrame.class.isAssignableFrom(clazz)) {
                entity = new st((ahb)this.world, (int)x, (int)y2, (int)z2, dir);
            } else if (LeashHitch.class.isAssignableFrom(clazz)) {
                entity = new su((ahb)this.world, (int)x, (int)y2, (int)z2);
                entity.n = true;
            }
            if (entity != null && !((ss)entity).e()) {
                throw new IllegalArgumentException("Cannot spawn hanging entity for " + clazz.getName() + " at " + location);
            }
        } else if (TNTPrimed.class.isAssignableFrom(clazz)) {
            entity = new xw((ahb)this.world, x, y2, z2, null);
        } else if (ExperienceOrb.class.isAssignableFrom(clazz)) {
            entity = new sq((ahb)this.world, x, y2, z2, 0);
        } else if (Weather.class.isAssignableFrom(clazz)) {
            if (LightningStrike.class.isAssignableFrom(clazz)) {
                entity = new xh((ahb)this.world, x, y2, z2);
            }
        } else if (Firework.class.isAssignableFrom(clazz)) {
            entity = new zf((ahb)this.world, x, y2, z2, null);
        }
        if (entity != null) {
            if (entity instanceof sw) {
                ((sw)entity).a(null);
            }
            this.world.addEntity((sa)entity, reason);
            return (T)entity.getBukkitEntity();
        }
        throw new IllegalArgumentException("Cannot spawn an entity for " + clazz.getName());
    }

    @Override
    public ChunkSnapshot getEmptyChunkSnapshot(int x, int z2, boolean includeBiome, boolean includeBiomeTempRain) {
        return CraftChunk.getEmptyChunkSnapshot(x, z2, this, includeBiome, includeBiomeTempRain);
    }

    @Override
    public void setSpawnFlags(boolean allowMonsters, boolean allowAnimals) {
        this.world.a(allowMonsters, allowAnimals);
    }

    @Override
    public boolean getAllowAnimals() {
        return this.world.H;
    }

    @Override
    public boolean getAllowMonsters() {
        return this.world.G;
    }

    @Override
    public int getMaxHeight() {
        return this.world.R();
    }

    @Override
    public int getSeaLevel() {
        return 64;
    }

    @Override
    public boolean getKeepSpawnInMemory() {
        return this.world.keepSpawnInMemory;
    }

    @Override
    public void setKeepSpawnInMemory(boolean keepLoaded) {
        this.world.keepSpawnInMemory = keepLoaded;
        r chunkcoordinates = this.world.K();
        int chunkCoordX = chunkcoordinates.a >> 4;
        int chunkCoordZ = chunkcoordinates.c >> 4;
        for (int x = -12; x <= 12; ++x) {
            for (int z2 = -12; z2 <= 12; ++z2) {
                if (keepLoaded) {
                    this.loadChunk(chunkCoordX + x, chunkCoordZ + z2);
                    continue;
                }
                if (!this.isChunkLoaded(chunkCoordX + x, chunkCoordZ + z2)) continue;
                if (this.getHandle().e(chunkCoordX + x, chunkCoordZ + z2) instanceof apw) {
                    this.unloadChunk(chunkCoordX + x, chunkCoordZ + z2, false);
                    continue;
                }
                this.unloadChunk(chunkCoordX + x, chunkCoordZ + z2);
            }
        }
    }

    public int hashCode() {
        return this.getUID().hashCode();
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        CraftWorld other = (CraftWorld)obj;
        return this.getUID() == other.getUID();
    }

    @Override
    public File getWorldFolder() {
        return this.world.M().b();
    }

    @Override
    public void sendPluginMessage(Plugin source, String channel, byte[] message) {
        StandardMessenger.validatePluginMessage(this.server.getMessenger(), source, channel, message);
        for (Player player : this.getPlayers()) {
            player.sendPluginMessage(source, channel, message);
        }
    }

    @Override
    public Set<String> getListeningPluginChannels() {
        HashSet<String> result = new HashSet<String>();
        for (Player player : this.getPlayers()) {
            result.addAll(player.getListeningPluginChannels());
        }
        return result;
    }

    @Override
    public WorldType getWorldType() {
        return WorldType.getByName(this.world.N().u().a());
    }

    @Override
    public boolean canGenerateStructures() {
        return this.world.N().s();
    }

    @Override
    public long getTicksPerAnimalSpawns() {
        return this.world.ticksPerAnimalSpawns;
    }

    @Override
    public void setTicksPerAnimalSpawns(int ticksPerAnimalSpawns) {
        this.world.ticksPerAnimalSpawns = ticksPerAnimalSpawns;
    }

    @Override
    public long getTicksPerMonsterSpawns() {
        return this.world.ticksPerMonsterSpawns;
    }

    @Override
    public void setTicksPerMonsterSpawns(int ticksPerMonsterSpawns) {
        this.world.ticksPerMonsterSpawns = ticksPerMonsterSpawns;
    }

    @Override
    public void setMetadata(String metadataKey, MetadataValue newMetadataValue) {
        this.server.getWorldMetadata().setMetadata(this, metadataKey, newMetadataValue);
    }

    @Override
    public List<MetadataValue> getMetadata(String metadataKey) {
        return this.server.getWorldMetadata().getMetadata(this, metadataKey);
    }

    @Override
    public boolean hasMetadata(String metadataKey) {
        return this.server.getWorldMetadata().hasMetadata(this, metadataKey);
    }

    @Override
    public void removeMetadata(String metadataKey, Plugin owningPlugin) {
        this.server.getWorldMetadata().removeMetadata(this, metadataKey, owningPlugin);
    }

    @Override
    public int getMonsterSpawnLimit() {
        if (this.monsterSpawn < 0) {
            return this.server.getMonsterSpawnLimit();
        }
        return this.monsterSpawn;
    }

    @Override
    public void setMonsterSpawnLimit(int limit) {
        this.monsterSpawn = limit;
    }

    @Override
    public int getAnimalSpawnLimit() {
        if (this.animalSpawn < 0) {
            return this.server.getAnimalSpawnLimit();
        }
        return this.animalSpawn;
    }

    @Override
    public void setAnimalSpawnLimit(int limit) {
        this.animalSpawn = limit;
    }

    @Override
    public int getWaterAnimalSpawnLimit() {
        if (this.waterAnimalSpawn < 0) {
            return this.server.getWaterAnimalSpawnLimit();
        }
        return this.waterAnimalSpawn;
    }

    @Override
    public void setWaterAnimalSpawnLimit(int limit) {
        this.waterAnimalSpawn = limit;
    }

    @Override
    public int getAmbientSpawnLimit() {
        if (this.ambientSpawn < 0) {
            return this.server.getAmbientSpawnLimit();
        }
        return this.ambientSpawn;
    }

    @Override
    public void setAmbientSpawnLimit(int limit) {
        this.ambientSpawn = limit;
    }

    @Override
    public void playSound(Location loc, Sound sound, float volume, float pitch) {
        if (loc == null || sound == null) {
            return;
        }
        double x = loc.getX();
        double y2 = loc.getY();
        double z2 = loc.getZ();
        this.getHandle().a(x, y2, z2, CraftSound.getSound(sound), volume, pitch);
    }

    @Override
    public String getGameRuleValue(String rule) {
        return this.getHandle().O().a(rule);
    }

    @Override
    public boolean setGameRuleValue(String rule, String value) {
        if (rule == null || value == null) {
            return false;
        }
        if (!this.isGameRule(rule)) {
            return false;
        }
        this.getHandle().O().b(rule, value);
        return true;
    }

    @Override
    public String[] getGameRules() {
        return this.getHandle().O().b();
    }

    @Override
    public boolean isGameRule(String rule) {
        return this.getHandle().O().e(rule);
    }

    public void processChunkGC() {
        ++this.chunkGCTickCount;
        if (this.chunkLoadCount >= this.server.chunkGCLoadThresh && this.server.chunkGCLoadThresh > 0) {
            this.chunkLoadCount = 0;
        } else if (this.chunkGCTickCount >= this.server.chunkGCPeriod && this.server.chunkGCPeriod > 0) {
            this.chunkGCTickCount = 0;
        } else {
            return;
        }
        ms cps = this.world.b;
        for (apx chunk : this.world.b.loadedChunkHashMap_KC.rawVanilla().values()) {
            if (this.isChunkInUse(chunk.g, chunk.h) || cps.c.contains(chunk.g, chunk.h)) continue;
            cps.b(chunk.g, chunk.h);
        }
    }

    @Override
    public World.Spigot spigot() {
        return this.spigot;
    }

    @Override
    public mt getWorldServer() {
        return this.world;
    }
}

