/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_7_R4.block;

import com.mojang.authlib.GameProfile;
import cpw.mods.fml.common.FMLLog;
import io.github.crucible.CrucibleConfigs;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import net.minecraftforge.cauldron.block.CraftCustomContainer;
import net.minecraftforge.common.util.EnumHelper;
import org.bukkit.Chunk;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.block.Biome;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.block.BlockState;
import org.bukkit.block.PistonMoveReaction;
import org.bukkit.craftbukkit.v1_7_R4.CraftChunk;
import org.bukkit.craftbukkit.v1_7_R4.CraftWorld;
import org.bukkit.craftbukkit.v1_7_R4.block.CraftBeacon;
import org.bukkit.craftbukkit.v1_7_R4.block.CraftBlockState;
import org.bukkit.craftbukkit.v1_7_R4.block.CraftBrewingStand;
import org.bukkit.craftbukkit.v1_7_R4.block.CraftChest;
import org.bukkit.craftbukkit.v1_7_R4.block.CraftCommandBlock;
import org.bukkit.craftbukkit.v1_7_R4.block.CraftCreatureSpawner;
import org.bukkit.craftbukkit.v1_7_R4.block.CraftDispenser;
import org.bukkit.craftbukkit.v1_7_R4.block.CraftDropper;
import org.bukkit.craftbukkit.v1_7_R4.block.CraftFurnace;
import org.bukkit.craftbukkit.v1_7_R4.block.CraftHopper;
import org.bukkit.craftbukkit.v1_7_R4.block.CraftJukebox;
import org.bukkit.craftbukkit.v1_7_R4.block.CraftNoteBlock;
import org.bukkit.craftbukkit.v1_7_R4.block.CraftSign;
import org.bukkit.craftbukkit.v1_7_R4.block.CraftSkull;
import org.bukkit.craftbukkit.v1_7_R4.inventory.CraftItemStack;
import org.bukkit.craftbukkit.v1_7_R4.util.CraftMagicNumbers;
import org.bukkit.inventory.ItemStack;
import org.bukkit.metadata.MetadataValue;
import org.bukkit.plugin.Plugin;
import org.bukkit.util.BlockVector;

public class CraftBlock
implements Block {
    private static final Biome[] BIOME_MAPPING = new Biome[ahu.n().length];
    private static final ahu[] BIOMEBASE_MAPPING = new ahu[ahu.n().length];
    private final CraftChunk chunk;
    private final int x;
    private final int y;
    private final int z;

    public CraftBlock(CraftChunk chunk, int x, int y2, int z2) {
        this.x = x;
        this.y = y2;
        this.z = z2;
        this.chunk = chunk;
    }

    private static aji getNMSBlock(int type) {
        return CraftMagicNumbers.getBlock(type);
    }

    public static BlockFace notchToBlockFace(int notch) {
        switch (notch) {
            case 0: {
                return BlockFace.DOWN;
            }
            case 1: {
                return BlockFace.UP;
            }
            case 2: {
                return BlockFace.NORTH;
            }
            case 3: {
                return BlockFace.SOUTH;
            }
            case 4: {
                return BlockFace.WEST;
            }
            case 5: {
                return BlockFace.EAST;
            }
        }
        return BlockFace.SELF;
    }

    public static int blockFaceToNotch(BlockFace face) {
        switch (face) {
            case DOWN: {
                return 0;
            }
            case UP: {
                return 1;
            }
            case NORTH: {
                return 2;
            }
            case SOUTH: {
                return 3;
            }
            case WEST: {
                return 4;
            }
            case EAST: {
                return 5;
            }
        }
        return 7;
    }

    public static Biome biomeBaseToBiome(ahu base) {
        if (base == null) {
            return null;
        }
        return BIOME_MAPPING[base.ay];
    }

    public static ahu biomeToBiomeBase(Biome bio) {
        if (bio == null) {
            return null;
        }
        return BIOMEBASE_MAPPING[bio.ordinal()];
    }

    public static void initMappings() {
        CraftBlock.BIOME_MAPPING[ahu.u.ay] = Biome.SWAMPLAND;
        CraftBlock.BIOME_MAPPING[ahu.s.ay] = Biome.FOREST;
        CraftBlock.BIOME_MAPPING[ahu.t.ay] = Biome.TAIGA;
        CraftBlock.BIOME_MAPPING[ahu.q.ay] = Biome.DESERT;
        CraftBlock.BIOME_MAPPING[ahu.p.ay] = Biome.PLAINS;
        CraftBlock.BIOME_MAPPING[ahu.w.ay] = Biome.HELL;
        CraftBlock.BIOME_MAPPING[ahu.x.ay] = Biome.SKY;
        CraftBlock.BIOME_MAPPING[ahu.v.ay] = Biome.RIVER;
        CraftBlock.BIOME_MAPPING[ahu.r.ay] = Biome.EXTREME_HILLS;
        CraftBlock.BIOME_MAPPING[ahu.o.ay] = Biome.OCEAN;
        CraftBlock.BIOME_MAPPING[ahu.y.ay] = Biome.FROZEN_OCEAN;
        CraftBlock.BIOME_MAPPING[ahu.z.ay] = Biome.FROZEN_RIVER;
        CraftBlock.BIOME_MAPPING[ahu.A.ay] = Biome.ICE_PLAINS;
        CraftBlock.BIOME_MAPPING[ahu.B.ay] = Biome.ICE_MOUNTAINS;
        CraftBlock.BIOME_MAPPING[ahu.C.ay] = Biome.MUSHROOM_ISLAND;
        CraftBlock.BIOME_MAPPING[ahu.D.ay] = Biome.MUSHROOM_SHORE;
        CraftBlock.BIOME_MAPPING[ahu.E.ay] = Biome.BEACH;
        CraftBlock.BIOME_MAPPING[ahu.F.ay] = Biome.DESERT_HILLS;
        CraftBlock.BIOME_MAPPING[ahu.G.ay] = Biome.FOREST_HILLS;
        CraftBlock.BIOME_MAPPING[ahu.H.ay] = Biome.TAIGA_HILLS;
        CraftBlock.BIOME_MAPPING[ahu.I.ay] = Biome.SMALL_MOUNTAINS;
        CraftBlock.BIOME_MAPPING[ahu.J.ay] = Biome.JUNGLE;
        CraftBlock.BIOME_MAPPING[ahu.K.ay] = Biome.JUNGLE_HILLS;
        CraftBlock.BIOME_MAPPING[ahu.L.ay] = Biome.JUNGLE_EDGE;
        CraftBlock.BIOME_MAPPING[ahu.M.ay] = Biome.DEEP_OCEAN;
        CraftBlock.BIOME_MAPPING[ahu.N.ay] = Biome.STONE_BEACH;
        CraftBlock.BIOME_MAPPING[ahu.O.ay] = Biome.COLD_BEACH;
        CraftBlock.BIOME_MAPPING[ahu.P.ay] = Biome.BIRCH_FOREST;
        CraftBlock.BIOME_MAPPING[ahu.Q.ay] = Biome.BIRCH_FOREST_HILLS;
        CraftBlock.BIOME_MAPPING[ahu.R.ay] = Biome.ROOFED_FOREST;
        CraftBlock.BIOME_MAPPING[ahu.S.ay] = Biome.COLD_TAIGA;
        CraftBlock.BIOME_MAPPING[ahu.T.ay] = Biome.COLD_TAIGA_HILLS;
        CraftBlock.BIOME_MAPPING[ahu.U.ay] = Biome.MEGA_TAIGA;
        CraftBlock.BIOME_MAPPING[ahu.V.ay] = Biome.MEGA_TAIGA_HILLS;
        CraftBlock.BIOME_MAPPING[ahu.W.ay] = Biome.EXTREME_HILLS_PLUS;
        CraftBlock.BIOME_MAPPING[ahu.X.ay] = Biome.SAVANNA;
        CraftBlock.BIOME_MAPPING[ahu.Y.ay] = Biome.SAVANNA_PLATEAU;
        CraftBlock.BIOME_MAPPING[ahu.Z.ay] = Biome.MESA;
        CraftBlock.BIOME_MAPPING[ahu.aa.ay] = Biome.MESA_PLATEAU_FOREST;
        CraftBlock.BIOME_MAPPING[ahu.ab.ay] = Biome.MESA_PLATEAU;
        CraftBlock.BIOME_MAPPING[ahu.p.ay + 128] = Biome.SUNFLOWER_PLAINS;
        CraftBlock.BIOME_MAPPING[ahu.q.ay + 128] = Biome.DESERT_MOUNTAINS;
        CraftBlock.BIOME_MAPPING[ahu.s.ay + 128] = Biome.FLOWER_FOREST;
        CraftBlock.BIOME_MAPPING[ahu.t.ay + 128] = Biome.TAIGA_MOUNTAINS;
        CraftBlock.BIOME_MAPPING[ahu.u.ay + 128] = Biome.SWAMPLAND_MOUNTAINS;
        CraftBlock.BIOME_MAPPING[ahu.A.ay + 128] = Biome.ICE_PLAINS_SPIKES;
        CraftBlock.BIOME_MAPPING[ahu.J.ay + 128] = Biome.JUNGLE_MOUNTAINS;
        CraftBlock.BIOME_MAPPING[ahu.L.ay + 128] = Biome.JUNGLE_EDGE_MOUNTAINS;
        CraftBlock.BIOME_MAPPING[ahu.S.ay + 128] = Biome.COLD_TAIGA_MOUNTAINS;
        CraftBlock.BIOME_MAPPING[ahu.X.ay + 128] = Biome.SAVANNA_MOUNTAINS;
        CraftBlock.BIOME_MAPPING[ahu.Y.ay + 128] = Biome.SAVANNA_PLATEAU_MOUNTAINS;
        CraftBlock.BIOME_MAPPING[ahu.Z.ay + 128] = Biome.MESA_BRYCE;
        CraftBlock.BIOME_MAPPING[ahu.aa.ay + 128] = Biome.MESA_PLATEAU_FOREST_MOUNTAINS;
        CraftBlock.BIOME_MAPPING[ahu.ab.ay + 128] = Biome.MESA_PLATEAU_MOUNTAINS;
        CraftBlock.BIOME_MAPPING[ahu.P.ay + 128] = Biome.BIRCH_FOREST_MOUNTAINS;
        CraftBlock.BIOME_MAPPING[ahu.Q.ay + 128] = Biome.BIRCH_FOREST_HILLS_MOUNTAINS;
        CraftBlock.BIOME_MAPPING[ahu.R.ay + 128] = Biome.ROOFED_FOREST_MOUNTAINS;
        CraftBlock.BIOME_MAPPING[ahu.U.ay + 128] = Biome.MEGA_SPRUCE_TAIGA;
        CraftBlock.BIOME_MAPPING[ahu.r.ay + 128] = Biome.EXTREME_HILLS_MOUNTAINS;
        CraftBlock.BIOME_MAPPING[ahu.W.ay + 128] = Biome.EXTREME_HILLS_PLUS_MOUNTAINS;
        CraftBlock.BIOME_MAPPING[ahu.V.ay + 128] = Biome.MEGA_SPRUCE_TAIGA_HILLS;
        for (int i = 0; i < BIOME_MAPPING.length; ++i) {
            if (ahu.d((int)i) != null && BIOME_MAPPING[i] == null) {
                String name = Material.normalizeName(ahu.d((int)i).af);
                int id = ahu.d((int)i).ay;
                System.out.println("Adding biome mapping " + ahu.d((int)i).ay + " " + name + " at BiomeBase[" + i + "]");
                EnumHelper.addBukkitBiome(name);
                CraftBlock.BIOME_MAPPING[ahu.d((int)i).ay] = Enum.valueOf(Biome.class, name);
            }
            if (BIOME_MAPPING[i] == null) continue;
            CraftBlock.BIOMEBASE_MAPPING[CraftBlock.BIOME_MAPPING[i].ordinal()] = ahu.d((int)i);
        }
    }

    public static void dumpMaterials() {
        if (CrucibleConfigs.configs.cauldron_settings_dumpMaterials) {
            FMLLog.info("Cauldron Dump Materials is ENABLED. Starting dump...", new Object[0]);
            for (int i = 0; i < 32000; ++i) {
                Material material = Material.getMaterial(i);
                if (material == null) continue;
                FMLLog.info("Found material " + (Object)((Object)material) + " with ID " + i, new Object[0]);
            }
            FMLLog.info("Cauldron Dump Materials complete.", new Object[0]);
            FMLLog.info("To disable these dumps, set cauldron.dump-materials to false in bukkit.yml.", new Object[0]);
        }
    }

    public aji getNMSBlock() {
        return CraftMagicNumbers.getBlock(this);
    }

    @Override
    public World getWorld() {
        return this.chunk.getWorld();
    }

    @Override
    public Location getLocation() {
        return new Location(this.getWorld(), this.x, this.y, this.z);
    }

    @Override
    public Location getLocation(Location loc) {
        if (loc != null) {
            loc.setWorld(this.getWorld());
            loc.setX(this.x);
            loc.setY(this.y);
            loc.setZ(this.z);
            loc.setYaw(0.0f);
            loc.setPitch(0.0f);
        }
        return loc;
    }

    public BlockVector getVector() {
        return new BlockVector(this.x, this.y, this.z);
    }

    @Override
    public int getX() {
        return this.x;
    }

    @Override
    public int getY() {
        return this.y;
    }

    @Override
    public int getZ() {
        return this.z;
    }

    @Override
    public Chunk getChunk() {
        return this.chunk;
    }

    @Override
    public void setData(byte data, boolean applyPhysics) {
        if (applyPhysics) {
            this.chunk.getHandle().e.a(this.x, this.y, this.z, (int)data, 3);
        } else {
            this.chunk.getHandle().e.a(this.x, this.y, this.z, (int)data, 2);
        }
    }

    @Override
    public byte getData() {
        return (byte)this.chunk.getHandle().c(this.x & 0xF, this.y & 0xFF, this.z & 0xF);
    }

    @Override
    public void setData(byte data) {
        this.chunk.getHandle().e.a(this.x, this.y, this.z, (int)data, 3);
    }

    @Override
    public boolean setTypeId(int type) {
        return this.setTypeId(type, true);
    }

    @Override
    public boolean setTypeId(int type, boolean applyPhysics) {
        return this.setTypeIdAndData(type, this.getData(), applyPhysics);
    }

    @Override
    public boolean setTypeIdAndData(int type, byte data, boolean applyPhysics) {
        if (applyPhysics) {
            return this.chunk.getHandle().e.d(this.x, this.y, this.z, CraftBlock.getNMSBlock(type), (int)data, 3);
        }
        boolean success = this.chunk.getHandle().e.d(this.x, this.y, this.z, CraftBlock.getNMSBlock(type), (int)data, 2);
        if (success) {
            this.chunk.getHandle().e.g(this.x, this.y, this.z);
        }
        return success;
    }

    @Override
    public Material getType() {
        return Material.getMaterial(this.getTypeId());
    }

    @Override
    public void setType(Material type) {
        this.setTypeId(type.getId());
    }

    @Override
    @Deprecated
    public int getTypeId() {
        return CraftMagicNumbers.getId(this.chunk.getHandle().a(this.x & 0xF, this.y & 0xFF, this.z & 0xF));
    }

    @Override
    public byte getLightLevel() {
        return (byte)this.chunk.getHandle().e.k(this.x, this.y, this.z);
    }

    @Override
    public byte getLightFromSky() {
        return (byte)this.chunk.getHandle().a(ahn.a, this.x & 0xF, this.y & 0xFF, this.z & 0xF);
    }

    @Override
    public byte getLightFromBlocks() {
        return (byte)this.chunk.getHandle().a(ahn.b, this.x & 0xF, this.y & 0xFF, this.z & 0xF);
    }

    public Block getFace(BlockFace face) {
        return this.getRelative(face, 1);
    }

    public Block getFace(BlockFace face, int distance) {
        return this.getRelative(face, distance);
    }

    @Override
    public Block getRelative(int modX, int modY, int modZ) {
        return this.getWorld().getBlockAt(this.getX() + modX, this.getY() + modY, this.getZ() + modZ);
    }

    @Override
    public Block getRelative(BlockFace face) {
        return this.getRelative(face, 1);
    }

    @Override
    public Block getRelative(BlockFace face, int distance) {
        return this.getRelative(face.getModX() * distance, face.getModY() * distance, face.getModZ() * distance);
    }

    @Override
    public BlockFace getFace(Block block) {
        BlockFace[] values;
        for (BlockFace face : values = BlockFace.values()) {
            if (this.getX() + face.getModX() != block.getX() || this.getY() + face.getModY() != block.getY() || this.getZ() + face.getModZ() != block.getZ()) continue;
            return face;
        }
        return null;
    }

    public String toString() {
        return "CraftBlock{chunk=" + this.chunk + ",x=" + this.x + ",y=" + this.y + ",z=" + this.z + ",type=" + (Object)((Object)this.getType()) + ",data=" + this.getData() + '}';
    }

    @Override
    public BlockState getState() {
        Material material = this.getType();
        if (material == null) {
            aor te2 = ((CraftWorld)this.getWorld()).getHandle().o(this.getX(), this.getY(), this.getZ());
            if (te2 != null && te2 instanceof rb) {
                return new CraftCustomContainer(this);
            }
            return new CraftBlockState(this);
        }
        switch (material) {
            case SIGN: 
            case SIGN_POST: 
            case WALL_SIGN: {
                return new CraftSign(this);
            }
            case CHEST: 
            case TRAPPED_CHEST: {
                return new CraftChest(this);
            }
            case BURNING_FURNACE: 
            case FURNACE: {
                return new CraftFurnace(this);
            }
            case DISPENSER: {
                return new CraftDispenser(this);
            }
            case DROPPER: {
                return new CraftDropper(this);
            }
            case HOPPER: {
                return new CraftHopper(this);
            }
            case MOB_SPAWNER: {
                return new CraftCreatureSpawner(this);
            }
            case NOTE_BLOCK: {
                return new CraftNoteBlock(this);
            }
            case JUKEBOX: {
                return new CraftJukebox(this);
            }
            case BREWING_STAND: {
                return new CraftBrewingStand(this);
            }
            case SKULL: {
                return new CraftSkull(this);
            }
            case COMMAND: {
                return new CraftCommandBlock(this);
            }
            case BEACON: {
                return new CraftBeacon(this);
            }
        }
        aor te3 = ((CraftWorld)this.getWorld()).getHandle().o(this.getX(), this.getY(), this.getZ());
        if (te3 != null && te3 instanceof rb) {
            return new CraftCustomContainer(this);
        }
        return new CraftBlockState(this);
    }

    @Override
    public Biome getBiome() {
        return this.getWorld().getBiome(this.x, this.z);
    }

    @Override
    public void setBiome(Biome bio) {
        this.getWorld().setBiome(this.x, this.z, bio);
    }

    @Override
    public double getTemperature() {
        return this.getWorld().getTemperature(this.x, this.z);
    }

    @Override
    public double getHumidity() {
        return this.getWorld().getHumidity(this.x, this.z);
    }

    @Override
    public boolean isBlockPowered() {
        return this.chunk.getHandle().e.u(this.x, this.y, this.z) > 0;
    }

    @Override
    public boolean isBlockIndirectlyPowered() {
        return this.chunk.getHandle().e.v(this.x, this.y, this.z);
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CraftBlock)) {
            return false;
        }
        CraftBlock other = (CraftBlock)o;
        return this.x == other.x && this.y == other.y && this.z == other.z && this.getWorld().equals(other.getWorld());
    }

    public int hashCode() {
        return this.y << 24 ^ this.x ^ this.z ^ this.getWorld().hashCode();
    }

    @Override
    public boolean isBlockFacePowered(BlockFace face) {
        return this.chunk.getHandle().e.f(this.x, this.y, this.z, CraftBlock.blockFaceToNotch(face));
    }

    @Override
    public boolean isBlockFaceIndirectlyPowered(BlockFace face) {
        int power = this.chunk.getHandle().e.g(this.x, this.y, this.z, CraftBlock.blockFaceToNotch(face));
        Block relative = this.getRelative(face);
        if (relative.getType() == Material.REDSTONE_WIRE) {
            return Math.max(power, relative.getData()) > 0;
        }
        return power > 0;
    }

    @Override
    public int getBlockPower(BlockFace face) {
        int power = 0;
        ana wire = ajn.af;
        ahb world = this.chunk.getHandle().e;
        if ((face == BlockFace.DOWN || face == BlockFace.SELF) && world.f(this.x, this.y - 1, this.z, 0)) {
            power = wire.a(world, this.x, this.y - 1, this.z, power);
        }
        if ((face == BlockFace.UP || face == BlockFace.SELF) && world.f(this.x, this.y + 1, this.z, 1)) {
            power = wire.a(world, this.x, this.y + 1, this.z, power);
        }
        if ((face == BlockFace.EAST || face == BlockFace.SELF) && world.f(this.x + 1, this.y, this.z, 2)) {
            power = wire.a(world, this.x + 1, this.y, this.z, power);
        }
        if ((face == BlockFace.WEST || face == BlockFace.SELF) && world.f(this.x - 1, this.y, this.z, 3)) {
            power = wire.a(world, this.x - 1, this.y, this.z, power);
        }
        if ((face == BlockFace.NORTH || face == BlockFace.SELF) && world.f(this.x, this.y, this.z - 1, 4)) {
            power = wire.a(world, this.x, this.y, this.z - 1, power);
        }
        if ((face == BlockFace.SOUTH || face == BlockFace.SELF) && world.f(this.x, this.y, this.z + 1, 5)) {
            power = wire.a(world, this.x, this.y, this.z - 1, power);
        }
        return power > 0 ? power : ((face == BlockFace.SELF ? this.isBlockIndirectlyPowered() : this.isBlockFaceIndirectlyPowered(face)) ? 15 : 0);
    }

    @Override
    public int getBlockPower() {
        return this.getBlockPower(BlockFace.SELF);
    }

    @Override
    public boolean isEmpty() {
        if (this.getType() == Material.AIR) {
            return true;
        }
        if (!(this.getWorld() instanceof CraftWorld)) {
            return false;
        }
        return ((CraftWorld)this.getWorld()).getHandle().c(this.getX(), this.getY(), this.getZ());
    }

    @Override
    public boolean isLiquid() {
        return this.getType() == Material.WATER || this.getType() == Material.STATIONARY_WATER || this.getType() == Material.LAVA || this.getType() == Material.STATIONARY_LAVA;
    }

    @Override
    public PistonMoveReaction getPistonMoveReaction() {
        return PistonMoveReaction.getById(this.getNMSBlock().o().m());
    }

    private boolean itemCausesDrops(ItemStack item) {
        aji block = this.getNMSBlock();
        adb itemType = item != null ? adb.d((int)item.getTypeId()) : null;
        return block != null && (block.o().l() || itemType != null && itemType.b(block));
    }

    @Override
    public boolean breakNaturally() {
        aji block = this.getNMSBlock();
        byte data = this.getData();
        boolean result = false;
        if (block != null && block != ajn.a) {
            block.a(this.chunk.getHandle().e, this.x, this.y, this.z, (int)data, 1.0f, 0);
            result = true;
        }
        this.setTypeId(Material.AIR.getId());
        return result;
    }

    @Override
    public boolean breakNaturally(ItemStack item) {
        if (this.itemCausesDrops(item)) {
            return this.breakNaturally();
        }
        return this.setTypeId(Material.AIR.getId());
    }

    @Override
    public Collection<ItemStack> getDrops() {
        ArrayList<ItemStack> drops = new ArrayList<ItemStack>();
        aji block = this.getNMSBlock();
        if (block != ajn.a) {
            byte data = this.getData();
            int count = block.a(0, this.chunk.getHandle().e.s);
            for (int i = 0; i < count; ++i) {
                adb item = block.a((int)data, this.chunk.getHandle().e.s, 0);
                if (item == null) continue;
                if (ajn.bP == block) {
                    add nmsStack = new add(item, 1, block.k(this.chunk.getHandle().e, this.x, this.y, this.z));
                    apn tileentityskull = (apn)this.chunk.getHandle().e.o(this.x, this.y, this.z);
                    if (tileentityskull.b() == 3 && tileentityskull.a() != null) {
                        nmsStack.d(new dh());
                        dh nbttagcompound = new dh();
                        dv.a((dh)nbttagcompound, (GameProfile)tileentityskull.a());
                        nmsStack.q().a("SkullOwner", (dy)nbttagcompound);
                    }
                    drops.add(CraftItemStack.asBukkitCopy(nmsStack));
                    continue;
                }
                if (ajn.by == block) {
                    int dropAmount = ajz.c((int)data) >= 2 ? 3 : 1;
                    for (int j = 0; j < dropAmount; ++j) {
                        drops.add(new ItemStack(Material.INK_SACK, 1, 3));
                    }
                    continue;
                }
                drops.add(new ItemStack(CraftMagicNumbers.getMaterial(item), 1, (short)block.a((int)data)));
            }
        }
        return drops;
    }

    @Override
    public Collection<ItemStack> getDrops(ItemStack item) {
        if (this.itemCausesDrops(item)) {
            return this.getDrops();
        }
        return Collections.emptyList();
    }

    @Override
    public void setMetadata(String metadataKey, MetadataValue newMetadataValue) {
        this.chunk.getCraftWorld().getBlockMetadata().setMetadata(this, metadataKey, newMetadataValue);
    }

    @Override
    public List<MetadataValue> getMetadata(String metadataKey) {
        return this.chunk.getCraftWorld().getBlockMetadata().getMetadata(this, metadataKey);
    }

    @Override
    public boolean hasMetadata(String metadataKey) {
        return this.chunk.getCraftWorld().getBlockMetadata().hasMetadata(this, metadataKey);
    }

    @Override
    public void removeMetadata(String metadataKey, Plugin owningPlugin) {
        this.chunk.getCraftWorld().getBlockMetadata().removeMetadata(this, metadataKey, owningPlugin);
    }
}

