/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_7_R4.inventory;

import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import org.apache.commons.lang.Validate;
import org.bukkit.Material;
import org.bukkit.configuration.serialization.ConfigurationSerializable;
import org.bukkit.configuration.serialization.DelegateDeserialization;
import org.bukkit.configuration.serialization.SerializableAs;
import org.bukkit.craftbukkit.v1_7_R4.Overridden;
import org.bukkit.craftbukkit.v1_7_R4.inventory.CraftItemFactory;
import org.bukkit.craftbukkit.v1_7_R4.inventory.CraftMetaBook;
import org.bukkit.craftbukkit.v1_7_R4.inventory.CraftMetaCharge;
import org.bukkit.craftbukkit.v1_7_R4.inventory.CraftMetaEnchantedBook;
import org.bukkit.craftbukkit.v1_7_R4.inventory.CraftMetaFirework;
import org.bukkit.craftbukkit.v1_7_R4.inventory.CraftMetaLeatherArmor;
import org.bukkit.craftbukkit.v1_7_R4.inventory.CraftMetaMap;
import org.bukkit.craftbukkit.v1_7_R4.inventory.CraftMetaPotion;
import org.bukkit.craftbukkit.v1_7_R4.inventory.CraftMetaSkull;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.Repairable;

@DelegateDeserialization(value=SerializableMeta.class)
class CraftMetaItem
implements ItemMeta,
Repairable {
    static final ItemMetaKey NAME = new ItemMetaKey("Name", "display-name");
    static final ItemMetaKey DISPLAY = new ItemMetaKey("display");
    static final ItemMetaKey LORE = new ItemMetaKey("Lore", "lore");
    static final ItemMetaKey ENCHANTMENTS = new ItemMetaKey("ench", "enchants");
    static final ItemMetaKey ENCHANTMENTS_ID = new ItemMetaKey("id");
    static final ItemMetaKey ENCHANTMENTS_LVL = new ItemMetaKey("lvl");
    static final ItemMetaKey REPAIR = new ItemMetaKey("RepairCost", "repair-cost");
    static final ItemMetaKey ATTRIBUTES = new ItemMetaKey("AttributeModifiers");
    static final ItemMetaKey ATTRIBUTES_IDENTIFIER = new ItemMetaKey("AttributeName");
    static final ItemMetaKey ATTRIBUTES_NAME = new ItemMetaKey("Name");
    static final ItemMetaKey ATTRIBUTES_VALUE = new ItemMetaKey("Amount");
    static final ItemMetaKey ATTRIBUTES_TYPE = new ItemMetaKey("Operation");
    static final ItemMetaKey ATTRIBUTES_UUID_HIGH = new ItemMetaKey("UUIDMost");
    static final ItemMetaKey ATTRIBUTES_UUID_LOW = new ItemMetaKey("UUIDLeast");
    private final dq attributes;
    private String displayName;
    private List<String> lore;
    private Map<Enchantment, Integer> enchantments;
    private int repairCost;

    CraftMetaItem(CraftMetaItem meta) {
        if (meta == null) {
            this.attributes = null;
            return;
        }
        this.displayName = meta.displayName;
        if (meta.hasLore()) {
            this.lore = new ArrayList<String>(meta.lore);
        }
        if (meta.hasEnchants()) {
            this.enchantments = new HashMap<Enchantment, Integer>(meta.enchantments);
        }
        this.repairCost = meta.repairCost;
        this.attributes = meta.attributes;
    }

    CraftMetaItem(dh tag) {
        if (tag.c(CraftMetaItem.DISPLAY.NBT)) {
            dh display = tag.m(CraftMetaItem.DISPLAY.NBT);
            if (display.c(CraftMetaItem.NAME.NBT)) {
                this.displayName = display.j(CraftMetaItem.NAME.NBT);
            }
            if (display.c(CraftMetaItem.LORE.NBT)) {
                dq list = display.c(CraftMetaItem.LORE.NBT, 8);
                this.lore = new ArrayList<String>(list.c());
                for (int index = 0; index < list.c(); ++index) {
                    String line = list.f(index);
                    this.lore.add(line);
                }
            }
        }
        this.enchantments = CraftMetaItem.buildEnchantments(tag, ENCHANTMENTS);
        if (tag.c(CraftMetaItem.REPAIR.NBT)) {
            this.repairCost = tag.f(CraftMetaItem.REPAIR.NBT);
        }
        if (tag.a(CraftMetaItem.ATTRIBUTES.NBT) instanceof dq) {
            dq save = null;
            dq nbttaglist = tag.c(CraftMetaItem.ATTRIBUTES.NBT, 10);
            for (int i = 0; i < nbttaglist.c(); ++i) {
                dh nbttagcompound;
                if (!(nbttaglist.b(i) instanceof dh) || !((nbttagcompound = nbttaglist.b(i)).a(CraftMetaItem.ATTRIBUTES_UUID_HIGH.NBT) instanceof dr) || !(nbttagcompound.a(CraftMetaItem.ATTRIBUTES_UUID_LOW.NBT) instanceof dr) || !(nbttagcompound.a(CraftMetaItem.ATTRIBUTES_IDENTIFIER.NBT) instanceof dx) || !CraftItemFactory.KNOWN_NBT_ATTRIBUTE_NAMES.contains(nbttagcompound.j(CraftMetaItem.ATTRIBUTES_IDENTIFIER.NBT)) || !(nbttagcompound.a(CraftMetaItem.ATTRIBUTES_NAME.NBT) instanceof dx) || nbttagcompound.j(CraftMetaItem.ATTRIBUTES_NAME.NBT).isEmpty() || !(nbttagcompound.a(CraftMetaItem.ATTRIBUTES_VALUE.NBT) instanceof dk) || !(nbttagcompound.a(CraftMetaItem.ATTRIBUTES_TYPE.NBT) instanceof dp) || nbttagcompound.f(CraftMetaItem.ATTRIBUTES_TYPE.NBT) < 0 || nbttagcompound.f(CraftMetaItem.ATTRIBUTES_TYPE.NBT) > 2) continue;
                if (save == null) {
                    save = new dq();
                }
                dh entry = new dh();
                entry.a(CraftMetaItem.ATTRIBUTES_UUID_HIGH.NBT, nbttagcompound.a(CraftMetaItem.ATTRIBUTES_UUID_HIGH.NBT));
                entry.a(CraftMetaItem.ATTRIBUTES_UUID_LOW.NBT, nbttagcompound.a(CraftMetaItem.ATTRIBUTES_UUID_LOW.NBT));
                entry.a(CraftMetaItem.ATTRIBUTES_IDENTIFIER.NBT, nbttagcompound.a(CraftMetaItem.ATTRIBUTES_IDENTIFIER.NBT));
                entry.a(CraftMetaItem.ATTRIBUTES_NAME.NBT, nbttagcompound.a(CraftMetaItem.ATTRIBUTES_NAME.NBT));
                entry.a(CraftMetaItem.ATTRIBUTES_VALUE.NBT, nbttagcompound.a(CraftMetaItem.ATTRIBUTES_VALUE.NBT));
                entry.a(CraftMetaItem.ATTRIBUTES_TYPE.NBT, nbttagcompound.a(CraftMetaItem.ATTRIBUTES_TYPE.NBT));
                save.a((dy)entry);
            }
            this.attributes = save;
        } else {
            this.attributes = null;
        }
    }

    CraftMetaItem(Map<String, Object> map) {
        this.setDisplayName(SerializableMeta.getString(map, CraftMetaItem.NAME.BUKKIT, true));
        Iterable lore = SerializableMeta.getObject(Iterable.class, map, CraftMetaItem.LORE.BUKKIT, true);
        if (lore != null) {
            this.lore = new ArrayList<String>();
            CraftMetaItem.safelyAdd(lore, this.lore, Integer.MAX_VALUE);
        }
        this.enchantments = CraftMetaItem.buildEnchantments(map, ENCHANTMENTS);
        Integer repairCost = SerializableMeta.getObject(Integer.class, map, CraftMetaItem.REPAIR.BUKKIT, true);
        if (repairCost != null) {
            this.setRepairCost(repairCost);
        }
        this.attributes = null;
    }

    static Map<Enchantment, Integer> buildEnchantments(dh tag, ItemMetaKey key) {
        if (!tag.c(key.NBT)) {
            return null;
        }
        dq ench = tag.c(key.NBT, 10);
        HashMap<Enchantment, Integer> enchantments = new HashMap<Enchantment, Integer>(ench.c());
        for (int i = 0; i < ench.c(); ++i) {
            int id = 0xFFFF & ench.b(i).e(CraftMetaItem.ENCHANTMENTS_ID.NBT);
            int level = 0xFFFF & ench.b(i).e(CraftMetaItem.ENCHANTMENTS_LVL.NBT);
            Enchantment inch = Enchantment.getById(id);
            if (inch == null) continue;
            enchantments.put(inch, level);
        }
        return enchantments;
    }

    static Map<Enchantment, Integer> buildEnchantments(Map<String, Object> map, ItemMetaKey key) {
        Map ench = SerializableMeta.getObject(Map.class, map, key.BUKKIT, true);
        if (ench == null) {
            return null;
        }
        HashMap<Enchantment, Integer> enchantments = new HashMap<Enchantment, Integer>(ench.size());
        for (Map.Entry entry : ench.entrySet()) {
            Enchantment enchantment = Enchantment.getByName(entry.getKey().toString());
            if (enchantment == null || !(entry.getValue() instanceof Integer)) continue;
            enchantments.put(enchantment, (Integer)entry.getValue());
        }
        return enchantments;
    }

    static dq createStringList(List<String> list) {
        if (list == null || list.isEmpty()) {
            return null;
        }
        dq tagList = new dq();
        for (String value : list) {
            tagList.a((dy)new dx(value));
        }
        return tagList;
    }

    static void applyEnchantments(Map<Enchantment, Integer> enchantments, dh tag, ItemMetaKey key) {
        if (enchantments == null) {
            return;
        }
        dq list = new dq();
        for (Map.Entry<Enchantment, Integer> entry : enchantments.entrySet()) {
            dh subtag = new dh();
            subtag.a(CraftMetaItem.ENCHANTMENTS_ID.NBT, (short)entry.getKey().getId());
            subtag.a(CraftMetaItem.ENCHANTMENTS_LVL.NBT, entry.getValue().shortValue());
            list.a((dy)subtag);
        }
        tag.a(key.NBT, (dy)list);
    }

    static void serializeEnchantments(Map<Enchantment, Integer> enchantments, ImmutableMap.Builder<String, Object> builder, ItemMetaKey key) {
        if (enchantments == null || enchantments.isEmpty()) {
            return;
        }
        ImmutableMap.Builder enchants = ImmutableMap.builder();
        for (Map.Entry<Enchantment, Integer> enchant : enchantments.entrySet()) {
            enchants.put((Object)enchant.getKey().getName(), (Object)enchant.getValue());
        }
        builder.put((Object)key.BUKKIT, (Object)enchants.build());
    }

    static void safelyAdd(Iterable<?> addFrom, Collection<String> addTo, int maxItemLength) {
        if (addFrom == null) {
            return;
        }
        for (Object object : addFrom) {
            if (!(object instanceof String)) {
                if (object != null) {
                    throw new IllegalArgumentException(addFrom + " cannot contain non-string " + object.getClass().getName());
                }
                addTo.add("");
                continue;
            }
            String page = object.toString();
            if (page.length() > maxItemLength) {
                page = page.substring(0, maxItemLength);
            }
            addTo.add(page);
        }
    }

    static boolean checkConflictingEnchants(Map<Enchantment, Integer> enchantments, Enchantment ench) {
        if (enchantments == null || enchantments.isEmpty()) {
            return false;
        }
        for (Enchantment enchant : enchantments.keySet()) {
            if (!enchant.conflictsWith(ench)) continue;
            return true;
        }
        return false;
    }

    @Overridden
    void applyToItem(dh itemTag) {
        if (this.hasDisplayName()) {
            this.setDisplayTag(itemTag, CraftMetaItem.NAME.NBT, (dy)new dx(this.displayName));
        }
        if (this.hasLore()) {
            this.setDisplayTag(itemTag, CraftMetaItem.LORE.NBT, (dy)CraftMetaItem.createStringList(this.lore));
        }
        CraftMetaItem.applyEnchantments(this.enchantments, itemTag, ENCHANTMENTS);
        if (this.hasRepairCost()) {
            itemTag.a(CraftMetaItem.REPAIR.NBT, this.repairCost);
        }
        if (this.attributes != null) {
            itemTag.a(CraftMetaItem.ATTRIBUTES.NBT, (dy)this.attributes);
        }
    }

    void setDisplayTag(dh tag, String key, dy value) {
        dh display = tag.m(CraftMetaItem.DISPLAY.NBT);
        if (!tag.c(CraftMetaItem.DISPLAY.NBT)) {
            tag.a(CraftMetaItem.DISPLAY.NBT, (dy)display);
        }
        display.a(key, value);
    }

    @Overridden
    boolean applicableTo(Material type) {
        return type != Material.AIR;
    }

    @Overridden
    boolean isEmpty() {
        return !this.hasDisplayName() && !this.hasEnchants() && !this.hasLore() && !this.hasAttributes() && !this.hasRepairCost();
    }

    @Override
    public String getDisplayName() {
        return this.displayName;
    }

    @Override
    public final void setDisplayName(String name) {
        this.displayName = name;
    }

    @Override
    public boolean hasDisplayName() {
        return !Strings.isNullOrEmpty((String)this.displayName);
    }

    @Override
    public boolean hasLore() {
        return this.lore != null && !this.lore.isEmpty();
    }

    public boolean hasAttributes() {
        return this.attributes != null;
    }

    @Override
    public boolean hasRepairCost() {
        return this.repairCost > 0;
    }

    @Override
    public boolean hasEnchant(Enchantment ench) {
        return this.hasEnchants() && this.enchantments.containsKey(ench);
    }

    @Override
    public int getEnchantLevel(Enchantment ench) {
        Integer level;
        Integer n = level = this.hasEnchants() ? this.enchantments.get(ench) : null;
        if (level == null) {
            return 0;
        }
        return level;
    }

    @Override
    public Map<Enchantment, Integer> getEnchants() {
        return this.hasEnchants() ? ImmutableMap.copyOf(this.enchantments) : ImmutableMap.of();
    }

    @Override
    public boolean addEnchant(Enchantment ench, int level, boolean ignoreRestrictions) {
        if (this.enchantments == null) {
            this.enchantments = new HashMap<Enchantment, Integer>(4);
        }
        if (ignoreRestrictions || level >= ench.getStartLevel() && level <= ench.getMaxLevel()) {
            Integer old = this.enchantments.put(ench, level);
            return old == null || old != level;
        }
        return false;
    }

    @Override
    public boolean removeEnchant(Enchantment ench) {
        boolean b2;
        boolean bl = b2 = this.hasEnchants() && this.enchantments.remove(ench) != null;
        if (this.enchantments != null && this.enchantments.isEmpty()) {
            this.enchantments = null;
        }
        return b2;
    }

    @Override
    public boolean hasEnchants() {
        return this.enchantments != null && !this.enchantments.isEmpty();
    }

    @Override
    public boolean hasConflictingEnchant(Enchantment ench) {
        return CraftMetaItem.checkConflictingEnchants(this.enchantments, ench);
    }

    @Override
    public List<String> getLore() {
        return this.lore == null ? null : new ArrayList<String>(this.lore);
    }

    @Override
    public void setLore(List<String> lore) {
        if (lore == null) {
            this.lore = null;
        } else if (this.lore == null) {
            this.lore = new ArrayList<String>(lore.size());
            CraftMetaItem.safelyAdd(lore, this.lore, Integer.MAX_VALUE);
        } else {
            this.lore.clear();
            CraftMetaItem.safelyAdd(lore, this.lore, Integer.MAX_VALUE);
        }
    }

    @Override
    public int getRepairCost() {
        return this.repairCost;
    }

    @Override
    public void setRepairCost(int cost) {
        this.repairCost = cost;
    }

    public final boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (object == this) {
            return true;
        }
        if (!(object instanceof CraftMetaItem)) {
            return false;
        }
        return CraftItemFactory.instance().equals((ItemMeta)this, (ItemMeta)object);
    }

    @Overridden
    boolean equalsCommon(CraftMetaItem that) {
        return (this.hasDisplayName() ? that.hasDisplayName() && this.displayName.equals(that.displayName) : !that.hasDisplayName()) && (this.hasEnchants() ? that.hasEnchants() && this.enchantments.equals(that.enchantments) : !that.hasEnchants()) && (this.hasLore() ? that.hasLore() && this.lore.equals(that.lore) : !that.hasLore()) && (this.hasAttributes() ? that.hasAttributes() && this.attributes.equals((Object)that.attributes) : !that.hasAttributes()) && (this.hasRepairCost() ? that.hasRepairCost() && this.repairCost == that.repairCost : !that.hasRepairCost());
    }

    @Overridden
    boolean notUncommon(CraftMetaItem meta) {
        return true;
    }

    public final int hashCode() {
        return this.applyHash();
    }

    @Overridden
    int applyHash() {
        int hash = 3;
        hash = 61 * hash + (this.hasDisplayName() ? this.displayName.hashCode() : 0);
        hash = 61 * hash + (this.hasLore() ? this.lore.hashCode() : 0);
        hash = 61 * hash + (this.hasEnchants() ? this.enchantments.hashCode() : 0);
        hash = 61 * hash + (this.hasAttributes() ? this.attributes.hashCode() : 0);
        hash = 61 * hash + (this.hasRepairCost() ? this.repairCost : 0);
        return hash;
    }

    @Override
    @Overridden
    public CraftMetaItem clone() {
        try {
            CraftMetaItem clone = (CraftMetaItem)super.clone();
            if (this.lore != null) {
                clone.lore = new ArrayList<String>(this.lore);
            }
            if (this.enchantments != null) {
                clone.enchantments = new HashMap<Enchantment, Integer>(this.enchantments);
            }
            return clone;
        }
        catch (CloneNotSupportedException e) {
            throw new Error(e);
        }
    }

    @Override
    public final Map<String, Object> serialize() {
        ImmutableMap.Builder map = ImmutableMap.builder();
        map.put((Object)"meta-type", SerializableMeta.classMap.get(this.getClass()));
        this.serialize((ImmutableMap.Builder<String, Object>)map);
        return map.build();
    }

    @Overridden
    ImmutableMap.Builder<String, Object> serialize(ImmutableMap.Builder<String, Object> builder) {
        if (this.hasDisplayName()) {
            builder.put((Object)CraftMetaItem.NAME.BUKKIT, (Object)this.displayName);
        }
        if (this.hasLore()) {
            builder.put((Object)CraftMetaItem.LORE.BUKKIT, (Object)ImmutableList.copyOf(this.lore));
        }
        CraftMetaItem.serializeEnchantments(this.enchantments, builder, ENCHANTMENTS);
        if (this.hasRepairCost()) {
            builder.put((Object)CraftMetaItem.REPAIR.BUKKIT, (Object)this.repairCost);
        }
        return builder;
    }

    public final String toString() {
        return (String)SerializableMeta.classMap.get(this.getClass()) + "_META:" + this.serialize();
    }

    @SerializableAs(value="ItemMeta")
    public static class SerializableMeta
    implements ConfigurationSerializable {
        static final String TYPE_FIELD = "meta-type";
        static final ImmutableMap<Class<? extends CraftMetaItem>, String> classMap = ImmutableMap.builder().put(CraftMetaBook.class, (Object)"BOOK").put(CraftMetaSkull.class, (Object)"SKULL").put(CraftMetaLeatherArmor.class, (Object)"LEATHER_ARMOR").put(CraftMetaMap.class, (Object)"MAP").put(CraftMetaPotion.class, (Object)"POTION").put(CraftMetaEnchantedBook.class, (Object)"ENCHANTED").put(CraftMetaFirework.class, (Object)"FIREWORK").put(CraftMetaCharge.class, (Object)"FIREWORK_EFFECT").put(CraftMetaItem.class, (Object)"UNSPECIFIC").build();
        static final ImmutableMap<String, Constructor<? extends CraftMetaItem>> constructorMap;

        private SerializableMeta() {
        }

        public static ItemMeta deserialize(Map<String, Object> map) throws Throwable {
            Validate.notNull(map, (String)"Cannot deserialize null map");
            String type = SerializableMeta.getString(map, TYPE_FIELD, false);
            Constructor constructor = (Constructor)constructorMap.get((Object)type);
            if (constructor == null) {
                throw new IllegalArgumentException(type + " is not a valid " + TYPE_FIELD);
            }
            try {
                return (ItemMeta)constructor.newInstance(map);
            }
            catch (InstantiationException e) {
                throw new AssertionError((Object)e);
            }
            catch (IllegalAccessException e) {
                throw new AssertionError((Object)e);
            }
            catch (InvocationTargetException e) {
                throw e.getCause();
            }
        }

        static String getString(Map<?, ?> map, Object field, boolean nullable) {
            return SerializableMeta.getObject(String.class, map, field, nullable);
        }

        static boolean getBoolean(Map<?, ?> map, Object field) {
            Boolean value = SerializableMeta.getObject(Boolean.class, map, field, true);
            return value != null && value != false;
        }

        static <T> T getObject(Class<T> clazz, Map<?, ?> map, Object field, boolean nullable) {
            Object object = map.get(field);
            if (clazz.isInstance(object)) {
                return clazz.cast(object);
            }
            if (object == null) {
                if (!nullable) {
                    throw new NoSuchElementException(map + " does not contain " + field);
                }
                return null;
            }
            throw new IllegalArgumentException(field + "(" + object + ") is not a valid " + clazz);
        }

        @Override
        public Map<String, Object> serialize() {
            throw new AssertionError();
        }

        static {
            ImmutableMap.Builder classConstructorBuilder = ImmutableMap.builder();
            for (Map.Entry mapping : classMap.entrySet()) {
                try {
                    classConstructorBuilder.put(mapping.getValue(), ((Class)mapping.getKey()).getDeclaredConstructor(Map.class));
                }
                catch (NoSuchMethodException e) {
                    throw new AssertionError((Object)e);
                }
            }
            constructorMap = classConstructorBuilder.build();
        }
    }

    static class ItemMetaKey {
        final String BUKKIT;
        final String NBT;

        ItemMetaKey(String both) {
            this(both, both);
        }

        ItemMetaKey(String nbt, String bukkit) {
            this.NBT = nbt;
            this.BUKKIT = bukkit;
        }

        @Retention(value=RetentionPolicy.SOURCE)
        @Target(value={ElementType.FIELD})
        static @interface Specific {
            public To value();

            public static enum To {
                BUKKIT,
                NBT;

            }
        }
    }
}

