/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_7_R4.map;

import java.util.UUID;
import net.minecraftforge.cauldron.command.CauldronCommand;
import org.bukkit.Bukkit;
import org.bukkit.craftbukkit.v1_7_R4.map.CraftMapView;
import org.bukkit.entity.Player;
import org.bukkit.map.MapCanvas;
import org.bukkit.map.MapCursorCollection;
import org.bukkit.map.MapRenderer;
import org.bukkit.map.MapView;

public class CraftMapRenderer
extends MapRenderer {
    private final ayi worldMap;

    public CraftMapRenderer(CraftMapView mapView, ayi worldMap) {
        super(false);
        this.worldMap = worldMap;
    }

    @Override
    public void render(MapView map, MapCanvas canvas, Player player) {
        if (CauldronCommand.debug) {
            System.out.println("Default Map Render called!");
            for (StackTraceElement ste : Thread.currentThread().getStackTrace()) {
                System.out.println(ste);
            }
        }
        for (int x = 0; x < 128; ++x) {
            for (int y2 = 0; y2 < 128; ++y2) {
                canvas.setPixel(x, y2, this.worldMap.e[y2 * 128 + x]);
            }
        }
        MapCursorCollection cursors = canvas.getCursors();
        while (cursors.size() > 0) {
            cursors.removeCursor(cursors.getCursor(0));
        }
        for (UUID key : this.worldMap.g.keySet()) {
            Player other = Bukkit.getPlayer(key);
            if (other != null && !player.canSee(other)) continue;
            ayk decoration = (ayk)this.worldMap.g.get(key);
            cursors.addCursor(decoration.b, decoration.c, (byte)(decoration.d & 0xF), decoration.a);
        }
    }
}

