/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_7_R4.scoreboard;

import com.google.common.collect.ImmutableSet;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang.Validate;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.craftbukkit.v1_7_R4.scoreboard.CraftCriteria;
import org.bukkit.craftbukkit.v1_7_R4.scoreboard.CraftObjective;
import org.bukkit.craftbukkit.v1_7_R4.scoreboard.CraftScoreboardTranslations;
import org.bukkit.craftbukkit.v1_7_R4.scoreboard.CraftTeam;
import org.bukkit.scoreboard.DisplaySlot;
import org.bukkit.scoreboard.Objective;
import org.bukkit.scoreboard.Score;
import org.bukkit.scoreboard.Scoreboard;
import org.bukkit.scoreboard.Team;

public final class CraftScoreboard
implements Scoreboard {
    final bac board;
    final Map<String, CraftObjective> objectives = new HashMap<String, CraftObjective>();
    final Map<String, CraftTeam> teams = new HashMap<String, CraftTeam>();

    CraftScoreboard(bac board) {
        this.board = board;
        for (azx objective : board.c()) {
            new CraftObjective(this, objective);
        }
        for (azy team : board.g()) {
            new CraftTeam(this, team);
        }
    }

    @Override
    public CraftObjective registerNewObjective(String name, String criteria) throws IllegalArgumentException {
        Validate.notNull((Object)name, (String)"Objective name cannot be null");
        Validate.notNull((Object)criteria, (String)"Criteria cannot be null");
        Validate.isTrue((name.length() <= 16 ? 1 : 0) != 0, (String)("The name '" + name + "' is longer than the limit of 16 characters"));
        Validate.isTrue((this.board.b(name) == null ? 1 : 0) != 0, (String)("An objective of name '" + name + "' already exists"));
        CraftCriteria craftCriteria = CraftCriteria.getFromBukkit(criteria);
        azx objective = this.board.a(name, craftCriteria.criteria);
        return new CraftObjective(this, objective);
    }

    @Override
    public Objective getObjective(String name) throws IllegalArgumentException {
        Validate.notNull((Object)name, (String)"Name cannot be null");
        return this.objectives.get(name);
    }

    public ImmutableSet<Objective> getObjectivesByCriteria(String criteria) throws IllegalArgumentException {
        Validate.notNull((Object)criteria, (String)"Criteria cannot be null");
        ImmutableSet.Builder objectives = ImmutableSet.builder();
        for (CraftObjective objective : this.objectives.values()) {
            if (!objective.getCriteria().equals(criteria)) continue;
            objectives.add((Object)objective);
        }
        return objectives.build();
    }

    public ImmutableSet<Objective> getObjectives() {
        return ImmutableSet.copyOf(this.objectives.values());
    }

    @Override
    public Objective getObjective(DisplaySlot slot) throws IllegalArgumentException {
        Validate.notNull((Object)((Object)slot), (String)"Display slot cannot be null");
        azx objective = this.board.a(CraftScoreboardTranslations.fromBukkitSlot(slot));
        if (objective == null) {
            return null;
        }
        return this.objectives.get(objective.b());
    }

    public ImmutableSet<Score> getScores(OfflinePlayer player) throws IllegalArgumentException {
        Validate.notNull((Object)player, (String)"OfflinePlayer cannot be null");
        ImmutableSet.Builder scores = ImmutableSet.builder();
        for (CraftObjective objective : this.objectives.values()) {
            scores.add((Object)objective.getScore(player));
        }
        return scores.build();
    }

    public ImmutableSet<Score> getScores(String entry) throws IllegalArgumentException {
        Validate.notNull((Object)entry, (String)"Entry cannot be null");
        ImmutableSet.Builder scores = ImmutableSet.builder();
        for (CraftObjective objective : this.objectives.values()) {
            scores.add((Object)objective.getScore(entry));
        }
        return scores.build();
    }

    @Override
    public void resetScores(OfflinePlayer player) throws IllegalArgumentException {
        Validate.notNull((Object)player, (String)"OfflinePlayer cannot be null");
        this.board.c(player.getName());
    }

    @Override
    public void resetScores(String entry) throws IllegalArgumentException {
        Validate.notNull((Object)entry, (String)"Entry cannot be null");
        this.board.c(entry);
    }

    @Override
    public Team getPlayerTeam(OfflinePlayer player) throws IllegalArgumentException {
        Validate.notNull((Object)player, (String)"OfflinePlayer cannot be null");
        azy team = this.board.i(player.getName());
        return team == null ? null : (Team)this.teams.get(team.b());
    }

    @Override
    public Team getTeam(String teamName) throws IllegalArgumentException {
        Validate.notNull((Object)teamName, (String)"Team name cannot be null");
        return this.teams.get(teamName);
    }

    public ImmutableSet<Team> getTeams() {
        return ImmutableSet.copyOf(this.teams.values());
    }

    @Override
    public Team registerNewTeam(String name) throws IllegalArgumentException {
        Validate.notNull((Object)name, (String)"Team name cannot be null");
        Validate.isTrue((name.length() <= 16 ? 1 : 0) != 0, (String)("Team name '" + name + "' is longer than the limit of 16 characters"));
        Validate.isTrue((this.board.e(name) == null ? 1 : 0) != 0, (String)("Team name '" + name + "' is already in use"));
        return new CraftTeam(this, this.board.f(name));
    }

    public ImmutableSet<OfflinePlayer> getPlayers() {
        ImmutableSet.Builder players = ImmutableSet.builder();
        for (Object playerName : this.board.d()) {
            players.add((Object)Bukkit.getOfflinePlayer(playerName.toString()));
        }
        return players.build();
    }

    public ImmutableSet<String> getEntries() {
        ImmutableSet.Builder entries = ImmutableSet.builder();
        for (Object entry : this.board.d()) {
            entries.add((Object)entry.toString());
        }
        return entries.build();
    }

    @Override
    public void clearSlot(DisplaySlot slot) throws IllegalArgumentException {
        Validate.notNull((Object)((Object)slot), (String)"Slot cannot be null");
        this.board.a(CraftScoreboardTranslations.fromBukkitSlot(slot), null);
    }

    public bac getHandle() {
        return this.board;
    }
}

