/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_7_R4.scoreboard;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import net.minecraft.server.MinecraftServer;
import org.apache.commons.lang.Validate;
import org.bukkit.craftbukkit.v1_7_R4.entity.CraftPlayer;
import org.bukkit.craftbukkit.v1_7_R4.scoreboard.CraftScoreboard;
import org.bukkit.craftbukkit.v1_7_R4.util.WeakCollection;
import org.bukkit.entity.Player;
import org.bukkit.scoreboard.Scoreboard;
import org.bukkit.scoreboard.ScoreboardManager;

public final class CraftScoreboardManager
implements ScoreboardManager {
    private final CraftScoreboard mainScoreboard;
    private final MinecraftServer server;
    private final Collection<CraftScoreboard> scoreboards = new WeakCollection<CraftScoreboard>();
    private final Map<CraftPlayer, CraftScoreboard> playerBoards = new HashMap<CraftPlayer, CraftScoreboard>();

    public CraftScoreboardManager(MinecraftServer minecraftserver, bac scoreboardServer) {
        this.mainScoreboard = new CraftScoreboard(scoreboardServer);
        this.server = minecraftserver;
        this.scoreboards.add(this.mainScoreboard);
    }

    @Override
    public CraftScoreboard getMainScoreboard() {
        return this.mainScoreboard;
    }

    @Override
    public CraftScoreboard getNewScoreboard() {
        if (Thread.currentThread() != MinecraftServer.I().primaryThread) {
            throw new IllegalStateException("Asynchronous scoreboard creation");
        }
        CraftScoreboard scoreboard = new CraftScoreboard((bac)new lp(this.server));
        this.scoreboards.add(scoreboard);
        return scoreboard;
    }

    public CraftScoreboard getPlayerBoard(CraftPlayer player) {
        CraftScoreboard board = this.playerBoards.get(player);
        return board == null ? this.getMainScoreboard() : board;
    }

    public void setPlayerBoard(CraftPlayer player, Scoreboard bukkitScoreboard) throws IllegalArgumentException {
        Validate.isTrue((boolean)(bukkitScoreboard instanceof CraftScoreboard), (String)"Cannot set player scoreboard to an unregistered Scoreboard");
        CraftScoreboard scoreboard = (CraftScoreboard)bukkitScoreboard;
        bac oldboard = this.getPlayerBoard(player).getHandle();
        bac newboard = scoreboard.getHandle();
        mw entityplayer = player.getHandle();
        if (oldboard == newboard) {
            return;
        }
        if (scoreboard == this.mainScoreboard) {
            this.playerBoards.remove(player);
        } else {
            this.playerBoards.put(player, scoreboard);
        }
        HashSet<azx> removed = new HashSet<azx>();
        for (int i = 0; i < 3; ++i) {
            azx scoreboardobjective = oldboard.a(i);
            if (scoreboardobjective == null || removed.contains(scoreboardobjective)) continue;
            entityplayer.a.a((ft)new ic(scoreboardobjective, 1));
            removed.add(scoreboardobjective);
        }
        for (azy scoreboardteam : oldboard.g()) {
            entityplayer.a.a((ft)new id(scoreboardteam, 1));
        }
        this.server.ah().a((lp)newboard, player.getHandle());
    }

    public void removePlayer(Player player) {
        this.playerBoards.remove(player);
    }

    public Collection<azz> getScoreboardScores(bah criteria, String name, Collection<azz> collection) {
        for (CraftScoreboard scoreboard : this.scoreboards) {
            bac board = scoreboard.board;
            for (azx objective : board.a(criteria)) {
                collection.add(board.a(name, objective));
            }
        }
        return collection;
    }

    public void updateAllScoresForList(bah criteria, String name, List<mw> of) {
        for (azz score : this.getScoreboardScores(criteria, name, new ArrayList<azz>())) {
            score.a(of);
        }
    }
}

