/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_7_R4.util;

import com.mojang.util.QueueLogAppender;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.reflect.Field;
import java.util.Map;
import java.util.concurrent.BlockingQueue;
import java.util.logging.Level;
import java.util.logging.Logger;
import jline.console.ConsoleReader;
import net.minecraft.server.MinecraftServer;

public class TerminalConsoleWriterThread
implements Runnable {
    private final ConsoleReader reader;
    private final OutputStream output;

    public TerminalConsoleWriterThread(OutputStream output, ConsoleReader reader) {
        this.output = output;
        this.reader = reader;
        try {
            Field queues = QueueLogAppender.class.getDeclaredField("QUEUES");
            queues.setAccessible(true);
            Map instance = (Map)queues.get(null);
            ((BlockingQueue)instance.get("TerminalConsole")).clear();
        }
        catch (ReflectiveOperationException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void run() {
        while (true) {
            String message;
            if ((message = QueueLogAppender.getNextLogEvent((String)"TerminalConsole")) == null) {
                Thread.yield();
                continue;
            }
            try {
                if (MinecraftServer.useJline) {
                    this.reader.print((CharSequence)"\r");
                    this.reader.flush();
                    this.output.write(message.getBytes());
                    this.output.flush();
                    try {
                        this.reader.drawLine();
                    }
                    catch (Throwable ex) {
                        this.reader.getCursorBuffer().clear();
                    }
                    this.reader.flush();
                    continue;
                }
                this.output.write(message.getBytes());
                this.output.flush();
                continue;
            }
            catch (IOException ex) {
                Logger.getLogger(TerminalConsoleWriterThread.class.getName()).log(Level.SEVERE, null, ex);
                continue;
            }
            break;
        }
    }
}

