/*
 * Decompiled with CFR 0.152.
 */
package co.aikar.timings;

import co.aikar.timings.NullTimingHandler;
import co.aikar.timings.Timing;
import co.aikar.timings.Timings;
import co.aikar.timings.TimingsManager;
import com.google.common.collect.MapMaker;
import java.util.Map;
import org.bukkit.craftbukkit.v1_7_R4.scheduler.CraftTask;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitTask;

public final class MinecraftTimings {
    public static final Timing serverOversleep = Timings.ofSafe("Server Oversleep");
    public static final Timing playerListTimer = Timings.ofSafe("Player List");
    public static final Timing commandFunctionsTimer = Timings.ofSafe("Command Functions");
    public static final Timing connectionTimer = Timings.ofSafe("Connection Handler");
    public static final Timing tickablesTimer = Timings.ofSafe("Tickables");
    public static final Timing minecraftSchedulerTimer = Timings.ofSafe("Minecraft Scheduler");
    public static final Timing bukkitSchedulerTimer = Timings.ofSafe("Bukkit Scheduler");
    public static final Timing bukkitSchedulerPendingTimer = Timings.ofSafe("Bukkit Scheduler - Pending");
    public static final Timing bukkitSchedulerFinishTimer = Timings.ofSafe("Bukkit Scheduler - Finishing");
    public static final Timing chunkIOTickTimer = Timings.ofSafe("ChunkIOTick");
    public static final Timing timeUpdateTimer = Timings.ofSafe("Time Update");
    public static final Timing serverCommandTimer = Timings.ofSafe("Server Command");
    public static final Timing savePlayers = Timings.ofSafe("Save Players");
    public static final Timing tickEntityTimer = Timings.ofSafe("## tickEntity");
    public static final Timing tickTileEntityTimer = Timings.ofSafe("## tickTileEntity");
    public static final Timing packetProcessTimer = Timings.ofSafe("## Packet Processing");
    public static final Timing scheduledBlocksTimer = Timings.ofSafe("## Scheduled Blocks");
    public static final Timing structureGenerationTimer = Timings.ofSafe("Structure Generation");
    public static final Timing processQueueTimer = Timings.ofSafe("processQueue");
    public static final Timing processTasksTimer = Timings.ofSafe("processTasks");
    public static final Timing playerCommandTimer = Timings.ofSafe("playerCommand");
    public static final Timing entityActivationCheckTimer = Timings.ofSafe("entityActivationCheck");
    public static final Timing antiXrayUpdateTimer = Timings.ofSafe("anti-xray - update");
    public static final Timing antiXrayObfuscateTimer = Timings.ofSafe("anti-xray - obfuscate");
    public static final Timing entityMoveTimer = Timings.ofSafe("## entityMove");
    public static final Timing timerEntityBaseTick = Timings.ofSafe("## livingEntityBaseTick");
    public static final Timing timerEntityAI = Timings.ofSafe("## livingEntityAI");
    public static final Timing timerEntityAICollision = Timings.ofSafe("## livingEntityAICollision");
    public static final Timing timerEntityAIMove = Timings.ofSafe("## livingEntityAIMove");
    public static final Timing timerEntityTickRest = Timings.ofSafe("## livingEntityTickRest");
    private static final Map<Class<?>, String> taskNameCache = new MapMaker().weakKeys().makeMap();

    private MinecraftTimings() {
    }

    public static Timing getPluginTaskTimings(BukkitTask bukkitTask, long period) {
        if (!bukkitTask.isSync()) {
            return NullTimingHandler.NULL;
        }
        CraftTask craftTask = (CraftTask)bukkitTask;
        Class<? extends Runnable> taskClass = craftTask.getTaskClass();
        Plugin plugin = bukkitTask.getOwner() != null ? bukkitTask.getOwner() : TimingsManager.getPluginByClassloader(taskClass);
        String taskname = taskNameCache.computeIfAbsent(taskClass, clazz -> {
            try {
                return clazz.isAnonymousClass() || clazz.isLocalClass() ? clazz.getName() : clazz.getCanonicalName();
            }
            catch (Throwable ex) {
                new Exception("Error occurred detecting class name", ex).printStackTrace();
                return "MangledClassFile";
            }
        });
        StringBuilder name = new StringBuilder(64);
        name.append("Task: ").append(taskname);
        if (period > 0L) {
            name.append(" (interval:").append(period).append(")");
        } else {
            name.append(" (Single)");
        }
        if (plugin == null) {
            return Timings.ofSafe(null, name.toString());
        }
        return Timings.ofSafe(plugin, name.toString());
    }

    public static Timing getEntityTimings(sa entity) {
        String entityType = entity.getClass().getName();
        return Timings.ofSafe("Minecraft", "## tickEntity - " + entityType, tickEntityTimer);
    }

    public static Timing getTileEntityTimings(aor entity) {
        String entityType = entity.getClass().getName();
        return Timings.ofSafe("Minecraft", "## tickTileEntity - " + entityType, tickTileEntityTimer);
    }

    public static Timing getTileEntityPersonalTimings(aor entity, Timing tileClassTiming) {
        return Timings.ofSafe("Minecraft", "## !tileSpawnedAt - [world=" + entity.b.M().g() + ", x=" + entity.c + ", y=" + entity.d + ", z=" + entity.e + "]", tileClassTiming);
    }

    public static Timing getCancelTasksTimer() {
        return Timings.ofSafe("Cancel Tasks");
    }

    public static Timing getCancelTasksTimer(Plugin plugin) {
        return Timings.ofSafe(plugin, "Cancel Tasks");
    }

    public static void stopServer() {
        TimingsManager.stopServer();
    }

    public static Timing getBlockTiming(aji block) {
        return Timings.ofSafe("## Scheduled Block: " + block.toString(), scheduledBlocksTimer);
    }

    public static Timing getPacketTiming(ft packet) {
        return Timings.ofSafe("## Packet - " + packet.getClass().getSimpleName(), packetProcessTimer);
    }
}

