/*
 * Decompiled with CFR 0.152.
 */
package co.aikar.timings;

import co.aikar.timings.TimedTimings;
import co.aikar.timings.Timings;
import co.aikar.timings.TimingsExport;
import co.aikar.timings.TimingsManager;
import com.google.common.collect.ImmutableList;
import io.github.crucible.CrucibleConfigs;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang.Validate;
import org.bukkit.ChatColor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.defaults.BukkitCommand;
import org.bukkit.util.StringUtil;
import org.jetbrains.annotations.NotNull;

public class TimingsCommand
extends BukkitCommand {
    private static final List<String> TIMINGS_SUBCOMMANDS = ImmutableList.of((Object)"report", (Object)"reset", (Object)"on", (Object)"off", (Object)"paste", (Object)"verbon", (Object)"verboff", (Object)"timed", (Object)"timedverbose");
    private long lastResetAttempt = 0L;
    public static final String PERMISSION_NODE = "bukkit.command.timings";
    private SimpleDateFormat sdf = new SimpleDateFormat("MM/dd/yyyy HH:mm");

    private String getFormatedDate(Long millis) {
        Date date = new Date(millis);
        return this.sdf.format(date);
    }

    public TimingsCommand(@NotNull String name) {
        super(name);
        this.description = "Manages Spigot Timings data to see performance of the server.";
        this.usageMessage = "/timings <reset|report|on|off|verbon|verboff|timed>";
        this.setPermission(PERMISSION_NODE);
    }

    @Override
    public boolean execute(@NotNull CommandSender sender, @NotNull String currentAlias, @NotNull String[] args) {
        if (!this.testPermission(sender)) {
            return true;
        }
        String arg = args.length > 0 ? args[0] : "";
        TimedTimings timedTimings = TimedTimings.getCurrentTimedTimings();
        if (timedTimings != null) {
            if (arg.equalsIgnoreCase("stop")) {
                TimedTimings.interruptCurrent();
                sender.sendMessage((Object)((Object)ChatColor.RED) + " TimedTimings has stoped!");
                return true;
            }
            if (arg.equalsIgnoreCase("off")) {
                TimedTimings.interruptCurrent();
                Timings.setTimingsEnabled(false);
                sender.sendMessage((Object)((Object)ChatColor.RED) + " TimedTimings and the TimingsProfiller has stoped");
                return true;
            }
            if (arg.equalsIgnoreCase("stats")) {
                sender.sendMessage(ChatColor.translateAlternateColorCodes('&', "&a&l Timings Stats"));
                sender.sendMessage(ChatColor.translateAlternateColorCodes('&', "&2   Start Time: &e" + this.getFormatedDate(TimingsManager.timingStart)));
                sender.sendMessage(ChatColor.translateAlternateColorCodes('&', "&2   End Time: &e" + this.getFormatedDate(timedTimings.getEndTime())));
                sender.sendMessage(ChatColor.translateAlternateColorCodes('&', "&2   Time Remaining: &3" + timedTimings.getSecondsTillEnds() + " seconds."));
                sender.sendMessage(ChatColor.translateAlternateColorCodes('&', "&2   Verbose: &3" + Timings.verboseEnabled));
                sender.sendMessage(ChatColor.translateAlternateColorCodes('&', "&2   Ultra-Verbose: &3" + CrucibleConfigs.configs.timings_ultraverbose_enabled));
                return true;
            }
            if (arg.equalsIgnoreCase("cost")) {
                sender.sendMessage("Timings cost: " + TimingsExport.getCost());
                return true;
            }
            sender.sendMessage((Object)((Object)ChatColor.DARK_BLUE) + "There is a timed-timings running!");
            sender.sendMessage(ChatColor.translateAlternateColorCodes('&', "&c  - &e" + currentAlias + " stop &7- &aStop the timed-paste, but not the profiller."));
            sender.sendMessage(ChatColor.translateAlternateColorCodes('&', "&c  - &e" + currentAlias + " off &7- &aStop the timed-paste and the profiller."));
            sender.sendMessage(ChatColor.translateAlternateColorCodes('&', "&c  - &e" + currentAlias + " stats &7- &aGet time until paste."));
            return true;
        }
        if (arg.isEmpty()) {
            this.sendHelp(sender, currentAlias, args);
            return true;
        }
        if (arg.equalsIgnoreCase("stats")) {
            sender.sendMessage(ChatColor.translateAlternateColorCodes('&', "&a&l Timings Stats"));
            if (Timings.timingsEnabled) {
                sender.sendMessage(ChatColor.translateAlternateColorCodes('&', "&2   Enabled Since: &e" + this.getFormatedDate(TimingsManager.timingStart)));
            } else {
                sender.sendMessage(ChatColor.translateAlternateColorCodes('&', "&c   Not enabled!"));
            }
            sender.sendMessage(ChatColor.translateAlternateColorCodes('&', "&2   Verbose: &3" + Timings.verboseEnabled));
            sender.sendMessage(ChatColor.translateAlternateColorCodes('&', "&2   Ultra-Verbose: &3" + CrucibleConfigs.configs.timings_ultraverbose_enabled));
            return true;
        }
        if ("on".equalsIgnoreCase(arg)) {
            Timings.setTimingsEnabled(true);
            sender.sendMessage("Enabled Timings & Reset");
            return true;
        }
        if ("off".equalsIgnoreCase(arg)) {
            Timings.setTimingsEnabled(false);
            sender.sendMessage("Disabled Timings");
            return true;
        }
        if ("timed".equalsIgnoreCase(arg) || "timeout".equalsIgnoreCase(arg) || "timedverbose".equalsIgnoreCase(arg) || "timeoutverbose".equalsIgnoreCase(arg)) {
            this.timedTimings(sender, currentAlias, args);
            return true;
        }
        if (!Timings.isTimingsEnabled()) {
            sender.sendMessage("Please enable timings by typing /timings on");
            return true;
        }
        if ("verbon".equalsIgnoreCase(arg)) {
            Timings.setVerboseTimingsEnabled(true);
            sender.sendMessage("Enabled Verbose Timings");
            return true;
        }
        if ("verboff".equalsIgnoreCase(arg)) {
            Timings.setVerboseTimingsEnabled(false);
            sender.sendMessage("Disabled Verbose Timings");
            return true;
        }
        if ("ultraverbon".equalsIgnoreCase(arg)) {
            CrucibleConfigs.configs.timings_ultraverbose_enabled = true;
            Timings.setVerboseTimingsEnabled(true);
            sender.sendMessage("Enabled Ultra-Verbose Timings");
            return true;
        }
        if ("ultraverboff".equalsIgnoreCase(arg)) {
            CrucibleConfigs.configs.timings_ultraverbose_enabled = false;
            sender.sendMessage("Disabled Ultra-Verbose Timings");
            return true;
        }
        if ("reset".equalsIgnoreCase(arg)) {
            long now = System.currentTimeMillis();
            if (now - this.lastResetAttempt < 30000L) {
                TimingsManager.reset();
                sender.sendMessage((Object)((Object)ChatColor.RED) + "Timings reset. Please wait 5-10 minutes before using /timings report.");
            } else {
                this.lastResetAttempt = now;
                sender.sendMessage((Object)((Object)ChatColor.RED) + "WARNING: Timings v2 should not be reset. If you are encountering lag, please wait 3 minutes and then issue a report. The best timings will include 10+ minutes, with data before and after your lag period. If you really want to reset, run this command again within 30 seconds.");
            }
        } else if ("cost".equals(arg)) {
            sender.sendMessage("Timings cost: " + TimingsExport.getCost());
        } else if ("paste".equalsIgnoreCase(arg) || "report".equalsIgnoreCase(arg) || "get".equalsIgnoreCase(arg) || "merged".equalsIgnoreCase(arg) || "separate".equalsIgnoreCase(arg)) {
            Timings.generateReport(sender);
        } else {
            this.sendHelp(sender, currentAlias, args);
        }
        return true;
    }

    private void timedTimings(@NotNull CommandSender sender, @NotNull String currentAlias, @NotNull String[] args) {
        Integer secondsToWait;
        if (args.length < 2) {
            sender.sendMessage(ChatColor.translateAlternateColorCodes('&', "&c  - &e" + currentAlias + " " + args[0] + " <seconds>"));
            return;
        }
        try {
            secondsToWait = Integer.parseInt(args[1]);
            if (secondsToWait <= 0) {
                sender.sendMessage((Object)((Object)ChatColor.RED) + "The <seconds> must be an integer positive!");
                return;
            }
        }
        catch (Exception e) {
            sender.sendMessage((Object)((Object)ChatColor.RED) + "Invalid args, please specify a number!");
            sender.sendMessage(ChatColor.translateAlternateColorCodes('&', "&c  - &e" + currentAlias + " " + args[0] + " <seconds>"));
            return;
        }
        TimedTimings.scheduleTimedTimings(secondsToWait);
        sender.sendMessage((Object)((Object)ChatColor.GREEN) + "Timings Scheduled!" + (Object)((Object)ChatColor.DARK_GREEN) + " It will be pasted in " + (Object)((Object)ChatColor.YELLOW) + secondsToWait + (Object)((Object)ChatColor.DARK_GREEN) + " seconds!");
    }

    private void sendHelp(@NotNull CommandSender sender, @NotNull String currentAlias, @NotNull String[] args) {
        sender.sendMessage(ChatColor.translateAlternateColorCodes('&', "&c&m-----------------&c( &aTimings V.2 &7&oCrucible &c)&m-----------------"));
        sender.sendMessage(ChatColor.translateAlternateColorCodes('&', "&c  - &e" + currentAlias + " on &7- &aStart timings profiller."));
        sender.sendMessage(ChatColor.translateAlternateColorCodes('&', "&c  - &e" + currentAlias + " paste &7- &aPaste current timings profiller."));
        sender.sendMessage(ChatColor.translateAlternateColorCodes('&', "&c  - &e" + currentAlias + " reset &7- &aReset current timings profiller."));
        sender.sendMessage(ChatColor.translateAlternateColorCodes('&', "&c  - &e" + currentAlias + " verbon &7- &aVerbose On. &7&otinyurl.com/wtf-is-verbose"));
        sender.sendMessage(ChatColor.translateAlternateColorCodes('&', "&c  - &e" + currentAlias + " verboff &7- &aVerbose Off. &7&otinyurl.com/wtf-is-verbose"));
        sender.sendMessage(ChatColor.translateAlternateColorCodes('&', "&c  - &e" + currentAlias + " ultraverbon &7- &aUltraVerbose On. (Show tiles data)"));
        sender.sendMessage(ChatColor.translateAlternateColorCodes('&', "&c  - &e" + currentAlias + " ultraverboff &7- &aUltraVerbose Off"));
        sender.sendMessage(ChatColor.translateAlternateColorCodes('&', "&c  - &e" + currentAlias + " off &7- &aStop timings profiller."));
        sender.sendMessage(ChatColor.translateAlternateColorCodes('&', "&c  - &e" + currentAlias + " timed <seconds> &7- &aStart, then paste, then stop."));
    }

    @Override
    @NotNull
    public List<String> tabComplete(@NotNull CommandSender sender, @NotNull String alias, @NotNull String[] args) {
        Validate.notNull((Object)sender, (String)"Sender cannot be null");
        Validate.notNull((Object)args, (String)"Arguments cannot be null");
        Validate.notNull((Object)alias, (String)"Alias cannot be null");
        if (args.length == 1) {
            return StringUtil.copyPartialMatches(args[0], TIMINGS_SUBCOMMANDS, new ArrayList(TIMINGS_SUBCOMMANDS.size()));
        }
        return ImmutableList.of();
    }
}

