/*
 * Decompiled with CFR 0.152.
 */
package co.aikar.util;

import java.util.AbstractMap;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MRUMapCache<K, V>
extends AbstractMap<K, V> {
    final Map<K, V> backingMap;
    Object cacheKey;
    V cacheValue;

    public MRUMapCache(@NotNull Map<K, V> backingMap) {
        this.backingMap = backingMap;
    }

    @Override
    public int size() {
        return this.backingMap.size();
    }

    @Override
    public boolean isEmpty() {
        return this.backingMap.isEmpty();
    }

    @Override
    public boolean containsKey(@Nullable Object key) {
        return key != null && key.equals(this.cacheKey) || this.backingMap.containsKey(key);
    }

    @Override
    public boolean containsValue(@Nullable Object value) {
        return value != null && value == this.cacheValue || this.backingMap.containsValue(value);
    }

    @Override
    @Nullable
    public V get(@Nullable Object key) {
        if (this.cacheKey != null && this.cacheKey.equals(key)) {
            return this.cacheValue;
        }
        this.cacheKey = key;
        this.cacheValue = this.backingMap.get(key);
        return this.cacheValue;
    }

    @Override
    @Nullable
    public V put(@Nullable K key, @Nullable V value) {
        this.cacheKey = key;
        this.cacheValue = this.backingMap.put(key, value);
        return this.cacheValue;
    }

    @Override
    @Nullable
    public V remove(@Nullable Object key) {
        if (key != null && key.equals(this.cacheKey)) {
            this.cacheKey = null;
        }
        return this.backingMap.remove(key);
    }

    @Override
    public void putAll(@NotNull Map<? extends K, ? extends V> m) {
        this.backingMap.putAll(m);
    }

    @Override
    public void clear() {
        this.cacheKey = null;
        this.cacheValue = null;
        this.backingMap.clear();
    }

    @Override
    @NotNull
    public Set<K> keySet() {
        return this.backingMap.keySet();
    }

    @Override
    @NotNull
    public Collection<V> values() {
        return this.backingMap.values();
    }

    @Override
    @NotNull
    public Set<Map.Entry<K, V>> entrySet() {
        return this.backingMap.entrySet();
    }

    @NotNull
    public static <K, V> Map<K, V> of(@NotNull Map<K, V> map) {
        return new MRUMapCache<K, V>(map);
    }
}

