/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.collect;

import com.google.common.annotations.GwtCompatible;
import com.google.common.base.Preconditions;
import com.google.common.collect.AbstractMultimap;
import com.google.common.collect.Iterators;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.google.common.collect.Multimaps;
import com.google.common.collect.Multiset;
import com.google.common.collect.SetMultimap;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;

@GwtCompatible
abstract class AbstractMultimap<K, V>
implements Multimap<K, V> {
    private transient Collection<Map.Entry<K, V>> entries;
    private transient Set<K> keySet;
    private transient Multiset<K> keys;
    private transient Collection<V> values;
    private transient Map<K, Collection<V>> asMap;

    AbstractMultimap() {
    }

    public boolean isEmpty() {
        return this.size() == 0;
    }

    public boolean containsValue(@Nullable Object value) {
        for (Collection collection : this.asMap().values()) {
            if (!collection.contains(value)) continue;
            return true;
        }
        return false;
    }

    public boolean containsEntry(@Nullable Object key, @Nullable Object value) {
        Collection collection = (Collection)this.asMap().get(key);
        return collection != null && collection.contains(value);
    }

    public boolean remove(@Nullable Object key, @Nullable Object value) {
        Collection collection = (Collection)this.asMap().get(key);
        return collection != null && collection.remove(value);
    }

    public boolean put(@Nullable K key, @Nullable V value) {
        return this.get(key).add(value);
    }

    public boolean putAll(@Nullable K key, Iterable<? extends V> values) {
        Preconditions.checkNotNull(values);
        if (values instanceof Collection) {
            Collection valueCollection = (Collection)values;
            return !valueCollection.isEmpty() && this.get(key).addAll(valueCollection);
        }
        Iterator<V> valueItr = values.iterator();
        return valueItr.hasNext() && Iterators.addAll((Collection)this.get(key), valueItr);
    }

    public boolean putAll(Multimap<? extends K, ? extends V> multimap) {
        boolean changed = false;
        for (Map.Entry entry : multimap.entries()) {
            changed |= this.put(entry.getKey(), entry.getValue());
        }
        return changed;
    }

    public Collection<V> replaceValues(@Nullable K key, Iterable<? extends V> values) {
        Preconditions.checkNotNull(values);
        Collection result = this.removeAll(key);
        this.putAll(key, values);
        return result;
    }

    public Collection<Map.Entry<K, V>> entries() {
        Collection result = this.entries;
        return result == null ? (this.entries = this.createEntries()) : result;
    }

    Collection<Map.Entry<K, V>> createEntries() {
        if (this instanceof SetMultimap) {
            return new EntrySet(this, null);
        }
        return new Entries(this, null);
    }

    abstract Iterator<Map.Entry<K, V>> entryIterator();

    public Set<K> keySet() {
        Set result = this.keySet;
        return result == null ? (this.keySet = this.createKeySet()) : result;
    }

    Set<K> createKeySet() {
        return new Maps.KeySet(this.asMap());
    }

    public Multiset<K> keys() {
        Multiset result = this.keys;
        return result == null ? (this.keys = this.createKeys()) : result;
    }

    Multiset<K> createKeys() {
        return new Multimaps.Keys((Multimap)this);
    }

    public Collection<V> values() {
        Collection result = this.values;
        return result == null ? (this.values = this.createValues()) : result;
    }

    Collection<V> createValues() {
        return new Values(this);
    }

    Iterator<V> valueIterator() {
        return Maps.valueIterator(this.entries().iterator());
    }

    public Map<K, Collection<V>> asMap() {
        Map result = this.asMap;
        return result == null ? (this.asMap = this.createAsMap()) : result;
    }

    abstract Map<K, Collection<V>> createAsMap();

    public boolean equals(@Nullable Object object) {
        return Multimaps.equalsImpl((Multimap)this, (Object)object);
    }

    public int hashCode() {
        return this.asMap().hashCode();
    }

    public String toString() {
        return this.asMap().toString();
    }
}

