/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.collect;

import com.google.common.collect.Range;
import com.google.common.collect.RangeSet;
import javax.annotation.Nullable;

abstract class AbstractRangeSet<C extends Comparable>
implements RangeSet<C> {
    AbstractRangeSet() {
    }

    public boolean contains(C value) {
        return this.rangeContaining(value) != null;
    }

    public abstract Range<C> rangeContaining(C var1);

    public boolean isEmpty() {
        return this.asRanges().isEmpty();
    }

    public void add(Range<C> range) {
        throw new UnsupportedOperationException();
    }

    public void remove(Range<C> range) {
        throw new UnsupportedOperationException();
    }

    public void clear() {
        this.remove(Range.all());
    }

    public boolean enclosesAll(RangeSet<C> other) {
        for (Range range : other.asRanges()) {
            if (this.encloses(range)) continue;
            return false;
        }
        return true;
    }

    public void addAll(RangeSet<C> other) {
        for (Range range : other.asRanges()) {
            this.add(range);
        }
    }

    public void removeAll(RangeSet<C> other) {
        for (Range range : other.asRanges()) {
            this.remove(range);
        }
    }

    public abstract boolean encloses(Range<C> var1);

    public boolean equals(@Nullable Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof RangeSet) {
            RangeSet other = (RangeSet)obj;
            return this.asRanges().equals(other.asRanges());
        }
        return false;
    }

    public final int hashCode() {
        return this.asRanges().hashCode();
    }

    public final String toString() {
        return this.asRanges().toString();
    }
}

