/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.collect;

import com.google.common.annotations.GwtCompatible;
import com.google.common.collect.Constraint;
import com.google.common.collect.Constraints;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.ListIterator;
import java.util.RandomAccess;
import java.util.Set;
import java.util.SortedSet;

/*
 * Exception performing whole class analysis ignored.
 */
@GwtCompatible
final class Constraints {
    private Constraints() {
    }

    public static <E> Collection<E> constrainedCollection(Collection<E> collection, Constraint<? super E> constraint) {
        return new ConstrainedCollection(collection, constraint);
    }

    public static <E> Set<E> constrainedSet(Set<E> set, Constraint<? super E> constraint) {
        return new ConstrainedSet(set, constraint);
    }

    public static <E> SortedSet<E> constrainedSortedSet(SortedSet<E> sortedSet, Constraint<? super E> constraint) {
        return new ConstrainedSortedSet(sortedSet, constraint);
    }

    public static <E> List<E> constrainedList(List<E> list, Constraint<? super E> constraint) {
        return list instanceof RandomAccess ? new ConstrainedRandomAccessList(list, constraint) : new ConstrainedList(list, constraint);
    }

    private static <E> ListIterator<E> constrainedListIterator(ListIterator<E> listIterator, Constraint<? super E> constraint) {
        return new ConstrainedListIterator(listIterator, constraint);
    }

    static <E> Collection<E> constrainedTypePreservingCollection(Collection<E> collection, Constraint<E> constraint) {
        if (collection instanceof SortedSet) {
            return Constraints.constrainedSortedSet((SortedSet)((SortedSet)collection), constraint);
        }
        if (collection instanceof Set) {
            return Constraints.constrainedSet((Set)((Set)collection), constraint);
        }
        if (collection instanceof List) {
            return Constraints.constrainedList((List)((List)collection), constraint);
        }
        return Constraints.constrainedCollection(collection, constraint);
    }

    private static <E> Collection<E> checkElements(Collection<E> elements, Constraint<? super E> constraint) {
        ArrayList copy = Lists.newArrayList(elements);
        for (Object element : copy) {
            constraint.checkElement(element);
        }
        return copy;
    }

    static /* synthetic */ Collection access$000(Collection x0, Constraint x1) {
        return Constraints.checkElements((Collection)x0, (Constraint)x1);
    }

    static /* synthetic */ ListIterator access$100(ListIterator x0, Constraint x1) {
        return Constraints.constrainedListIterator((ListIterator)x0, (Constraint)x1);
    }
}

