/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.eventbus;

import com.google.common.base.Throwables;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.google.common.eventbus.AllowConcurrentEvents;
import com.google.common.eventbus.AnnotatedSubscriberFinder;
import com.google.common.eventbus.EventSubscriber;
import com.google.common.eventbus.Subscribe;
import com.google.common.eventbus.SubscriberFindingStrategy;
import com.google.common.eventbus.SynchronizedEventSubscriber;
import com.google.common.reflect.TypeToken;
import com.google.common.util.concurrent.UncheckedExecutionException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Set;

/*
 * Exception performing whole class analysis ignored.
 */
class AnnotatedSubscriberFinder
implements SubscriberFindingStrategy {
    private static final LoadingCache<Class<?>, ImmutableList<Method>> subscriberMethodsCache = CacheBuilder.newBuilder().weakKeys().build((CacheLoader)new /* Unavailable Anonymous Inner Class!! */);

    AnnotatedSubscriberFinder() {
    }

    public Multimap<Class<?>, EventSubscriber> findAllSubscribers(Object listener) {
        HashMultimap methodsInListener = HashMultimap.create();
        Class<?> clazz = listener.getClass();
        for (Method method : AnnotatedSubscriberFinder.getAnnotatedMethods(clazz)) {
            Class<?>[] parameterTypes = method.getParameterTypes();
            Class<?> eventType = parameterTypes[0];
            EventSubscriber subscriber = AnnotatedSubscriberFinder.makeSubscriber((Object)listener, (Method)method);
            methodsInListener.put(eventType, (Object)subscriber);
        }
        return methodsInListener;
    }

    private static ImmutableList<Method> getAnnotatedMethods(Class<?> clazz) {
        try {
            return (ImmutableList)subscriberMethodsCache.getUnchecked(clazz);
        }
        catch (UncheckedExecutionException e) {
            throw Throwables.propagate((Throwable)e.getCause());
        }
    }

    private static ImmutableList<Method> getAnnotatedMethodsInternal(Class<?> clazz) {
        Set supers = TypeToken.of(clazz).getTypes().rawTypes();
        HashMap identifiers = Maps.newHashMap();
        for (Class superClazz : supers) {
            for (Method superClazzMethod : superClazz.getMethods()) {
                if (!superClazzMethod.isAnnotationPresent(Subscribe.class)) continue;
                Class<?>[] parameterTypes = superClazzMethod.getParameterTypes();
                if (parameterTypes.length != 1) {
                    throw new IllegalArgumentException("Method " + superClazzMethod + " has @Subscribe annotation, but requires " + parameterTypes.length + " arguments.  Event subscriber methods must require a single argument.");
                }
                MethodIdentifier ident = new MethodIdentifier(superClazzMethod);
                if (identifiers.containsKey(ident)) continue;
                identifiers.put(ident, superClazzMethod);
            }
        }
        return ImmutableList.copyOf(identifiers.values());
    }

    private static EventSubscriber makeSubscriber(Object listener, Method method) {
        Object wrapper = AnnotatedSubscriberFinder.methodIsDeclaredThreadSafe((Method)method) ? new EventSubscriber(listener, method) : new SynchronizedEventSubscriber(listener, method);
        return wrapper;
    }

    private static boolean methodIsDeclaredThreadSafe(Method method) {
        return method.getAnnotation(AllowConcurrentEvents.class) != null;
    }

    static /* synthetic */ ImmutableList access$000(Class x0) {
        return AnnotatedSubscriberFinder.getAnnotatedMethodsInternal((Class)x0);
    }
}

