/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.hash;

import com.google.common.base.Preconditions;
import com.google.common.hash.Funnel;
import com.google.common.hash.HashCode;
import com.google.common.hash.HashFunction;
import com.google.common.hash.Hasher;
import java.nio.charset.Charset;

abstract class AbstractStreamingHashFunction
implements HashFunction {
    AbstractStreamingHashFunction() {
    }

    public <T> HashCode hashObject(T instance, Funnel<? super T> funnel) {
        return this.newHasher().putObject(instance, funnel).hash();
    }

    public HashCode hashUnencodedChars(CharSequence input) {
        return this.newHasher().putUnencodedChars(input).hash();
    }

    public HashCode hashString(CharSequence input, Charset charset) {
        return this.newHasher().putString(input, charset).hash();
    }

    public HashCode hashInt(int input) {
        return this.newHasher().putInt(input).hash();
    }

    public HashCode hashLong(long input) {
        return this.newHasher().putLong(input).hash();
    }

    public HashCode hashBytes(byte[] input) {
        return this.newHasher().putBytes(input).hash();
    }

    public HashCode hashBytes(byte[] input, int off, int len) {
        return this.newHasher().putBytes(input, off, len).hash();
    }

    public Hasher newHasher(int expectedInputSize) {
        Preconditions.checkArgument((expectedInputSize >= 0 ? 1 : 0) != 0);
        return this.newHasher();
    }
}

