/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.hash;

import com.google.common.hash.AbstractStreamingHashFunction;
import com.google.common.hash.Hasher;
import com.google.common.hash.Murmur3_128HashFunction;
import java.io.Serializable;
import javax.annotation.Nullable;

final class Murmur3_128HashFunction
extends AbstractStreamingHashFunction
implements Serializable {
    private final int seed;
    private static final long serialVersionUID = 0L;

    Murmur3_128HashFunction(int seed) {
        this.seed = seed;
    }

    public int bits() {
        return 128;
    }

    public Hasher newHasher() {
        return new Murmur3_128Hasher(this.seed);
    }

    public String toString() {
        return "Hashing.murmur3_128(" + this.seed + ")";
    }

    public boolean equals(@Nullable Object object) {
        if (object instanceof Murmur3_128HashFunction) {
            Murmur3_128HashFunction other = (Murmur3_128HashFunction)object;
            return this.seed == other.seed;
        }
        return false;
    }

    public int hashCode() {
        return this.getClass().hashCode() ^ this.seed;
    }
}

