/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.math;

import com.google.common.annotations.GwtCompatible;
import com.google.common.annotations.GwtIncompatible;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.math.DoubleMath;
import com.google.common.math.DoubleUtils;
import com.google.common.math.LongMath;
import com.google.common.math.MathPreconditions;
import com.google.common.primitives.Booleans;
import java.math.BigInteger;
import java.math.RoundingMode;
import java.util.Iterator;

/*
 * Exception performing whole class analysis ignored.
 */
@GwtCompatible(emulated=true)
public final class DoubleMath {
    private static final double MIN_INT_AS_DOUBLE = -2.147483648E9;
    private static final double MAX_INT_AS_DOUBLE = 2.147483647E9;
    private static final double MIN_LONG_AS_DOUBLE = -9.223372036854776E18;
    private static final double MAX_LONG_AS_DOUBLE_PLUS_ONE = 9.223372036854776E18;
    private static final double LN_2 = Math.log(2.0);
    @VisibleForTesting
    static final int MAX_FACTORIAL = 170;
    @VisibleForTesting
    static final double[] everySixteenthFactorial = new double[]{1.0, 2.0922789888E13, 2.631308369336935E35, 1.2413915592536073E61, 1.2688693218588417E89, 7.156945704626381E118, 9.916779348709496E149, 1.974506857221074E182, 3.856204823625804E215, 5.5502938327393044E249, 4.7147236359920616E284};

    @GwtIncompatible(value="#isMathematicalInteger, com.google.common.math.DoubleUtils")
    static double roundIntermediate(double x, RoundingMode mode) {
        if (!DoubleUtils.isFinite((double)x)) {
            throw new ArithmeticException("input is infinite or NaN");
        }
        switch (1.$SwitchMap$java$math$RoundingMode[mode.ordinal()]) {
            case 1: {
                MathPreconditions.checkRoundingUnnecessary((boolean)DoubleMath.isMathematicalInteger((double)x));
                return x;
            }
            case 2: {
                if (x >= 0.0 || DoubleMath.isMathematicalInteger((double)x)) {
                    return x;
                }
                return x - 1.0;
            }
            case 3: {
                if (x <= 0.0 || DoubleMath.isMathematicalInteger((double)x)) {
                    return x;
                }
                return x + 1.0;
            }
            case 4: {
                return x;
            }
            case 5: {
                if (DoubleMath.isMathematicalInteger((double)x)) {
                    return x;
                }
                return x + Math.copySign(1.0, x);
            }
            case 6: {
                return Math.rint(x);
            }
            case 7: {
                double z2 = Math.rint(x);
                if (Math.abs(x - z2) == 0.5) {
                    return x + Math.copySign(0.5, x);
                }
                return z2;
            }
            case 8: {
                double z3 = Math.rint(x);
                if (Math.abs(x - z3) == 0.5) {
                    return x;
                }
                return z3;
            }
        }
        throw new AssertionError();
    }

    @GwtIncompatible(value="#roundIntermediate")
    public static int roundToInt(double x, RoundingMode mode) {
        double z2 = DoubleMath.roundIntermediate((double)x, (RoundingMode)mode);
        MathPreconditions.checkInRange((boolean)(z2 > -2.147483649E9 & z2 < 2.147483648E9));
        return (int)z2;
    }

    @GwtIncompatible(value="#roundIntermediate")
    public static long roundToLong(double x, RoundingMode mode) {
        double z2 = DoubleMath.roundIntermediate((double)x, (RoundingMode)mode);
        MathPreconditions.checkInRange((boolean)(-9.223372036854776E18 - z2 < 1.0 & z2 < 9.223372036854776E18));
        return (long)z2;
    }

    @GwtIncompatible(value="#roundIntermediate, java.lang.Math.getExponent, com.google.common.math.DoubleUtils")
    public static BigInteger roundToBigInteger(double x, RoundingMode mode) {
        if (-9.223372036854776E18 - (x = DoubleMath.roundIntermediate((double)x, (RoundingMode)mode)) < 1.0 & x < 9.223372036854776E18) {
            return BigInteger.valueOf((long)x);
        }
        int exponent = Math.getExponent(x);
        long significand = DoubleUtils.getSignificand((double)x);
        BigInteger result = BigInteger.valueOf(significand).shiftLeft(exponent - 52);
        return x < 0.0 ? result.negate() : result;
    }

    @GwtIncompatible(value="com.google.common.math.DoubleUtils")
    public static boolean isPowerOfTwo(double x) {
        return x > 0.0 && DoubleUtils.isFinite((double)x) && LongMath.isPowerOfTwo((long)DoubleUtils.getSignificand((double)x));
    }

    public static double log2(double x) {
        return Math.log(x) / LN_2;
    }

    @GwtIncompatible(value="java.lang.Math.getExponent, com.google.common.math.DoubleUtils")
    public static int log2(double x, RoundingMode mode) {
        boolean increment;
        Preconditions.checkArgument((x > 0.0 && DoubleUtils.isFinite((double)x) ? 1 : 0) != 0, (Object)"x must be positive and finite");
        int exponent = Math.getExponent(x);
        if (!DoubleUtils.isNormal((double)x)) {
            return DoubleMath.log2((double)(x * 4.503599627370496E15), (RoundingMode)mode) - 52;
        }
        switch (1.$SwitchMap$java$math$RoundingMode[mode.ordinal()]) {
            case 1: {
                MathPreconditions.checkRoundingUnnecessary((boolean)DoubleMath.isPowerOfTwo((double)x));
            }
            case 2: {
                increment = false;
                break;
            }
            case 3: {
                increment = !DoubleMath.isPowerOfTwo((double)x);
                break;
            }
            case 4: {
                increment = exponent < 0 & !DoubleMath.isPowerOfTwo((double)x);
                break;
            }
            case 5: {
                increment = exponent >= 0 & !DoubleMath.isPowerOfTwo((double)x);
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                double xScaled = DoubleUtils.scaleNormalize((double)x);
                increment = xScaled * xScaled > 2.0;
                break;
            }
            default: {
                throw new AssertionError();
            }
        }
        return increment ? exponent + 1 : exponent;
    }

    @GwtIncompatible(value="java.lang.Math.getExponent, com.google.common.math.DoubleUtils")
    public static boolean isMathematicalInteger(double x) {
        return DoubleUtils.isFinite((double)x) && (x == 0.0 || 52 - Long.numberOfTrailingZeros(DoubleUtils.getSignificand((double)x)) <= Math.getExponent(x));
    }

    public static double factorial(int n) {
        MathPreconditions.checkNonNegative((String)"n", (int)n);
        if (n > 170) {
            return Double.POSITIVE_INFINITY;
        }
        double accum = 1.0;
        for (int i = 1 + (n & 0xFFFFFFF0); i <= n; ++i) {
            accum *= (double)i;
        }
        return accum * everySixteenthFactorial[n >> 4];
    }

    public static boolean fuzzyEquals(double a2, double b2, double tolerance) {
        MathPreconditions.checkNonNegative((String)"tolerance", (double)tolerance);
        return Math.copySign(a2 - b2, 1.0) <= tolerance || a2 == b2 || Double.isNaN(a2) && Double.isNaN(b2);
    }

    public static int fuzzyCompare(double a2, double b2, double tolerance) {
        if (DoubleMath.fuzzyEquals((double)a2, (double)b2, (double)tolerance)) {
            return 0;
        }
        if (a2 < b2) {
            return -1;
        }
        if (a2 > b2) {
            return 1;
        }
        return Booleans.compare((boolean)Double.isNaN(a2), (boolean)Double.isNaN(b2));
    }

    @GwtIncompatible(value="MeanAccumulator")
    public static double mean(double ... values) {
        MeanAccumulator accumulator = new MeanAccumulator(null);
        for (double value : values) {
            accumulator.add(value);
        }
        return accumulator.mean();
    }

    @GwtIncompatible(value="MeanAccumulator")
    public static double mean(int ... values) {
        MeanAccumulator accumulator = new MeanAccumulator(null);
        for (int value : values) {
            accumulator.add((double)value);
        }
        return accumulator.mean();
    }

    @GwtIncompatible(value="MeanAccumulator")
    public static double mean(long ... values) {
        MeanAccumulator accumulator = new MeanAccumulator(null);
        for (long value : values) {
            accumulator.add((double)value);
        }
        return accumulator.mean();
    }

    @GwtIncompatible(value="MeanAccumulator")
    public static double mean(Iterable<? extends Number> values) {
        MeanAccumulator accumulator = new MeanAccumulator(null);
        for (Number number : values) {
            accumulator.add(number.doubleValue());
        }
        return accumulator.mean();
    }

    @GwtIncompatible(value="MeanAccumulator")
    public static double mean(Iterator<? extends Number> values) {
        MeanAccumulator accumulator = new MeanAccumulator(null);
        while (values.hasNext()) {
            accumulator.add(values.next().doubleValue());
        }
        return accumulator.mean();
    }

    private DoubleMath() {
    }
}

