/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.reflect;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Iterables;
import com.google.common.reflect.Types;
import java.lang.reflect.Array;
import java.lang.reflect.GenericDeclaration;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.lang.reflect.WildcardType;
import java.util.Collection;
import java.util.concurrent.atomic.AtomicReference;
import javax.annotation.Nullable;

/*
 * Exception performing whole class analysis ignored.
 */
final class Types {
    private static final Function<Type, String> TYPE_TO_STRING = new /* Unavailable Anonymous Inner Class!! */;
    private static final Joiner COMMA_JOINER = Joiner.on((String)", ").useForNull("null");

    static Type newArrayType(Type componentType) {
        if (componentType instanceof WildcardType) {
            WildcardType wildcard = (WildcardType)componentType;
            Type[] lowerBounds = wildcard.getLowerBounds();
            Preconditions.checkArgument((lowerBounds.length <= 1 ? 1 : 0) != 0, (Object)"Wildcard cannot have more than one lower bounds.");
            if (lowerBounds.length == 1) {
                return Types.supertypeOf((Type)Types.newArrayType((Type)lowerBounds[0]));
            }
            Type[] upperBounds = wildcard.getUpperBounds();
            Preconditions.checkArgument((upperBounds.length == 1 ? 1 : 0) != 0, (Object)"Wildcard should have only one upper bound.");
            return Types.subtypeOf((Type)Types.newArrayType((Type)upperBounds[0]));
        }
        return JavaVersion.CURRENT.newArrayType(componentType);
    }

    static ParameterizedType newParameterizedTypeWithOwner(@Nullable Type ownerType, Class<?> rawType, Type ... arguments) {
        if (ownerType == null) {
            return Types.newParameterizedType(rawType, (Type[])arguments);
        }
        Preconditions.checkNotNull((Object)arguments);
        Preconditions.checkArgument((rawType.getEnclosingClass() != null ? 1 : 0) != 0, (String)"Owner type for unenclosed %s", (Object[])new Object[]{rawType});
        return new ParameterizedTypeImpl(ownerType, rawType, arguments);
    }

    static ParameterizedType newParameterizedType(Class<?> rawType, Type ... arguments) {
        return new ParameterizedTypeImpl((Type)ClassOwnership.JVM_BEHAVIOR.getOwnerType(rawType), rawType, arguments);
    }

    static <D extends GenericDeclaration> TypeVariable<D> newArtificialTypeVariable(D declaration, String name, Type ... bounds) {
        Type[] typeArray;
        if (bounds.length == 0) {
            Type[] typeArray2 = new Type[1];
            typeArray = typeArray2;
            typeArray2[0] = Object.class;
        } else {
            typeArray = bounds;
        }
        return new TypeVariableImpl(declaration, name, typeArray);
    }

    @VisibleForTesting
    static WildcardType subtypeOf(Type upperBound) {
        return new WildcardTypeImpl(new Type[0], new Type[]{upperBound});
    }

    @VisibleForTesting
    static WildcardType supertypeOf(Type lowerBound) {
        return new WildcardTypeImpl(new Type[]{lowerBound}, new Type[]{Object.class});
    }

    static String toString(Type type) {
        return type instanceof Class ? ((Class)type).getName() : type.toString();
    }

    @Nullable
    static Type getComponentType(Type type) {
        Preconditions.checkNotNull((Object)type);
        AtomicReference result = new AtomicReference();
        new /* Unavailable Anonymous Inner Class!! */.visit(new Type[]{type});
        return (Type)result.get();
    }

    @Nullable
    private static Type subtypeOfComponentType(Type[] bounds) {
        for (Type bound : bounds) {
            Class componentClass;
            Type componentType = Types.getComponentType((Type)bound);
            if (componentType == null) continue;
            if (componentType instanceof Class && (componentClass = (Class)componentType).isPrimitive()) {
                return componentClass;
            }
            return Types.subtypeOf((Type)componentType);
        }
        return null;
    }

    private static Type[] toArray(Collection<Type> types) {
        return types.toArray(new Type[types.size()]);
    }

    private static Iterable<Type> filterUpperBounds(Iterable<Type> bounds) {
        return Iterables.filter(bounds, (Predicate)Predicates.not((Predicate)Predicates.equalTo(Object.class)));
    }

    private static void disallowPrimitiveType(Type[] types, String usedAs) {
        for (Type type : types) {
            if (!(type instanceof Class)) continue;
            Class cls = (Class)type;
            Preconditions.checkArgument((!cls.isPrimitive() ? 1 : 0) != 0, (String)"Primitive type '%s' used as %s", (Object[])new Object[]{cls, usedAs});
        }
    }

    static Class<?> getArrayClass(Class<?> componentType) {
        return Array.newInstance(componentType, 0).getClass();
    }

    private Types() {
    }

    static /* synthetic */ Type access$100(Type[] x0) {
        return Types.subtypeOfComponentType((Type[])x0);
    }

    static /* synthetic */ void access$200(Type[] x0, String x1) {
        Types.disallowPrimitiveType((Type[])x0, (String)x1);
    }

    static /* synthetic */ Type[] access$300(Collection x0) {
        return Types.toArray((Collection)x0);
    }

    static /* synthetic */ Function access$400() {
        return TYPE_TO_STRING;
    }

    static /* synthetic */ Joiner access$500() {
        return COMMA_JOINER;
    }

    static /* synthetic */ Iterable access$600(Iterable x0) {
        return Types.filterUpperBounds((Iterable)x0);
    }
}

