/*
 * Decompiled with CFR 0.152.
 */
package cpw.mods.fml.common;

import java.io.PrintStream;
import org.apache.logging.log4j.Logger;

public class TracingPrintStream
extends PrintStream {
    private Logger logger;
    private int BASE_DEPTH = 3;

    public TracingPrintStream(Logger logger, PrintStream original) {
        super(original);
        this.logger = logger;
    }

    @Override
    public void println(Object o) {
        this.logger.info(this.getPrefix() + o);
    }

    @Override
    public void println(String s) {
        this.logger.info(this.getPrefix() + s);
    }

    private String getPrefix() {
        StackTraceElement[] elems = Thread.currentThread().getStackTrace();
        StackTraceElement elem = elems[this.BASE_DEPTH];
        if (elem.getClassName().startsWith("kotlin.io.")) {
            elem = elems[this.BASE_DEPTH + 2];
        }
        return "[" + elem.getClassName() + ":" + elem.getMethodName() + ":" + elem.getLineNumber() + "]: ";
    }

    @Override
    public void close() {
    }
}

