/*
 * Decompiled with CFR 0.152.
 */
package cpw.mods.fml.common.registry;

import com.google.common.base.Throwables;
import cpw.mods.fml.common.FMLLog;
import cpw.mods.fml.common.registry.FMLControlledNamespacedRegistry;
import cpw.mods.fml.common.registry.GameData;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import org.apache.logging.log4j.Level;

class ObjectHolderRef {
    private Field field;
    private String injectedObject;
    private boolean isBlock;
    private boolean isItem;
    private static Field modifiersField;
    private static Object reflectionFactory;
    private static Method newFieldAccessor;
    private static Method fieldAccessorSet;

    ObjectHolderRef(Field field, String injectedObject, boolean extractFromExistingValues) {
        this.field = field;
        this.isBlock = aji.class.isAssignableFrom(field.getType());
        this.isItem = adb.class.isAssignableFrom(field.getType());
        if (extractFromExistingValues) {
            try {
                Object existing = field.get(null);
                if (existing == null || existing == GameData.getBlockRegistry().getDefaultValue()) {
                    this.injectedObject = null;
                    this.field = null;
                    this.isBlock = false;
                    this.isItem = false;
                    return;
                }
                this.injectedObject = this.isBlock ? GameData.getBlockRegistry().c(existing) : (this.isItem ? GameData.getItemRegistry().c(existing) : null);
            }
            catch (Exception e) {
                throw Throwables.propagate((Throwable)e);
            }
        } else {
            this.injectedObject = injectedObject;
        }
        if (this.injectedObject == null || !this.isValid()) {
            throw new IllegalStateException(String.format("The ObjectHolder annotation cannot apply to a field that is not an Item or Block (found : %s at %s.%s)", field.getType().getName(), field.getClass().getName(), field.getName()));
        }
        ObjectHolderRef.makeWritable(field);
    }

    private static void makeWritable(Field f) {
        try {
            f.setAccessible(true);
        }
        catch (Exception e) {
            throw Throwables.propagate((Throwable)e);
        }
    }

    public boolean isValid() {
        return this.isBlock || this.isItem;
    }

    public void apply() {
        Object thing;
        if (this.isBlock) {
            FMLControlledNamespacedRegistry<aji> registry = GameData.getBlockRegistry();
            thing = registry.a(this.injectedObject);
            if (thing == ajn.a) {
                thing = null;
            }
        } else if (this.isItem) {
            FMLControlledNamespacedRegistry<adb> registry = GameData.getItemRegistry();
            thing = registry.a(this.injectedObject);
        } else {
            thing = null;
        }
        if (thing == null) {
            FMLLog.getLogger().log(Level.DEBUG, "Unable to lookup {} for {}. This means the object wasn't registered. It's likely just mod options.", new Object[]{this.injectedObject, this.field});
            return;
        }
        try {
            this.field.set(null, thing);
            FMLLog.finer("Set field " + this.field.toString() + " to " + thing, new Object[0]);
        }
        catch (Throwable e) {
            FMLLog.log(Level.WARN, e, "Unable to set %s with value %s (%s)", this.field, thing, this.injectedObject);
        }
    }
}

