/*
 * Decompiled with CFR 0.152.
 */
package io.github.crucible.bootstrap;

import io.github.crucible.bootstrap.CrucibleMetadata;
import io.github.crucible.bootstrap.LibraryManager;
import io.github.crucible.bootstrap.Lwjgl3ifyGlue;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.PrintStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;

public class CrucibleServerMainHook {
    private static final String[] REPOS = new String[]{"https://github.com/juanmuscaria/maven/raw/master/", "https://github.com/juanmuscaria/maven/raw/master/ThermosLibs/", "https://maven.minecraftforge.net/", "https://libraries.minecraft.net/", "https://repo.maven.apache.org/maven2/"};
    private static final Path LIBRARY_ROOT = Paths.get("libraries", new String[0]).toAbsolutePath();
    public static final PrintStream originalOut = System.out;
    public static final PrintStream originalErr = System.err;

    public static void relaunchMain(String[] args) throws Exception {
        System.out.println("[Crucible] Running pre-launch tweaks");
        File injectFile = new File("inject.properties");
        if (!injectFile.exists()) {
            Properties internalProperties = new Properties();
            try {
                internalProperties.load(CrucibleServerMainHook.class.getClassLoader().getResourceAsStream("inject.properties"));
                internalProperties.store(Files.newOutputStream(injectFile.toPath(), new OpenOption[0]), "All properties in this file will be injected into System Properties before the server starts. Useful for shared hostings");
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        Properties propertiesToInject = new Properties();
        try {
            propertiesToInject.load(new FileReader(injectFile));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        for (Map.Entry<Object, Object> entry : propertiesToInject.entrySet()) {
            System.setProperty((String)entry.getKey(), (String)entry.getValue());
        }
        Lwjgl3ifyGlue.checkJava();
        if (!CrucibleServerMainHook.verifyLibraries()) {
            CrucibleServerMainHook.setupLibraries();
            System.out.println("[Crucible] Crucible installed! A restart is required to be able to boot.");
            System.exit(0);
        } else {
            System.out.println("[Crucible] Everything in check, booting the server");
        }
    }

    public static void serverMain(String[] args) {
        if (Boolean.parseBoolean(System.getProperty("crucible.i.know.what.i.am.doing.please.crash.the.server"))) {
            throw new RuntimeException("crucible.i.know.what.i.am.doing.please.crash.the.server=true! If you say so, crashing the server as you asked!");
        }
    }

    private static boolean verifyLibraries() throws IOException, NoSuchAlgorithmException {
        if (Boolean.parseBoolean(System.getProperty("crucible.skipLibraryVerification"))) {
            System.out.println("[Crucible] Skipping library integrity verification");
            return true;
        }
        if (!Files.isDirectory(LIBRARY_ROOT, new LinkOption[0])) {
            return false;
        }
        return LibraryManager.checkIntegrity(LIBRARY_ROOT, CrucibleMetadata.NEEDED_LIBRARIES);
    }

    private static void setupLibraries() throws InterruptedException {
        System.out.println("[Crucible] Setting up server libraries, it may take a few minutes");
        if (Files.exists(LIBRARY_ROOT, new LinkOption[0]) && !Files.isDirectory(LIBRARY_ROOT, new LinkOption[0])) {
            throw new IllegalStateException(String.format("Library root '%s' is a file, aborting startup!", LIBRARY_ROOT.toAbsolutePath()));
        }
        String[] userDefinedRepos = System.getProperty("crucible.libraryRepos", "").split(" ");
        ArrayList<String> list = new ArrayList<String>();
        Iterator iterator = Arrays.asList(REPOS, userDefinedRepos).iterator();
        while (iterator.hasNext()) {
            String[] strings;
            for (String s : strings = (String[])iterator.next()) {
                if (s.isEmpty()) continue;
                list.add(s);
            }
        }
        LibraryManager.downloadMavenLibraries(LIBRARY_ROOT, list.toArray(new String[0]), CrucibleMetadata.NEEDED_LIBRARIES);
    }

    public static void restoreStreams() {
        System.setOut(originalOut);
        System.setErr(originalErr);
    }
}

