/*
 * Decompiled with CFR 0.152.
 */
package io.github.crucible.bootstrap;

import io.github.crucible.bootstrap.ProgressiveObject;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;

public class DownloadProgressBar
extends Thread {
    private static final String[] TERMS = new String[]{"xterm"};
    private static final boolean FANCY_PROGRESS;
    private final List<? extends ProgressiveObject> objectsToObserve;
    private final AtomicBoolean running = new AtomicBoolean();
    private final AtomicInteger counter = new AtomicInteger();

    public DownloadProgressBar(List<? extends ProgressiveObject> objectsToObserve) {
        this.objectsToObserve = objectsToObserve;
        for (ProgressiveObject progressiveObject : this.objectsToObserve) {
            progressiveObject.offerFinishCounter(this.counter);
        }
    }

    @Override
    public void run() {
        this.running.set(true);
        if (FANCY_PROGRESS) {
            int lines = 0;
            int width = 10;
            StringBuilder buffer = new StringBuilder();
            while (this.running.get()) {
                buffer.setLength(0);
                this.clearLines(buffer, lines);
                lines = 1;
                buffer.append(String.format("[Crucible] %s out of %s files downloaded\n", this.counter.get(), this.objectsToObserve.size()));
                for (ProgressiveObject progressiveObject : this.objectsToObserve) {
                    if (!progressiveObject.isInProgress()) continue;
                    buffer.append("    [");
                    int chars = (int)(progressiveObject.getProgress() / 100.0 * (double)width);
                    for (int i = 0; i < width; ++i) {
                        if (i <= chars) {
                            buffer.append('#');
                            continue;
                        }
                        buffer.append(' ');
                    }
                    buffer.append(String.format("] %.2f%% > %s \n", progressiveObject.getProgress(), progressiveObject.displayName()));
                    ++lines;
                }
                System.out.print(buffer);
                Thread.yield();
                try {
                    Thread.sleep(50L);
                }
                catch (InterruptedException e) {
                    this.interrupt();
                    this.running.set(false);
                }
            }
            buffer.setLength(0);
            this.clearLines(buffer, lines);
            System.out.print(buffer);
        } else {
            int lastCount = 0;
            System.out.printf("[Crucible] %s out of %s files downloaded\n", this.counter.get(), this.objectsToObserve.size());
            while (this.running.get()) {
                try {
                    if (this.counter.get() > lastCount) {
                        lastCount = this.counter.get();
                        System.out.printf("[Crucible] %s out of %s files downloaded\n", lastCount, this.objectsToObserve.size());
                    }
                    Thread.sleep(500L);
                }
                catch (InterruptedException e) {
                    this.interrupt();
                    this.running.set(false);
                }
            }
        }
    }

    private void clearLines(StringBuilder buffer, int lines) {
        if (lines > 0) {
            buffer.append("\u001b[").append(lines).append("A\r");
            for (int i = 0; i < lines; ++i) {
                for (int j = 0; j < 100; ++j) {
                    buffer.append(' ');
                }
                buffer.append('\n');
            }
            buffer.append("\u001b[").append(lines).append("A\r");
        }
    }

    public void finish() {
        this.running.set(false);
    }

    static {
        String terminal = System.getenv("TERM") == null ? "" : System.getenv("TERM");
        FANCY_PROGRESS = false;
    }
}

