/*
 * Decompiled with CFR 0.152.
 */
package io.github.crucible.bootstrap;

import io.github.crucible.bootstrap.DownloadProgressBar;
import io.github.crucible.bootstrap.ProgressiveObject;
import java.io.ByteArrayInputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.nio.ByteOrder;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.security.DigestInputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicInteger;
import org.jetbrains.annotations.NotNull;

public class LibraryManager {
    private static final char[] LOOKUP_TABLE_LOWER = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};
    private static final char[] LOOKUP_TABLE_UPPER = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};

    public static void downloadMavenLibraries(Path baseDir, String[] repos, String ... libraries) throws InterruptedException {
        if (repos.length == 0) {
            throw new IllegalArgumentException("A repo url list must be provided");
        }
        URI[] reposUri = new URI[repos.length];
        for (int i = 0; i < repos.length; ++i) {
            reposUri[i] = URI.create(repos[i]);
        }
        ForkJoinPool pool = new ForkJoinPool(Runtime.getRuntime().availableProcessors() * 2 + 1);
        ArrayList<DownloadTask<Boolean>> tasks = new ArrayList<DownloadTask<Boolean>>(libraries.length);
        for (String library : libraries) {
            tasks.add(LibraryManager.makeMavenDownloadTask(baseDir, reposUri, library));
        }
        DownloadProgressBar progressBar = new DownloadProgressBar(tasks);
        progressBar.start();
        List futures = pool.invokeAll(tasks);
        progressBar.finish();
        boolean failed = false;
        for (Future future : futures) {
            try {
                future.get();
            }
            catch (ExecutionException e) {
                failed = true;
                e.printStackTrace();
            }
        }
        if (failed) {
            throw new RuntimeException("Failed to download one or more essential files for the server, check your logs for more information");
        }
    }

    private static DownloadTask<Boolean> makeMavenDownloadTask(final Path baseDir, final URI[] repos, String library) {
        final String[] identifiers = library.split(":");
        if (identifiers.length != 3) {
            throw new IllegalArgumentException("Invalid identifier " + library);
        }
        return new DownloadTask<Boolean>(){
            final String jarRelativeName;
            final Path jarFile;
            final Path checksumFie;
            boolean complete;
            CountableInputStream countableInputStream;
            AtomicInteger counter;
            {
                this.jarRelativeName = String.format("./%1$s/%2$s/%3$s/%2$s-%3$s.jar", identifiers[0].replace('.', '/'), identifiers[1], identifiers[2]);
                this.jarFile = baseDir.resolve(this.jarRelativeName).normalize().toAbsolutePath();
                this.checksumFie = baseDir.resolve(this.jarRelativeName + ".md5").normalize().toAbsolutePath();
            }

            @Override
            public double getProgress() {
                if (this.complete) {
                    return 100.0;
                }
                if (this.countableInputStream != null) {
                    return this.countableInputStream.getPercentage();
                }
                return 0.0;
            }

            @Override
            public boolean isInProgress() {
                return !this.complete && this.countableInputStream != null;
            }

            @Override
            public String displayName() {
                return this.jarFile.getFileName().toString();
            }

            @Override
            public void offerFinishCounter(AtomicInteger counter) {
                this.counter = counter;
            }

            @Override
            public Boolean call() throws Exception {
                if (Files.isRegularFile(this.jarFile, new LinkOption[0]) && Files.isRegularFile(this.checksumFie, new LinkOption[0])) {
                    String checksum = String.join((CharSequence)"", Files.readAllLines(this.checksumFie));
                    if (checksum.equals("skip")) {
                        return false;
                    }
                    MessageDigest digest = MessageDigest.getInstance("MD5");
                    if (checksum.equalsIgnoreCase(LibraryManager.encodeHex(digest.digest(Files.readAllBytes(this.jarFile))))) {
                        return false;
                    }
                }
                ArrayList<IOException> downloadErrors = new ArrayList<IOException>();
                URL file = null;
                for (URI repo : repos) {
                    try {
                        MessageDigest digest = MessageDigest.getInstance("MD5");
                        URI uriPath = repo.resolve(this.jarRelativeName).normalize();
                        file = uriPath.toURL();
                        HttpURLConnection connection = (HttpURLConnection)file.openConnection();
                        connection.setRequestMethod("GET");
                        connection.connect();
                        if (connection.getResponseCode() >= 200 || connection.getResponseCode() <= 399) {
                            this.countableInputStream = new CountableInputStream(connection.getInputStream(), connection.getContentLength());
                            try (DigestInputStream in = new DigestInputStream(this.countableInputStream, digest);){
                                Files.createDirectories(this.jarFile.getParent(), new FileAttribute[0]);
                                Files.copy(in, this.jarFile, StandardCopyOption.REPLACE_EXISTING);
                                Files.copy(new ByteArrayInputStream(LibraryManager.encodeHex(digest.digest()).getBytes(StandardCharsets.UTF_8)), this.checksumFie, StandardCopyOption.REPLACE_EXISTING);
                            }
                        } else {
                            throw new IOException(String.format("Bad response (%s) from %s", connection.getResponseMessage(), file));
                        }
                        connection.disconnect();
                        this.complete = true;
                        this.counter.incrementAndGet();
                        return true;
                    }
                    catch (MalformedURLException | NoSuchAlgorithmException e) {
                        throw new RuntimeException("An exception that should never happen actually happened", e);
                    }
                    catch (IOException e) {
                        e.addSuppressed(new IOException("Unable to download from url " + file));
                        downloadErrors.add(e);
                    }
                }
                System.out.println("The following errors happened while trying to download " + this.jarFile.getFileName());
                for (Exception exception : downloadErrors) {
                    exception.printStackTrace();
                }
                throw new IllegalStateException("Unable to download " + this.jarFile.getFileName());
            }
        };
    }

    public static boolean checkIntegrity(Path libraryRoot, String[] neededLibraries) throws IOException, NoSuchAlgorithmException {
        for (String neededLibrary : neededLibraries) {
            String[] identifiers = neededLibrary.split(":");
            if (identifiers.length != 3) {
                throw new IllegalArgumentException("Invalid identifier " + neededLibrary);
            }
            String jarRelativeName = String.format("./%1$s/%2$s/%3$s/%2$s-%3$s.jar", identifiers[0].replace('.', '/'), identifiers[1], identifiers[2]);
            Path jarFile = libraryRoot.resolve(jarRelativeName).normalize().toAbsolutePath();
            Path checksumFie = libraryRoot.resolve(jarRelativeName + ".md5").normalize().toAbsolutePath();
            if (Files.isRegularFile(jarFile, new LinkOption[0]) && Files.isRegularFile(checksumFie, new LinkOption[0])) {
                String checksum = String.join((CharSequence)"", Files.readAllLines(checksumFie));
                if (checksum.equals("skip")) {
                    System.out.println("[Crucible] Skipping verification of " + neededLibrary);
                    continue;
                }
                MessageDigest digest = MessageDigest.getInstance("MD5");
                if (checksum.equalsIgnoreCase(LibraryManager.encodeHex(digest.digest(Files.readAllBytes(jarFile))))) continue;
                return false;
            }
            return false;
        }
        return true;
    }

    public static String encodeHex(byte[] byteArray, boolean upperCase, ByteOrder byteOrder) {
        char[] buffer = new char[byteArray.length * 2];
        char[] lookup = upperCase ? LOOKUP_TABLE_UPPER : LOOKUP_TABLE_LOWER;
        for (int i = 0; i < byteArray.length; ++i) {
            int index = byteOrder == ByteOrder.BIG_ENDIAN ? i : byteArray.length - i - 1;
            buffer[i << 1] = lookup[byteArray[index] >> 4 & 0xF];
            buffer[(i << 1) + 1] = lookup[byteArray[index] & 0xF];
        }
        return new String(buffer);
    }

    public static String encodeHex(byte[] byteArray) {
        return LibraryManager.encodeHex(byteArray, false, ByteOrder.BIG_ENDIAN);
    }

    public static interface DownloadTask<T>
    extends Callable<T>,
    ProgressiveObject {
    }

    public static class CountableInputStream
    extends FilterInputStream {
        private final long size;
        private long readCount = 0L;

        public double getPercentage() {
            if (this.size > 1L) {
                return (double)this.readCount * 100.0 / (double)this.size;
            }
            return 0.0;
        }

        public CountableInputStream(InputStream in, long size) {
            super(in);
            this.size = size;
        }

        @Override
        public int read() throws IOException {
            int count = this.in.read();
            if (count >= 0) {
                ++this.readCount;
            }
            return count;
        }

        @Override
        public int read(@NotNull byte[] b2) throws IOException {
            int count = this.in.read(b2);
            if (count > 0) {
                this.readCount += (long)count;
            }
            return count;
        }

        @Override
        public int read(@NotNull byte[] b2, int off, int len) throws IOException {
            int count = this.in.read(b2, off, len);
            if (count > 0) {
                this.readCount += (long)count;
            }
            return count;
        }

        @Override
        public long skip(long n) throws IOException {
            long count = this.in.skip(n);
            if (count > 0L) {
                this.readCount += count;
            }
            return count;
        }

        @Override
        public synchronized void reset() throws IOException {
            this.in.reset();
            this.readCount = this.size - (long)this.in.available();
        }
    }
}

